/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.qute.components.deployment;

import io.quarkiverse.web.bundler.deployment.items.QuteTagsBuildItem;
import io.quarkiverse.web.bundler.deployment.items.WebAsset;
import io.quarkiverse.web.bundler.qute.components.runtime.WebBundlerQuteContextRecorder;
import io.quarkiverse.web.bundler.qute.components.runtime.WebBundlerQuteEngineObserver;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import org.jboss.logging.Logger;

class WebBundlerQuteComponentsProcessor {
    private static final Logger LOGGER = Logger.getLogger(WebBundlerQuteComponentsProcessor.class);

    WebBundlerQuteComponentsProcessor() {
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void initQuteTags(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, WebBundlerQuteContextRecorder recorder, QuteTagsBuildItem quteTags) {
        HashMap<CallSite, String> templates = new HashMap<CallSite, String>();
        ArrayList<String> tags = new ArrayList<String>();
        for (WebAsset webAsset : quteTags.getWebAssets()) {
            String tag = ((Path)webAsset.filePath().get()).getFileName().toString();
            String tagName = tag.contains(".") ? tag.substring(0, tag.indexOf(46)) : tag;
            templates.put((CallSite)((Object)("web-bundler/" + tagName)), new String(webAsset.readContentFromFile(), webAsset.charset()));
            tags.add(tagName);
        }
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{WebBundlerQuteEngineObserver.class}));
        syntheticBeans.produce((BuildItem)SyntheticBeanBuildItem.configure(WebBundlerQuteContextRecorder.WebBundlerQuteContext.class).supplier(recorder.createContext(tags, templates)).done());
    }
}

