/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.qute.components.deployment;

import io.quarkiverse.web.bundler.deployment.items.QuteTagsBuildItem;
import io.quarkiverse.web.bundler.deployment.items.WebAsset;
import io.quarkiverse.web.bundler.qute.components.runtime.WebBundlerQuteContextRecorder;
import io.quarkiverse.web.bundler.qute.components.runtime.WebBundlerQuteEngineObserver;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import org.jboss.logging.Logger;

class WebBundlerQuteComponentsProcessor {
    private static final Logger LOGGER = Logger.getLogger(WebBundlerQuteComponentsProcessor.class);

    WebBundlerQuteComponentsProcessor() {
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void initQuteTags(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, WebBundlerQuteContextRecorder recorder, Optional<QuteTagsBuildItem> quteTags) {
        if (quteTags.isEmpty()) {
            return;
        }
        HashMap<CallSite, String> templates = new HashMap<CallSite, String>();
        ArrayList<String> tags = new ArrayList<String>();
        for (WebAsset webAsset : quteTags.get().getWebAssets()) {
            String tag = webAsset.resource().path().getFileName().toString();
            String tagName = tag.contains(".") ? tag.substring(0, tag.indexOf(46)) : tag;
            try {
                templates.put((CallSite)((Object)("web-bundler/" + tagName)), Files.readString(webAsset.resource().path(), webAsset.charset()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            tags.add(tagName);
        }
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{WebBundlerQuteEngineObserver.class}));
        syntheticBeans.produce((BuildItem)SyntheticBeanBuildItem.configure(WebBundlerQuteContextRecorder.WebBundlerQuteContext.class).supplier(recorder.createContext(tags, templates)).done());
    }
}

