/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.sass;

import de.larsgrefer.sass.embedded.SassCompilationFailedException;
import de.larsgrefer.sass.embedded.SassCompiler;
import de.larsgrefer.sass.embedded.SassCompilerFactory;
import de.larsgrefer.sass.embedded.importer.CustomImporter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import sass.embedded_protocol.EmbeddedSass;

public class SassBuildTimeCompiler
implements BiFunction<String[], BiConsumer<String, String>, String> {
    @Override
    public String apply(String[] args, BiConsumer<String, String> dependencyCollector) {
        Path sassFile = Path.of(args[0], new String[0]);
        Path rootPath = Path.of(args[2], new String[0]);
        return SassBuildTimeCompiler.convertScss(sassFile, rootPath, dependencyCollector);
    }

    public static boolean isSassFile(String filename) {
        String lc = filename.toLowerCase();
        return lc.endsWith(".sass");
    }

    public static String convertScss(Path sassFile, final Path rootPath, final BiConsumer<String, String> dependencyCollector) {
        String string;
        block9: {
            final String relativePath = sassFile.relativize(rootPath).toString();
            dependencyCollector.accept(relativePath, relativePath);
            final boolean isSass = SassBuildTimeCompiler.isSassFile(sassFile.getFileName().toString());
            SassCompiler sassCompiler = SassCompilerFactory.bundled();
            try {
                final Path parent = sassFile.getParent();
                sassCompiler.registerImporter(new CustomImporter(){

                    public String canonicalize(String url, boolean fromImport) throws Exception {
                        Path resolved;
                        String extension;
                        String string = extension = isSass ? ".sass" : ".scss";
                        if (!((String)url).toLowerCase().endsWith(extension)) {
                            url = (String)url + extension;
                        }
                        if (!(resolved = parent.resolve((String)url)).getFileName().toString().startsWith("_")) {
                            resolved = resolved.getParent().resolve("_" + resolved.getFileName().toString());
                        }
                        return "sass:" + resolved;
                    }

                    public EmbeddedSass.InboundMessage.ImportResponse.ImportSuccess handleImport(String url) throws Exception {
                        if (url.startsWith("sass:")) {
                            Path path = Path.of(url.substring(5), new String[0]);
                            Path relativeImport = rootPath.relativize(path);
                            dependencyCollector.accept(relativeImport.toString(), relativePath);
                            String contents = Files.readString(path, StandardCharsets.UTF_8);
                            return EmbeddedSass.InboundMessage.ImportResponse.ImportSuccess.newBuilder().setContents(contents).setSyntax(isSass ? EmbeddedSass.Syntax.INDENTED : EmbeddedSass.Syntax.SCSS).buildPartial();
                        }
                        return null;
                    }
                });
                String contents = Files.readString(sassFile, StandardCharsets.UTF_8);
                EmbeddedSass.InboundMessage.CompileRequest.StringInput stringInput = EmbeddedSass.InboundMessage.CompileRequest.StringInput.newBuilder().setSource(contents).setUrl(sassFile.toString()).setSyntax(isSass ? EmbeddedSass.Syntax.INDENTED : EmbeddedSass.Syntax.SCSS).build();
                EmbeddedSass.OutboundMessage.CompileResponse.CompileSuccess compileSuccess = sassCompiler.compileString(stringInput, EmbeddedSass.OutputStyle.EXPANDED);
                string = compileSuccess.getCss();
                if (sassCompiler == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (sassCompiler != null) {
                        try {
                            sassCompiler.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                catch (SassCompilationFailedException e) {
                    throw new RuntimeException(e);
                }
            }
            sassCompiler.close();
        }
        return string;
    }
}

