/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.runtime.qute;

import io.quarkiverse.web.bundler.runtime.qute.WebBundlerQuteContextRecorder;
import io.quarkus.qute.EngineBuilder;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.UserTagSectionHelper;
import io.quarkus.qute.Variant;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.Reader;
import java.io.StringReader;
import java.util.Optional;
import org.jboss.logging.Logger;

@Singleton
public class WebBundlerQuteEngineObserver {
    private static final Logger LOGGER = Logger.getLogger(WebBundlerQuteEngineObserver.class);
    private final WebBundlerQuteContextRecorder.WebBundlerQuteContext webBundlerQuteContext;

    @Inject
    public WebBundlerQuteEngineObserver(WebBundlerQuteContextRecorder.WebBundlerQuteContext context) {
        this.webBundlerQuteContext = context;
    }

    void observeEngineBuilder(@Observes EngineBuilder builder) {
        builder.addLocator(this::locate);
        for (String tag : this.webBundlerQuteContext.tags()) {
            String tagTemplateId = "web-bundler/" + tag;
            LOGGER.debugf("Registered UserTagSectionHelper for %s [%s]", (Object)tag, (Object)tagTemplateId);
            builder.addSectionHelper((SectionHelperFactory)new UserTagSectionHelper.Factory(tag, tagTemplateId));
        }
    }

    private Optional<TemplateLocator.TemplateLocation> locate(final String s) {
        if (!s.startsWith("web-bundler/") || !this.webBundlerQuteContext.templates().containsKey(s)) {
            return Optional.empty();
        }
        return Optional.of(new TemplateLocator.TemplateLocation(){

            public Reader read() {
                return new StringReader(WebBundlerQuteEngineObserver.this.webBundlerQuteContext.templates().get(s));
            }

            public Optional<Variant> getVariant() {
                return Optional.empty();
            }
        });
    }
}

