/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.runtime;

import io.quarkiverse.web.bundler.runtime.WebBundlerHandlerConfig;
import io.quarkiverse.web.bundler.runtime.WebBundlerResourceHandler;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.Collection;
import java.util.Set;

@Recorder
public class WebBundlerResourceRecorder {
    private final RuntimeValue<HttpConfiguration> httpConfiguration;
    private final Set<String> compressMediaTypes;

    public WebBundlerResourceRecorder(RuntimeValue<HttpConfiguration> httpConfiguration, HttpBuildTimeConfig httpBuildTimeConfig) {
        this.httpConfiguration = httpConfiguration;
        this.compressMediaTypes = httpBuildTimeConfig.enableCompression && httpBuildTimeConfig.compressMediaTypes.isPresent() ? Set.copyOf((Collection)httpBuildTimeConfig.compressMediaTypes.get()) : Set.of();
    }

    public Handler<RoutingContext> createHandler(String directory, Set<String> webResources, boolean devMode) {
        WebBundlerHandlerConfig handlerConfig = new WebBundlerHandlerConfig(((HttpConfiguration)this.httpConfiguration.getValue()).staticResources.indexPage, devMode, this.compressMediaTypes);
        return new WebBundlerResourceHandler(handlerConfig, directory, webResources);
    }
}

