/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.runtime.devmode;

import io.quarkiverse.web.bundler.runtime.WebBundlerResourceRecorder;
import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.dev.spi.HotReplacementSetup;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class WebBundlerHotReplacementSetup
implements HotReplacementSetup {
    private static final Logger LOGGER = Logger.getLogger(WebBundlerHotReplacementSetup.class);
    private final List<Consumer<Set<String>>> changeEventListeners = new CopyOnWriteArrayList<Consumer<Set<String>>>();
    static final ScheduledExecutorService EXECUTOR = Executors.newSingleThreadScheduledExecutor();
    private volatile long nextUpdate = 0L;
    private ScheduledFuture<?> scheduler;
    private HotReplacementContext context;

    public void setupHotDeployment(HotReplacementContext context) {
        this.context = context;
        context.consumeNoRestartChanges(this::noRestartChanges);
        WebBundlerResourceRecorder.setHotDeploymentEventHandlerRegister(r -> {
            this.changeEventListeners.add((Consumer<Set<String>>)r);
            return () -> this.changeEventListeners.remove(r);
        });
        WebBundlerResourceRecorder.setStartWatchScheduler(this::startWatchScheduler);
    }

    private void startWatchScheduler() {
        if (this.scheduler == null) {
            this.scheduler = EXECUTOR.scheduleAtFixedRate(() -> {
                try {
                    if (this.context.getDeploymentProblem() == null && System.currentTimeMillis() > this.nextUpdate) {
                        if (this.context.doScan(false)) {
                            LOGGER.debug((Object)"App restarted from watcher, let's wait 5s before watching again");
                            this.nextUpdate = System.currentTimeMillis() + 5000L;
                        } else {
                            this.nextUpdate = System.currentTimeMillis() + 1000L;
                        }
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }, 500L, 500L, TimeUnit.MILLISECONDS);
        }
    }

    public void close() {
        super.close();
        if (this.scheduler != null) {
            this.scheduler.cancel(false);
            this.scheduler = null;
        }
    }

    private void noRestartChanges(Set<String> strings) {
        for (Consumer<Set<String>> changeEventListener : this.changeEventListeners) {
            changeEventListener.accept(strings);
        }
    }
}

