/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.runtime.devmode;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.runtime.ShutdownContext;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.logging.Logger;

public class ChangeEventHandler
implements Handler<RoutingContext> {
    private static final Logger LOGGER = Logger.getLogger(ChangeEventHandler.class);
    private static final String NL = "\n";
    private static final List<String> IGNORED_SUFFIX = List.of(".map");
    public static final String MEDIA_TYPE_TEXT_EVENT_STREAM = "text/event-stream";
    private final String webRoot;
    private final Map<String, Long> lastModifiedMap;
    private final List<Connection> connections = new CopyOnWriteArrayList<Connection>();
    private final ClassLoader cl;
    private final Path directory;
    private final Runnable unRegisterChangeListener;

    public ChangeEventHandler(Function<Consumer<Set<String>>, Runnable> registerHandler, String directory, String webRoot, Set<String> webResources, ShutdownContext shutdownContext) {
        this.directory = Path.of(directory, new String[0]);
        this.webRoot = webRoot;
        this.lastModifiedMap = this.initLastModifiedMap(webResources);
        this.cl = Thread.currentThread().getContextClassLoader();
        this.unRegisterChangeListener = registerHandler.apply(this::onChange);
        shutdownContext.addShutdownTask(this::onShutdown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onShutdown() {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        try {
            this.unRegisterChangeListener.run();
            for (Connection connection : this.connections) {
                this.closeConnection(connection);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    private Map<String, Long> initLastModifiedMap(Set<String> webResources) {
        if (!Files.isDirectory(this.directory, new LinkOption[0])) {
            throw new IllegalStateException(this.directory + " should exist on disk.");
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        try {
            for (String webResource : webResources) {
                Path file;
                String relativePath = webResource.substring(1);
                if (ChangeEventHandler.matches(IGNORED_SUFFIX, relativePath) || !Files.isRegularFile(file = this.directory.resolve(relativePath), new LinkOption[0])) continue;
                map.put(webResource, Files.getLastModifiedTime(file, new LinkOption[0]).toMillis());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new ConcurrentHashMap<String, Long>(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChange(Set<String> srcChanges) {
        boolean isWebChange;
        boolean isBundlingError = srcChanges.contains("web-bundler/build-error");
        boolean bl = isWebChange = isBundlingError || srcChanges.contains("web-bundler/build-success") || srcChanges.stream().anyMatch(s -> s.startsWith(this.webRoot));
        if (!isWebChange) {
            return;
        }
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        try {
            Changes changes = this.computeChanges();
            LOGGER.info((Object)changes);
            for (Connection connection : this.connections) {
                if (connection.closed().get() || connection.ctx().response().closed()) continue;
                if (isBundlingError) {
                    connection.ctx.response().write("event: bundling-error\ndata:\n\n");
                    continue;
                }
                if (changes.added.isEmpty() && changes.removed.isEmpty() && changes.updated.isEmpty()) continue;
                JsonObject eventData = new JsonObject();
                eventData.put("added", (Object)new JsonArray(changes.added));
                eventData.put("removed", (Object)new JsonArray(changes.removed));
                eventData.put("updated", (Object)new JsonArray(changes.updated));
                StringBuilder b = new StringBuilder();
                ChangeEventHandler.writeField(b, "id", String.valueOf(connection.counter().getAndIncrement()));
                ChangeEventHandler.writeField(b, "event", "change");
                ChangeEventHandler.writeField(b, "data", eventData.encode());
                b.append(NL);
                connection.ctx.response().write(b.toString());
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    private static void writeField(StringBuilder sb, String field, String value) {
        sb.append(field).append(": ").append(value.replaceAll("\\v", "")).append(NL);
    }

    private Changes computeChanges() {
        ArrayList<String> updated = new ArrayList<String>();
        ArrayList<String> removed = new ArrayList<String>();
        for (String key : this.lastModifiedMap.keySet()) {
            this.lastModifiedMap.compute(key, (k, prevLastModified) -> {
                long lastModified;
                String relativePath = k.substring(1);
                Path file = this.directory.resolve(relativePath);
                if (!Files.isRegularFile(file, new LinkOption[0])) {
                    removed.add((String)k);
                    return null;
                }
                try {
                    lastModified = Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                if (prevLastModified == null) {
                    return lastModified;
                }
                if (lastModified > prevLastModified) {
                    updated.add((String)k);
                    return lastModified;
                }
                return lastModified;
            });
        }
        return new Changes(List.of(), removed, updated);
    }

    public void handle(RoutingContext routingContext) {
        if (this.connections.size() > 2) {
            routingContext.response().setStatusCode(HttpResponseStatus.TOO_MANY_REQUESTS.code());
            routingContext.response().send();
            return;
        }
        String header = routingContext.request().getHeader(HttpHeaders.ACCEPT);
        if (header == null || !header.equalsIgnoreCase(MEDIA_TYPE_TEXT_EVENT_STREAM)) {
            routingContext.response().setStatusCode(HttpResponseStatus.OK.code());
            routingContext.response().send();
            return;
        }
        HttpServerResponse response = routingContext.response();
        response.putHeader("Content-Type", MEDIA_TYPE_TEXT_EVENT_STREAM);
        response.putHeader("Cache-Control", "no-cache");
        response.putHeader("Connection", "keep-alive");
        response.setChunked(true);
        AtomicInteger counter = new AtomicInteger();
        StringBuilder connect = new StringBuilder();
        ChangeEventHandler.writeField(connect, "id", String.valueOf(counter.getAndIncrement()));
        ChangeEventHandler.writeField(connect, "event", "connect");
        ChangeEventHandler.writeField(connect, "data", "Connected");
        connect.append(NL);
        response.write(connect.toString());
        long timerId = routingContext.vertx().setPeriodic(30000L, id -> {
            if (routingContext.response().closed()) {
                routingContext.vertx().cancelTimer(id.longValue());
                return;
            }
            StringBuilder ping = new StringBuilder();
            ChangeEventHandler.writeField(ping, "id", String.valueOf(counter.getAndIncrement()));
            ChangeEventHandler.writeField(ping, "event", "ping");
            ping.append(NL);
            response.write(ping.toString());
        });
        Connection connection = new Connection(routingContext, timerId, counter);
        this.connections.add(connection);
        routingContext.request().connection().closeHandler(v -> this.closeConnection(connection));
    }

    private void closeConnection(Connection connection) {
        this.connections.remove(connection);
        if (!connection.closed.getAndSet(true)) {
            connection.ctx().vertx().cancelTimer(connection.timerId());
            if (!connection.ctx().response().ended()) {
                connection.ctx().response().end();
            }
        }
    }

    static boolean matches(List<String> suffixes, String name) {
        for (String suffix : suffixes) {
            if (!name.toLowerCase().endsWith(suffix.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    record Connection(RoutingContext ctx, long timerId, AtomicInteger counter, AtomicBoolean closed) {
        Connection(RoutingContext ctx, long timerId, AtomicInteger counter) {
            this(ctx, timerId, counter, new AtomicBoolean(false));
        }
    }

    record Changes(List<String> added, List<String> removed, List<String> updated) {
    }
}

