/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.runtime.devmode;

import io.quarkiverse.web.bundler.runtime.WebBundlerResourceRecorder;
import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.dev.spi.HotReplacementSetup;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class WebBundlerHotReplacementSetup
implements HotReplacementSetup {
    private static final Logger LOGGER = Logger.getLogger(WebBundlerHotReplacementSetup.class);
    private final List<Consumer<Set<String>>> changeEventListeners = new CopyOnWriteArrayList<Consumer<Set<String>>>();
    static final ScheduledExecutorService EXECUTOR = Executors.newSingleThreadScheduledExecutor();
    private volatile long nextUpdate = 0L;
    private ScheduledFuture<?> scheduler;
    private HotReplacementContext context;

    public void setupHotDeployment(HotReplacementContext context) {
        this.context = context;
        context.consumeNoRestartChanges(this::noRestartChanges);
        WebBundlerResourceRecorder.setHotDeploymentEventHandlerRegister(r -> {
            this.changeEventListeners.add((Consumer<Set<String>>)r);
            return () -> this.changeEventListeners.remove(r);
        });
        WebBundlerResourceRecorder.setStartWatchScheduler(this::startWatchScheduler);
    }

    private void startWatchScheduler() {
        if (this.scheduler == null) {
            this.context.addPreScanStep(() -> {
                if (this.nextUpdate != Long.MAX_VALUE) {
                    this.nextUpdate = System.currentTimeMillis() + 1000L;
                }
            });
            this.scheduler = EXECUTOR.scheduleAtFixedRate(() -> {
                try {
                    if (this.context.getDeploymentProblem() == null && System.currentTimeMillis() > this.nextUpdate) {
                        this.nextUpdate = Long.MAX_VALUE;
                        if (this.context.doScan(false)) {
                            LOGGER.debug((Object)"App restarted from watcher, let's wait 3s before watching again");
                            this.nextUpdate = System.currentTimeMillis() + 3000L;
                        } else {
                            this.nextUpdate = System.currentTimeMillis() + 1000L;
                        }
                    }
                }
                catch (Exception e) {
                    this.nextUpdate = System.currentTimeMillis() + 3000L;
                    throw new RuntimeException(e);
                }
            }, 500L, 500L, TimeUnit.MILLISECONDS);
        }
    }

    public void close() {
        super.close();
        if (this.scheduler != null) {
            this.scheduler.cancel(true);
            this.scheduler = null;
        }
    }

    private void noRestartChanges(Set<String> strings) {
        this.nextUpdate = System.currentTimeMillis() + 1000L;
        for (Consumer<Set<String>> changeEventListener : this.changeEventListeners) {
            changeEventListener.accept(strings);
        }
    }
}

