/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.wiremock.devservice;

import com.github.tomakehurst.wiremock.client.WireMock;
import io.quarkiverse.wiremock.devservice.ConnectWireMock;
import io.quarkus.test.common.DevServicesContext;
import io.quarkus.test.common.QuarkusTestResourceConfigurableLifecycleManager;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import org.jboss.logging.Logger;

public class WireMockServerConnector
implements QuarkusTestResourceConfigurableLifecycleManager<ConnectWireMock>,
DevServicesContext.ContextAware {
    private static final Logger LOGGER = Logger.getLogger(WireMockServerConnector.class);
    private static final String CONFIG_TEMPLATE = "%%dev,test.%s.%s";
    WireMock wiremock;

    public Map<String, String> start() {
        return Collections.emptyMap();
    }

    public void stop() {
    }

    public void inject(QuarkusTestResourceLifecycleManager.TestInjector testInjector) {
        testInjector.injectIntoFields((Object)this.wiremock, (Predicate)new QuarkusTestResourceLifecycleManager.TestInjector.MatchesType(WireMock.class));
    }

    public void setIntegrationTestContext(DevServicesContext context) {
        Map devContext = context.devServicesProperties();
        int port = Integer.parseInt((String)devContext.get(WireMockServerConnector.getPropertyKey("port")));
        try {
            this.wiremock = new WireMock(port);
            this.wiremock.getGlobalSettings();
        }
        catch (Exception ex) {
            LOGGER.error((Object)"WireMock server not found! It should run as Dev Service.", (Throwable)ex);
            throw ex;
        }
    }

    private static String getPropertyKey(String propertyName) {
        return String.format(CONFIG_TEMPLATE, "quarkus.wiremock.devservices", propertyName);
    }
}

