/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.zeebe.runtime;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.quarkiverse.zeebe.JobWorkerExceptionHandler;
import io.quarkiverse.zeebe.ZeebeScheduledExecutorService;
import io.quarkiverse.zeebe.runtime.JobWorkerCommand;
import io.quarkiverse.zeebe.runtime.JobWorkerHandler;
import io.quarkus.arc.DefaultBean;
import io.quarkus.arc.Unremovable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Map;
import org.jboss.logging.Logger;

@Singleton
@Unremovable
@DefaultBean
public class DefaultJobWorkerExceptionHandler
implements JobWorkerExceptionHandler {
    private static final Logger LOG = Logger.getLogger(JobWorkerHandler.class);
    @Inject
    ZeebeScheduledExecutorService zeebeScheduledExecutorService;
    private static final Map<Status.Code, ACTION> CODES = Map.ofEntries(Map.entry(Status.Code.OK, ACTION.SUCCESS), Map.entry(Status.Code.ALREADY_EXISTS, ACTION.SUCCESS), Map.entry(Status.Code.CANCELLED, ACTION.RETRIEVABLE), Map.entry(Status.Code.DEADLINE_EXCEEDED, ACTION.RETRIEVABLE), Map.entry(Status.Code.RESOURCE_EXHAUSTED, ACTION.RETRIEVABLE), Map.entry(Status.Code.ABORTED, ACTION.RETRIEVABLE), Map.entry(Status.Code.UNAVAILABLE, ACTION.RETRIEVABLE), Map.entry(Status.Code.DATA_LOSS, ACTION.RETRIEVABLE), Map.entry(Status.Code.NOT_FOUND, ACTION.IGNORABLE), Map.entry(Status.Code.INVALID_ARGUMENT, ACTION.FAILURE), Map.entry(Status.Code.PERMISSION_DENIED, ACTION.FAILURE), Map.entry(Status.Code.FAILED_PRECONDITION, ACTION.FAILURE), Map.entry(Status.Code.OUT_OF_RANGE, ACTION.FAILURE), Map.entry(Status.Code.UNIMPLEMENTED, ACTION.FAILURE), Map.entry(Status.Code.INTERNAL, ACTION.FAILURE), Map.entry(Status.Code.UNAUTHENTICATED, ACTION.FAILURE));

    @Override
    public void handleError(JobWorkerCommand command, Throwable throwable) {
        if (!StatusRuntimeException.class.isAssignableFrom(throwable.getClass())) {
            throw new RuntimeException("Could not execute " + String.valueOf(command) + " due to exception: " + throwable.getMessage(), throwable);
        }
        StatusRuntimeException exception = (StatusRuntimeException)throwable;
        Status.Code code = exception.getStatus().getCode();
        switch (CODES.get(code).ordinal()) {
            case 3: {
                throw new RuntimeException("Could not execute " + String.valueOf(command) + " due to error of type '" + String.valueOf(code) + "'", throwable);
            }
            case 1: {
                if (command.canRetry()) {
                    command.supplyRetryDelay();
                    command.retry(this.zeebeScheduledExecutorService.scheduledExecutorService());
                    LOG.warn((Object)("Retry " + String.valueOf(command) + " after error of type '" + String.valueOf(code) + "' with backoff"));
                    return;
                }
                throw new RuntimeException("Could not execute " + String.valueOf(command) + " due to error of type '" + String.valueOf(code) + "' and no retries are left", throwable);
            }
            case 2: {
                throw new JobWorkerExceptionHandler.WarningException("Ignoring the error of type '" + String.valueOf(code) + "' during '" + String.valueOf(command) + "'. Job might have been canceled or already completed.", throwable);
            }
        }
    }

    public static enum ACTION {
        SUCCESS,
        RETRIEVABLE,
        IGNORABLE,
        FAILURE;

    }
}

