/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.zeebe.runtime;

import io.camunda.zeebe.client.api.command.CompleteJobCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.command.ThrowErrorCommandStep1;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.BackoffSupplier;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.quarkiverse.zeebe.JobWorkerExceptionHandler;
import io.quarkiverse.zeebe.ZeebeBpmnError;
import io.quarkiverse.zeebe.runtime.metrics.MetricsRecorder;
import io.quarkiverse.zeebe.runtime.tracing.TracingRecorder;
import io.quarkiverse.zeebe.runtime.tracing.ZeebeTracing;
import java.io.InputStream;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;

public class JobWorkerCommand {
    private static final Logger LOG = Logger.getLogger(JobWorkerCommand.class);
    private final FinalCommandStep<?> command;
    private JobWorkerExceptionHandler exceptionHandler;
    private BackoffSupplier backoffSupplier;
    private String metricsActionName;
    private String metricsFailedActionName;
    private ActivatedJob job;
    private int counter = 0;
    private long retryDelay = 50L;
    private int maxRetries = 20;
    private MetricsRecorder metricsRecorder;
    private TracingRecorder.TracingContext tracingContext;

    public JobWorkerCommand(FinalCommandStep<?> command, ActivatedJob job, String metricsActionName, String metricsFailedActionName) {
        this.command = command;
        this.job = job;
        this.metricsActionName = metricsActionName;
        this.metricsFailedActionName = metricsFailedActionName;
    }

    public void send() {
        ++this.counter;
        this.command.send().handle((o, ex) -> {
            if (ex != null) {
                this.tracingContext.error(ZeebeTracing.JOB_CMD_EXCEPTION, (Throwable)ex);
                this.metricsRecorder.increase("camunda.job.invocations", this.metricsFailedActionName, this.job.getType());
                try {
                    this.exceptionHandler.handleError(this, (Throwable)ex);
                }
                catch (Throwable t) {
                    if (t instanceof JobWorkerExceptionHandler.WarningException) {
                        LOG.warn((Object)t.getMessage());
                    } else {
                        LOG.error((Object)t.getMessage());
                    }
                    this.tracingContext.error(ZeebeTracing.JOB_ERROR_HANDLER_EXCEPTION, t);
                    this.tracingContext.close();
                }
                return null;
            }
            this.metricsRecorder.increase("camunda.job.invocations", this.metricsActionName, this.job.getType());
            this.tracingContext.ok();
            this.tracingContext.close();
            return null;
        });
    }

    public static JobWorkerCommand createJobWorkerCommand(JobClient client, ActivatedJob job, Object result) {
        CompleteJobCommandStep1 tmp = JobWorkerCommand.createCompleteCommand(client, job, result);
        return new JobWorkerCommand((FinalCommandStep<?>)tmp, job, "completed", "completed-failed");
    }

    public static JobWorkerCommand createThrowErrorCommand(JobClient client, ActivatedJob job, ZeebeBpmnError bpmnError) {
        ThrowErrorCommandStep1.ThrowErrorCommandStep2 tmp = client.newThrowErrorCommand(job.getKey()).errorCode(bpmnError.getErrorCode()).errorMessage(bpmnError.getErrorMessage());
        return new JobWorkerCommand((FinalCommandStep<?>)tmp, job, "bpmn-error", "bpmn-error-failed");
    }

    private static CompleteJobCommandStep1 createCompleteCommand(JobClient client, ActivatedJob job, Object result) {
        CompleteJobCommandStep1 completeCommand = client.newCompleteCommand(job.getKey());
        if (result == null) {
            return completeCommand;
        }
        if (Map.class.isAssignableFrom(result.getClass())) {
            Map var = (Map)result;
            return completeCommand.variables(var);
        }
        if (String.class.isAssignableFrom(result.getClass())) {
            return completeCommand.variables((String)result);
        }
        if (InputStream.class.isAssignableFrom(result.getClass())) {
            return completeCommand.variables((InputStream)result);
        }
        return completeCommand.variables(result);
    }

    public void retry(ScheduledExecutorService scheduledExecutorService) {
        scheduledExecutorService.schedule(this::send, this.retryDelay, TimeUnit.MILLISECONDS);
    }

    public void supplyRetryDelay() {
        this.retryDelay = this.backoffSupplier.supplyRetryDelay(this.retryDelay);
    }

    public boolean canRetry() {
        long now = Instant.now().getEpochSecond();
        if (now > this.job.getDeadline()) {
            LOG.warnf("Command %s type %s cannot be repeated: deadline time [now: %s, deadline: %s]", new Object[]{this.command.getClass().getName(), this.job.getType(), now, this.job.getDeadline()});
            return false;
        }
        if (this.counter >= this.maxRetries) {
            LOG.warnf("Command %s type %s cannot be repeated: no retries are left [counter: %s, max-retries: %s]", new Object[]{this.command.getClass().getName(), this.job.getType(), this.counter, this.maxRetries});
            return false;
        }
        return true;
    }

    public String toString() {
        return "JobWorkerCommand{command=" + this.command.getClass().getName() + ", counter=" + this.counter + ", maxRetries=" + this.maxRetries + "}";
    }

    public JobWorkerCommand request(TracingRecorder.TracingContext tracingContext, MetricsRecorder metricsRecorder, BackoffSupplier backoffSupplier, JobWorkerExceptionHandler exceptionHandler, int maxRetries, long retryDelay) {
        this.tracingContext = tracingContext;
        this.metricsRecorder = metricsRecorder;
        this.backoffSupplier = backoffSupplier;
        this.exceptionHandler = exceptionHandler;
        this.maxRetries = maxRetries;
        this.retryDelay = retryDelay;
        return this;
    }
}

