/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.zeebe.runtime;

import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.BackoffSupplier;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.client.api.worker.JobHandler;
import io.camunda.zeebe.client.impl.worker.ExponentialBackoffBuilderImpl;
import io.quarkiverse.zeebe.JobWorkerExceptionHandler;
import io.quarkiverse.zeebe.ZeebeBpmnError;
import io.quarkiverse.zeebe.runtime.JobWorkerCommand;
import io.quarkiverse.zeebe.runtime.JobWorkerInvoker;
import io.quarkiverse.zeebe.runtime.JobWorkerMetadata;
import io.quarkiverse.zeebe.runtime.ZeebeClientRuntimeConfig;
import io.quarkiverse.zeebe.runtime.metrics.MetricsRecorder;
import io.quarkiverse.zeebe.runtime.tracing.TracingRecorder;
import io.quarkiverse.zeebe.runtime.tracing.ZeebeTracing;
import io.quarkus.arc.Arc;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.concurrent.CompletionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobWorkerHandler
implements JobHandler {
    private static final Logger log = LoggerFactory.getLogger(JobWorkerHandler.class);
    private JobWorkerMetadata jobWorkerMetadata;
    private JobWorkerInvoker invoker;
    private JobWorkerExceptionHandler exceptionHandler;
    private BackoffSupplier backoffSupplier;
    private ZeebeClientRuntimeConfig.AutoCompleteConfig autoCompleteConfig;
    private MetricsRecorder metricsRecorder;
    private TracingRecorder tracingRecorder;
    private String spanName;

    public JobWorkerHandler(JobWorkerMetadata jobWorkerMetadata, JobWorkerInvoker invoker, MetricsRecorder metricsRecorder, JobWorkerExceptionHandler exceptionHandler, ZeebeClientRuntimeConfig.AutoCompleteConfig autoCompleteConfig, TracingRecorder tracingRecorder) {
        this.jobWorkerMetadata = jobWorkerMetadata;
        this.invoker = invoker;
        this.metricsRecorder = metricsRecorder;
        this.exceptionHandler = exceptionHandler;
        this.autoCompleteConfig = autoCompleteConfig;
        this.tracingRecorder = tracingRecorder;
        this.spanName = jobWorkerMetadata.workerValue.name;
        if (this.spanName == null || this.spanName.isEmpty()) {
            this.spanName = jobWorkerMetadata.methodName;
        }
        if (jobWorkerMetadata.workerValue.autoComplete) {
            this.backoffSupplier = new ExponentialBackoffBuilderImpl().maxDelay(autoCompleteConfig.expMaxDelay()).minDelay(autoCompleteConfig.expMinDelay()).backoffFactor(autoCompleteConfig.expBackoffFactor()).jitterFactor(autoCompleteConfig.expJitterFactor()).build();
        }
    }

    public void handle(JobClient client, ActivatedJob job) throws Exception {
        log.trace("Handle {} and invoke worker {}", (Object)job, (Object)this.jobWorkerMetadata.workerValue);
        Vertx vertx = (Vertx)Arc.container().instance(Vertx.class, new Annotation[0]).get();
        Context context = VertxContext.getOrCreateDuplicatedContext((Vertx)vertx);
        VertxContextSafetyToggle.setContextSafe((Context)context, (boolean)true);
        if (this.invoker.isBlocking()) {
            context.executeBlocking(() -> {
                this.doInvoke(client, job);
                return null;
            }, false);
        } else {
            context.runOnContext(event -> this.doInvoke(client, job));
        }
    }

    private void doInvoke(JobClient client, ActivatedJob job) {
        try {
            TracingRecorder.TracingContext tracingContext = this.tracingRecorder.createTracingContext(this.jobWorkerMetadata.declaringClassName, this.jobWorkerMetadata.methodName, this.spanName, job);
            this.metricsRecorder.increase("camunda.job.invocations", "activated", job.getType());
            this.invoker.invoke(client, job).thenApply(result -> {
                if (this.jobWorkerMetadata.workerValue.autoComplete) {
                    JobWorkerCommand.createJobWorkerCommand(client, job, result).request(tracingContext, this.metricsRecorder, this.backoffSupplier, this.exceptionHandler, this.autoCompleteConfig.maxRetries(), this.autoCompleteConfig.retryDelay()).send();
                }
                return result;
            }).exceptionally(ex -> {
                try {
                    this.metricsRecorder.increase("camunda.job.invocations", "failed", job.getType());
                    tracingContext.error(ZeebeTracing.JOB_EXCEPTION, (Throwable)ex);
                    if (ex instanceof CompletionException) {
                        ex = ex.getCause();
                    }
                    if (ex instanceof ZeebeBpmnError) {
                        log.info("Caught JobWorker BPMN error on {}", (Object)job);
                        JobWorkerCommand.createThrowErrorCommand(client, job, (ZeebeBpmnError)ex).request(tracingContext, this.metricsRecorder, this.backoffSupplier, this.exceptionHandler, this.autoCompleteConfig.maxRetries(), this.autoCompleteConfig.retryDelay()).send();
                        return null;
                    }
                }
                catch (Throwable t) {
                    tracingContext.close();
                    throw t;
                }
                try {
                    log.info("Caught exception {} error on {}", (Object)ex.getMessage(), (Object)job);
                    this.handleException(client, job, (Throwable)ex);
                }
                finally {
                    tracingContext.close();
                }
                return null;
            });
        }
        catch (Exception ex2) {
            if (ex2 instanceof RuntimeException) {
                throw (RuntimeException)ex2;
            }
            throw new RuntimeException(ex2);
        }
    }

    private void handleException(JobClient jobClient, ActivatedJob job, Throwable e) {
        log.warn("Worker {} failed to handle job with key {} of type {}, sending fail command to broker", new Object[]{job.getWorker(), job.getKey(), job.getType(), e});
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        String message = stringWriter.toString();
        jobClient.newFailCommand(job.getKey()).retries(job.getRetries() - 1).errorMessage(message).send();
    }
}

