/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.zeebe.runtime;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.CompletionStage;

public class JobWorkerInvoker {
    public CompletionStage<Object> invoke(JobClient client, ActivatedJob job) throws Exception {
        ManagedContext requestContext = Arc.container().requestContext();
        if (requestContext.isActive()) {
            return this.invokeBean(client, job);
        }
        requestContext.activate();
        InjectableContext.ContextState state = requestContext.getState();
        try {
            CompletionStage<Object> completionStage = this.invokeBean(client, job).whenComplete((v, t) -> requestContext.destroy(state));
            return completionStage;
        }
        catch (RuntimeException e) {
            requestContext.terminate();
            throw e;
        }
        finally {
            requestContext.deactivate();
        }
    }

    protected CompletionStage<Object> invokeBean(JobClient client, ActivatedJob job) throws Exception {
        return null;
    }

    protected boolean isBlocking() {
        return true;
    }

    protected Object getVariable(ActivatedJob job, String name, Class<?> clazz) {
        Object value = job.getVariablesAsMap().get(name);
        try {
            if (value != null && !clazz.isInstance(value)) {
                JsonMapper mapper = (JsonMapper)Arc.container().instance(JsonMapper.class, new Annotation[0]).get();
                String tmp = mapper.toJson(value);
                return mapper.fromJson(tmp, clazz);
            }
            return clazz.cast(value);
        }
        catch (ClassCastException | IllegalArgumentException ex) {
            throw new RuntimeException("Cannot assign process variable '" + name + "' to parameter of type '" + String.valueOf(clazz) + "' when executing job '" + job.getType() + "', invalid type found: " + ex.getMessage());
        }
    }

    protected Object getVariablesAsType(ActivatedJob job, Class<?> clazz) {
        try {
            return job.getVariablesAsType(clazz);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Cannot assign process variables to type '" + clazz.getName() + "' when executing job '" + job.getType() + "', cause is: " + e.getMessage(), e);
        }
    }

    protected String getCustomHeader(ActivatedJob job, String name) {
        return (String)job.getCustomHeaders().get(name);
    }

    protected Map<String, String> getCustomHeaders(ActivatedJob job) {
        return job.getCustomHeaders();
    }
}

