/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.zeebe.runtime;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.impl.ZeebeClientBuilderImpl;
import io.camunda.zeebe.client.impl.oauth.OAuthCredentialsProviderBuilder;
import io.quarkiverse.zeebe.runtime.ZeebeClientRuntimeConfig;

public class ZeebeClientBuilderFactory {
    public static ZeebeClientBuilderImpl createBuilder(ZeebeClientRuntimeConfig config, JsonMapper jsonMapper) {
        ZeebeClientBuilderImpl builder = new ZeebeClientBuilderImpl();
        builder.gatewayAddress(ZeebeClientBuilderFactory.createGatewayAddress(config)).restAddress(config.broker().restAddress()).defaultTenantId(config.tenant().defaultTenantId()).defaultJobWorkerTenantIds(config.tenant().defaultJobWorkerTenantIds()).keepAlive(config.broker().keepAlive()).defaultJobPollInterval(config.job().pollInterval()).defaultJobTimeout(config.job().timeout()).defaultJobWorkerMaxJobsActive(config.job().workerMaxJobsActive().intValue()).defaultJobWorkerName(config.job().workerName()).defaultMessageTimeToLive(config.message().timeToLive()).numJobWorkerExecutionThreads(config.job().workerExecutionThreads().intValue()).defaultRequestTimeout(config.job().requestTimeout()).credentialsProvider(ZeebeClientBuilderFactory.getCredentialsProvider(config));
        config.security().overrideAuthority().ifPresent(arg_0 -> ((ZeebeClientBuilderImpl)builder).overrideAuthority(arg_0));
        config.security().certPath().ifPresent(arg_0 -> ((ZeebeClientBuilderImpl)builder).caCertificatePath(arg_0));
        if (config.security().plaintext()) {
            builder.usePlaintext();
        }
        if (jsonMapper != null) {
            builder.withJsonMapper(jsonMapper);
        }
        return builder;
    }

    private static String createGatewayAddress(ZeebeClientRuntimeConfig config) {
        if (config.cloud().clusterId().isPresent()) {
            return String.format("%s.%s.%s:%d", config.cloud().clusterId().get(), config.cloud().region(), config.cloud().baseUrl(), config.cloud().port());
        }
        return config.broker().gatewayAddress();
    }

    private static CredentialsProvider getCredentialsProvider(ZeebeClientRuntimeConfig config) {
        ZeebeClientRuntimeConfig.CloudConfig cloud = config.cloud();
        if (cloud.clientId().isPresent() && cloud.clientSecret().isPresent() && cloud.clusterId().isPresent()) {
            OAuthCredentialsProviderBuilder builder = CredentialsProvider.newCredentialsProviderBuilder();
            builder.authorizationServerUrl(cloud.authUrl());
            cloud.clientId().ifPresent(arg_0 -> ((OAuthCredentialsProviderBuilder)builder).clientId(arg_0));
            cloud.clientSecret().ifPresent(arg_0 -> ((OAuthCredentialsProviderBuilder)builder).clientSecret(arg_0));
            cloud.credentialsCachePath().ifPresent(arg_0 -> ((OAuthCredentialsProviderBuilder)builder).credentialsCachePath(arg_0));
            builder.audience(String.format("%s.%s.%s", cloud.clusterId().get(), cloud.region(), cloud.baseUrl()));
            return builder.build();
        }
        ZeebeClientRuntimeConfig.OAuthConfig oauth = config.oauth();
        if (oauth.clientId().isPresent() && oauth.clientSecret().isPresent()) {
            OAuthCredentialsProviderBuilder builder = CredentialsProvider.newCredentialsProviderBuilder();
            builder.authorizationServerUrl(oauth.authUrl());
            oauth.clientId().ifPresent(arg_0 -> ((OAuthCredentialsProviderBuilder)builder).clientId(arg_0));
            oauth.clientSecret().ifPresent(arg_0 -> ((OAuthCredentialsProviderBuilder)builder).clientSecret(arg_0));
            oauth.credentialsCachePath().ifPresent(arg_0 -> ((OAuthCredentialsProviderBuilder)builder).credentialsCachePath(arg_0));
            builder.audience(ZeebeClientBuilderFactory.createOauthAudience(config));
            builder.connectTimeout(oauth.connectTimeout());
            builder.readTimeout(oauth.readTimeout());
            return builder.build();
        }
        return null;
    }

    private static String createOauthAudience(ZeebeClientRuntimeConfig config) {
        return config.oauth().tokenAudience().orElseGet(() -> ZeebeClientBuilderFactory.removePortFromAddress(config.broker().gatewayAddress()));
    }

    private static String removePortFromAddress(String address) {
        int index = address.lastIndexOf(58);
        if (index > 0) {
            return address.substring(0, index);
        }
        return address;
    }
}

