/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.zeebe.runtime;

import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface ZeebeClientRuntimeConfig {
    public static final String DEFAULT_AUTH_URL = "https://login.cloud.camunda.io/oauth/token";

    @WithName(value="broker")
    public BrokerConfig broker();

    @WithName(value="cloud")
    public CloudConfig cloud();

    @WithName(value="oauth")
    public OAuthConfig oauth();

    @WithName(value="workers")
    public Map<String, JobHandlerConfig> workers();

    @WithName(value="auto-complete")
    public AutoCompleteConfig autoComplete();

    @WithName(value="message")
    public MessageConfig message();

    @WithName(value="security")
    public SecurityConfig security();

    @WithName(value="job")
    public JobConfig job();

    @WithName(value="tracing")
    public TracingConfig tracing();

    @WithName(value="tenant")
    public TenantConfig tenant();

    public static interface OAuthConfig {
        @WithName(value="client-id")
        public Optional<String> clientId();

        @WithName(value="client-secret")
        public Optional<String> clientSecret();

        @WithName(value="auth-url")
        @WithDefault(value="https://login.cloud.camunda.io/oauth/token")
        public String authUrl();

        @WithName(value="credentials-cache-path")
        public Optional<String> credentialsCachePath();

        @WithName(value="connect-timeout")
        @WithDefault(value="PT5S")
        public Duration connectTimeout();

        @WithName(value="read-timeout")
        @WithDefault(value="PT5S")
        public Duration readTimeout();

        @WithName(value="token-audience")
        public Optional<String> tokenAudience();
    }

    public static interface AutoCompleteConfig {
        @WithName(value="max-retries")
        @WithDefault(value="20")
        public int maxRetries();

        @WithName(value="retry-delay")
        @WithDefault(value="50")
        public long retryDelay();

        @WithName(value="exp-backoff-factor")
        @WithDefault(value="1.5")
        public double expBackoffFactor();

        @WithName(value="exp-jitter-factor")
        @WithDefault(value="0.2")
        public double expJitterFactor();

        @WithName(value="exp-max-delay")
        @WithDefault(value="1000")
        public long expMaxDelay();

        @WithName(value="exp-min-delay")
        @WithDefault(value="50")
        public long expMinDelay();
    }

    public static interface TracingConfig {
        @WithName(value="attributes")
        public Optional<List<String>> attributes();
    }

    public static interface JobHandlerConfig {
        @WithName(value="enabled")
        public Optional<Boolean> enabled();

        @WithName(value="name")
        public Optional<String> name();

        @WithName(value="timeout")
        public Optional<Long> timeout();

        @WithName(value="max-jobs-active")
        public Optional<Integer> maxJobsActive();

        @WithName(value="request-timeout")
        public Optional<Long> requestTimeout();

        @WithName(value="poll-interval")
        public Optional<Long> pollInterval();
    }

    public static interface JobConfig {
        @WithName(value="max-jobs-active")
        @WithDefault(value="32")
        public Integer workerMaxJobsActive();

        @WithName(value="worker-execution-threads")
        @WithDefault(value="1")
        public Integer workerExecutionThreads();

        @WithName(value="worker-name")
        @WithDefault(value="default")
        public String workerName();

        @WithName(value="request-timeout")
        @WithDefault(value="PT45S")
        public Duration requestTimeout();

        @WithName(value="default-type")
        public Optional<String> defaultType();

        @WithName(value="timeout")
        @WithDefault(value="PT5M")
        public Duration timeout();

        @WithName(value="pool-interval")
        @WithDefault(value="PT0.100S")
        public Duration pollInterval();

        @WithName(value="exp-backoff-factor")
        @WithDefault(value="1.6")
        public double expBackoffFactor();

        @WithName(value="exp-jitter-factor")
        @WithDefault(value="0.1")
        public double expJitterFactor();

        @WithName(value="exp-max-delay")
        @WithDefault(value="5000")
        public long expMaxDelay();

        @WithName(value="exp-min-delay")
        @WithDefault(value="50")
        public long expMinDelay();
    }

    public static interface SecurityConfig {
        @WithName(value="plaintext")
        @WithDefault(value="true")
        public boolean plaintext();

        @WithName(value="cert-path")
        public Optional<String> certPath();

        @WithName(value="override-authority")
        public Optional<String> overrideAuthority();
    }

    public static interface MessageConfig {
        @WithName(value="time-to-live")
        @WithDefault(value="PT1H")
        public Duration timeToLive();
    }

    public static interface CloudConfig {
        @WithName(value="cluster-id")
        public Optional<String> clusterId();

        @WithName(value="client-id")
        public Optional<String> clientId();

        @WithName(value="client-secret")
        public Optional<String> clientSecret();

        @WithName(value="region")
        @WithDefault(value="bru-2")
        public String region();

        @WithName(value="base-url")
        @WithDefault(value="zeebe.camunda.io")
        public String baseUrl();

        @WithName(value="auth-url")
        @WithDefault(value="https://login.cloud.camunda.io/oauth/token")
        public String authUrl();

        @WithName(value="port")
        @WithDefault(value="443")
        public int port();

        @WithName(value="credentials-cache-path")
        public Optional<String> credentialsCachePath();
    }

    public static interface BrokerConfig {
        @WithName(value="gateway-address")
        @WithDefault(value="localhost:26500")
        public String gatewayAddress();

        @WithName(value="rest-address")
        @WithDefault(value="http://0.0.0.0:8080")
        public URI restAddress();

        @WithName(value="keep-alive")
        @WithDefault(value="PT45S")
        public Duration keepAlive();
    }

    public static interface TenantConfig {
        @WithName(value="default-tenant-id")
        @WithDefault(value="<default>")
        public String defaultTenantId();

        @WithName(value="default-job-worker-tenant-ids")
        @WithDefault(value="<default>")
        public List<String> defaultJobWorkerTenantIds();
    }
}

