/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.zeebe.runtime;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientBuilder;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.impl.ZeebeClientBuilderImpl;
import io.grpc.ClientInterceptor;
import io.quarkiverse.zeebe.ZeebeClientInterceptor;
import io.quarkiverse.zeebe.runtime.ZeebeClientBuilderFactory;
import io.quarkiverse.zeebe.runtime.ZeebeRuntimeConfig;
import io.quarkiverse.zeebe.runtime.noop.NoOpZeebeClient;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import org.jboss.logging.Logger;

@ApplicationScoped
public class ZeebeClientService {
    private static final Logger log = Logger.getLogger(ZeebeClientService.class);
    ZeebeClient client;

    public ZeebeClientService(ZeebeRuntimeConfig config, JsonMapper jsonMapper, @Any Instance<ZeebeClientInterceptor> interceptors) {
        if (config.active()) {
            log.infof("Creating new zeebe client for %s", (Object)config.client().broker().gatewayAddress());
            ZeebeClientBuilderImpl builder = ZeebeClientBuilderFactory.createBuilder(config.client(), jsonMapper);
            interceptors.forEach(arg_0 -> ZeebeClientService.lambda$new$0((ZeebeClientBuilder)builder, arg_0));
            this.client = builder.build();
        } else {
            log.infof("Zeebe extension is disabled", new Object[0]);
            this.client = new NoOpZeebeClient();
        }
    }

    @Produces
    public ZeebeClient client() {
        return this.client;
    }

    private static /* synthetic */ void lambda$new$0(ZeebeClientBuilder builder, ZeebeClientInterceptor x) {
        ClientInterceptor[] clientInterceptorArray = new ClientInterceptor[1];
        clientInterceptorArray[0] = x::interceptCall;
        builder.withInterceptors(clientInterceptorArray);
    }
}

