/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.zeebe.runtime;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.command.DeployResourceCommandStep1;
import io.camunda.zeebe.client.api.response.DeploymentEvent;
import io.camunda.zeebe.client.api.worker.BackoffSupplier;
import io.camunda.zeebe.client.api.worker.ExponentialBackoffBuilder;
import io.camunda.zeebe.client.api.worker.JobHandler;
import io.camunda.zeebe.client.api.worker.JobWorker;
import io.camunda.zeebe.client.api.worker.JobWorkerBuilderStep1;
import io.quarkiverse.zeebe.JobWorkerExceptionHandler;
import io.quarkiverse.zeebe.runtime.JobWorkerHandler;
import io.quarkiverse.zeebe.runtime.JobWorkerInvoker;
import io.quarkiverse.zeebe.runtime.JobWorkerMetadata;
import io.quarkiverse.zeebe.runtime.JobWorkerValue;
import io.quarkiverse.zeebe.runtime.ZeebeClientRuntimeConfig;
import io.quarkiverse.zeebe.runtime.ZeebeRuntimeConfig;
import io.quarkiverse.zeebe.runtime.metrics.MetricsRecorder;
import io.quarkiverse.zeebe.runtime.tracing.TracingRecorder;
import io.quarkiverse.zeebe.runtime.tracing.ZeebeTracing;
import io.quarkus.arc.Arc;
import io.quarkus.runtime.annotations.Recorder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

@Recorder
public class ZeebeRecorder {
    private static final Logger log = Logger.getLogger(ZeebeRecorder.class);

    public void init(ZeebeRuntimeConfig config, Collection<String> resources, List<JobWorkerMetadata> workers) {
        List<String> attrs;
        ZeebeClient client = (ZeebeClient)Arc.container().instance(ZeebeClient.class, new Annotation[0]).get();
        if (config.client().tracing().attributes().isPresent() && !(attrs = config.client().tracing().attributes().get()).isEmpty()) {
            ZeebeTracing.setAttributes(attrs);
        }
        if (resources != null && !resources.isEmpty()) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            DeployResourceCommandStep1 cmd = client.newDeployResourceCommand();
            DeploymentEvent deploymentResult = (DeploymentEvent)resources.stream().flatMap(name -> Stream.of(cl.getResource((String)name))).filter(Objects::nonNull).map(resource -> {
                DeployResourceCommandStep1.DeployResourceCommandStep2 deployResourceCommandStep2;
                block8: {
                    InputStream inputStream = resource.openStream();
                    try {
                        deployResourceCommandStep2 = cmd.addResourceStream(inputStream, resource.getPath());
                        if (inputStream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e.getMessage());
                        }
                    }
                    inputStream.close();
                }
                return deployResourceCommandStep2;
            }).filter(Objects::nonNull).reduce((f, s) -> s).orElseThrow(() -> new IllegalArgumentException("Requires at least one resource to deploy")).send().join();
            log.infof("Deployed: %s", (Object)deploymentResult.getProcesses().stream().map(wf -> String.format("<%s:%d>", wf.getBpmnProcessId(), wf.getVersion())).collect(Collectors.joining(",")));
        }
        if (workers != null && !workers.isEmpty()) {
            JobWorkerExceptionHandler handler = (JobWorkerExceptionHandler)Arc.container().instance(JobWorkerExceptionHandler.class, new Annotation[0]).get();
            MetricsRecorder metricsRecorder = (MetricsRecorder)Arc.container().instance(MetricsRecorder.class, new Annotation[0]).get();
            TracingRecorder tracingRecorder = (TracingRecorder)Arc.container().instance(TracingRecorder.class, new Annotation[0]).get();
            HashSet<String> tracingVariables = null;
            Collection<String> fields = tracingRecorder.fields();
            if (fields != null && !fields.isEmpty()) {
                tracingVariables = new HashSet<String>(fields);
            }
            for (JobWorkerMetadata meta : workers) {
                String jobType = ZeebeRecorder.getJobType(config.client(), meta);
                try {
                    JobWorker jobWorker = ZeebeRecorder.buildJobWorker(client, config.client(), handler, meta, metricsRecorder, tracingRecorder, tracingVariables, jobType);
                    if (jobWorker == null) continue;
                    log.infof("Starting worker %s.%s for job type %s", (Object)meta.declaringClassName, (Object)meta.methodName, (Object)jobType);
                }
                catch (Exception e) {
                    log.errorf((Throwable)e, "Error opening worker for type %s with class %s.%s", (Object)jobType, (Object)meta.declaringClassName, (Object)meta.methodName);
                }
            }
        }
    }

    private static String getJobType(ZeebeClientRuntimeConfig config, JobWorkerMetadata meta) {
        String type = meta.workerValue.type;
        if (type == null || type.isEmpty()) {
            return config.job().defaultType().orElse(meta.methodName);
        }
        return type;
    }

    private static JobWorker buildJobWorker(ZeebeClient client, ZeebeClientRuntimeConfig config, JobWorkerExceptionHandler exceptionHandler, JobWorkerMetadata meta, MetricsRecorder metricsRecorder, TracingRecorder tracingRecorder, Set<String> tracingVariables, String type) {
        JobWorkerValue value = meta.workerValue;
        ZeebeClientRuntimeConfig.JobHandlerConfig jonHandlerConfig = config.workers().get(type);
        if (jonHandlerConfig != null) {
            jonHandlerConfig.name().ifPresent(n -> {
                value.name = n;
            });
            jonHandlerConfig.enabled().ifPresent(n -> {
                value.enabled = n;
            });
            jonHandlerConfig.maxJobsActive().ifPresent(n -> {
                value.maxJobsActive = n;
            });
            jonHandlerConfig.timeout().ifPresent(n -> {
                value.timeout = n;
            });
            jonHandlerConfig.pollInterval().ifPresent(n -> {
                value.pollInterval = n;
            });
            jonHandlerConfig.requestTimeout().ifPresent(n -> {
                value.requestTimeout = n;
            });
        }
        if (!value.enabled) {
            log.infof("Job worker %s.%s for job type %s is disabled.", (Object)meta.declaringClassName, (Object)meta.methodName, (Object)value.type);
            return null;
        }
        JobWorkerInvoker invoker = ZeebeRecorder.createJobWorkerInvoker(meta.invokerClass);
        JobWorkerHandler jobHandler = new JobWorkerHandler(meta, invoker, metricsRecorder, exceptionHandler, config.autoComplete(), tracingRecorder);
        JobWorkerBuilderStep1.JobWorkerBuilderStep3 builder = client.newWorker().jobType(type).handler((JobHandler)jobHandler);
        if (value.name != null && !value.name.isEmpty()) {
            builder.name(value.name);
        }
        if (value.maxJobsActive > 0) {
            builder.maxJobsActive(value.maxJobsActive);
        }
        if (value.timeout > 0L) {
            builder.timeout(value.timeout);
        }
        if (value.pollInterval > 0L) {
            builder.pollInterval(Duration.ofMillis(value.pollInterval));
        }
        if (value.requestTimeout > 0L) {
            builder.requestTimeout(Duration.ofSeconds(value.requestTimeout));
        }
        if (!value.fetchAllVariables && value.fetchVariables != null && value.fetchVariables.length > 0) {
            if (tracingVariables != null && !tracingVariables.isEmpty()) {
                HashSet<String> tmp = new HashSet<String>(tracingVariables);
                tmp.addAll(Arrays.asList(value.fetchVariables));
                value.fetchVariables = tmp.toArray(new String[0]);
            }
            builder.fetchVariables(value.fetchVariables);
        }
        ExponentialBackoffBuilder exp = BackoffSupplier.newBackoffBuilder();
        exp.backoffFactor(config.job().expBackoffFactor());
        exp.jitterFactor(config.job().expJitterFactor());
        exp.maxDelay(config.job().expMaxDelay());
        exp.minDelay(config.job().expMinDelay());
        builder.backoffSupplier(exp.build());
        return builder.open();
    }

    private static JobWorkerInvoker createJobWorkerInvoker(String name) {
        try {
            Class<?> invokerClazz = Thread.currentThread().getContextClassLoader().loadClass(name);
            return (JobWorkerInvoker)invokerClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create invoker factory: " + name, e);
        }
    }
}

