/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.zeebe.runtime.devmode;

import io.quarkiverse.zeebe.runtime.devmode.JobWorkerReplacementInterceptor;
import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.dev.spi.HotReplacementSetup;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class JobWorkerHotReplacementSetup
implements HotReplacementSetup {
    private HotReplacementContext context;
    private static final long TWO_SECONDS = 2000L;
    private volatile long nextUpdate;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    public void setupHotDeployment(HotReplacementContext context) {
        this.context = context;
        JobWorkerReplacementInterceptor.onMessage(new OnMessage());
    }

    public void close() {
        this.executor.shutdown();
    }

    private class OnMessage
    implements Runnable {
        private OnMessage() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (JobWorkerHotReplacementSetup.this.nextUpdate < System.currentTimeMillis()) {
                OnMessage onMessage = this;
                synchronized (onMessage) {
                    if (JobWorkerHotReplacementSetup.this.nextUpdate < System.currentTimeMillis()) {
                        JobWorkerHotReplacementSetup.this.executor.execute(() -> {
                            try {
                                JobWorkerHotReplacementSetup.this.context.doScan(true);
                            }
                            catch (RuntimeException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        });
                        JobWorkerHotReplacementSetup.this.nextUpdate = System.currentTimeMillis() + 2000L;
                    }
                }
            }
        }
    }
}

