/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.zeebe.runtime.devmode;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.command.PublishMessageCommandStep1;
import io.camunda.zeebe.client.api.command.UpdateUserTaskCommandStep1;
import io.camunda.zeebe.client.api.response.BroadcastSignalResponse;
import io.camunda.zeebe.client.api.response.DeploymentEvent;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.client.api.response.PublishMessageResponse;
import io.camunda.zeebe.client.api.response.SetVariablesResponse;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.instance.FlowElement;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ErrorRecordValue;
import io.camunda.zeebe.protocol.record.value.EscalationRecordValue;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageStartEventSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessMessageSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.SignalRecordValue;
import io.camunda.zeebe.protocol.record.value.SignalSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.TimerRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.Process;
import io.quarkiverse.zeebe.runtime.devmode.store.BpmnModel;
import io.quarkiverse.zeebe.runtime.devmode.store.RecordStore;
import io.quarkiverse.zeebe.runtime.devmode.store.RecordStoreItem;
import io.quarkus.arc.Arc;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.mutiny.Multi;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ZeebeJsonRPCService {
    private static final Set<String> MODIFY_UNSUPPORTED_ELEMENT_TYPES = Set.of(BpmnElementType.UNSPECIFIED.name(), BpmnElementType.START_EVENT.name(), BpmnElementType.SEQUENCE_FLOW.name(), BpmnElementType.BOUNDARY_EVENT.name());

    public Object jobComplete(long key, Map<String, Object> variables) {
        this.getClient().newCompleteCommand(key).variables(variables).send().join();
        return Map.of("command", "jobComplete", "key", key);
    }

    public Object jobFail(long key, int retries, String errorMessage, Map<String, Object> variables) {
        this.getClient().newFailCommand(key).retries(retries).errorMessage(errorMessage).variables(variables).send().join();
        return Map.of("command", "jobFail", "key", key);
    }

    public Object jobThrowError(long key, String errorCode, String errorMessage, Map<String, Object> variables) {
        this.getClient().newThrowErrorCommand(key).errorCode(errorCode).errorMessage(errorMessage).variables(variables).send().join();
        return Map.of("command", "jobThrowError", "key", key);
    }

    public Object jobRetries(long key, int retries) {
        this.getClient().newUpdateRetriesCommand(key).retries(retries).send().join();
        return Map.of("command", "jobRetries", "key", key);
    }

    public Object resolveIncident(long key, long jobKey, int retries) {
        if (jobKey > 0L) {
            this.getClient().newUpdateRetriesCommand(jobKey).retries(retries).send().join();
        }
        this.getClient().newResolveIncidentCommand(key).send().join();
        return Map.of("command", "resolveIncident", "incidentKey", key);
    }

    public SetVariablesResponse setVariables(long key, boolean local, Map<String, Object> variables) {
        return (SetVariablesResponse)this.getClient().newSetVariablesCommand(key).variables(variables).local(local).send().join();
    }

    public Object userTaskComplete(long key, Map<String, Object> variables) {
        this.getClient().newCompleteCommand(key).variables(variables).send().join();
        return Map.of("command", "userTaskComplete", "userTaskKey", key);
    }

    public Object userTaskAssign(long key, String assignee, String action, boolean allowOverride) {
        this.getClient().newUserTaskAssignCommand(key).action(action).allowOverride(allowOverride).assignee(assignee).send().join();
        return Map.of("command", "userTaskAssign", "userTaskKey", key);
    }

    public Object userTaskUnassign(long key) {
        this.getClient().newUserTaskUnassignCommand(key).send().join();
        return Map.of("command", "userTaskUnassign", "userTaskKey", key);
    }

    public Object userTaskUpdate(long key, String action, List<String> candidateUsers, List<String> candidateGroups, String dueDate, String followUpDate) {
        UpdateUserTaskCommandStep1 tmp = this.getClient().newUserTaskUpdateCommand(key);
        if (action != null) {
            tmp = tmp.action(action);
        }
        if (candidateUsers == null || candidateUsers.isEmpty()) {
            tmp.clearCandidateUsers();
        } else {
            tmp.candidateUsers(candidateUsers);
        }
        if (candidateGroups == null || candidateGroups.isEmpty()) {
            tmp.clearCandidateGroups();
        } else {
            tmp.candidateGroups(candidateGroups);
        }
        if (dueDate == null) {
            tmp.clearDueDate();
        } else {
            tmp.dueDate(dueDate);
        }
        if (followUpDate == null) {
            tmp.clearFollowUpDate();
        } else {
            tmp.followUpDate(followUpDate);
        }
        tmp.send().join();
        return Map.of("command", "userTaskUpdate", "userTaskKey", key);
    }

    public Object cancelProcessInstance(long processInstanceKey) {
        this.getClient().newCancelInstanceCommand(processInstanceKey).send().join();
        return Map.of("command", "cancelProcessInstance", "processInstanceKey", processInstanceKey);
    }

    public BroadcastSignalResponse sendSignal(String name, Map<String, Object> variables) {
        return (BroadcastSignalResponse)this.getClient().newBroadcastSignalCommand().signalName(name).variables(variables).send().join();
    }

    public DeploymentEvent deployProcess(String name, String xml) {
        return (DeploymentEvent)this.getClient().newDeployResourceCommand().addResourceStringUtf8(xml, name).send().join();
    }

    public PublishMessageResponse sendMessage(String name, String correlationKey, String duration, Map<String, Object> variables) {
        PublishMessageCommandStep1.PublishMessageCommandStep2 tmp = this.getClient().newPublishMessageCommand().messageName(name);
        PublishMessageCommandStep1.PublishMessageCommandStep3 step3 = correlationKey == null ? tmp.withoutCorrelationKey() : tmp.correlationKey(correlationKey);
        return (PublishMessageResponse)step3.variables(variables).timeToLive(Duration.parse(duration)).send().join();
    }

    public ProcessInstanceEvent createProcessInstance(Long processDefinitionKey, Map<String, Object> variables) {
        return (ProcessInstanceEvent)this.getClient().newCreateInstanceCommand().processDefinitionKey(processDefinitionKey.longValue()).variables(variables).send().join();
    }

    private ZeebeClient getClient() {
        return (ZeebeClient)Arc.container().instance(ZeebeClient.class, new Annotation[0]).get();
    }

    @NonBlocking
    public Collection<RecordStoreItem<JobRecordValue>> userTasks() {
        return RecordStore.USER_TASKS.values();
    }

    @NonBlocking
    public Collection<RecordStoreItem<SignalRecordValue>> signals() {
        return RecordStore.SIGNALS.values();
    }

    @NonBlocking
    public Collection<RecordStoreItem<MessageRecordValue>> messages() {
        return RecordStore.MESSAGES.values();
    }

    @NonBlocking
    public Collection<RecordStoreItem<ErrorRecordValue>> errors() {
        return RecordStore.ERRORS.values();
    }

    @NonBlocking
    public Collection<RecordStoreItem<IncidentRecordValue>> incidents() {
        return RecordStore.INCIDENTS.values();
    }

    @NonBlocking
    public Collection<RecordStoreItem<JobRecordValue>> jobs() {
        return RecordStore.JOBS.values();
    }

    @NonBlocking
    public Multi<RecordStore.Notification> notifications() {
        return RecordStore.NOTIFICATIONS;
    }

    @NonBlocking
    public Collection<RecordStoreItem<ProcessInstanceRecordValue>> instances() {
        return RecordStore.INSTANCES.values();
    }

    @NonBlocking
    public Collection<RecordStoreItem<Process>> processes() {
        return RecordStore.PROCESS_DEFINITIONS.values();
    }

    @NonBlocking
    public ProcessWrapper process(long id) {
        List<RecordStoreItem<ProcessInstanceRecordValue>> instances = null;
        List<RecordStoreItem<MessageStartEventSubscriptionRecordValue>> messages = null;
        List<RecordStoreItem<SignalSubscriptionRecordValue>> signals = null;
        List<RecordStoreItem<TimerRecordValue>> timers = null;
        Map<String, Map<String, Long>> elements = null;
        String xml = null;
        RecordStoreItem<Process> item = RecordStore.PROCESS_DEFINITIONS.get(id);
        if (item == null) {
            return null;
        }
        elements = RecordStore.findProcessElements((Long)item.id());
        RecordStoreItem<Process> tmp = RecordStore.PROCESS_DEFINITIONS_XML.get(id);
        if (tmp != null) {
            xml = new String(((Process)tmp.record().getValue()).getResource());
        }
        instances = RecordStore.INSTANCES.findBy(x -> ((ProcessInstanceRecordValue)x.getValue()).getProcessDefinitionKey() == item.record().getKey()).toList();
        messages = RecordStore.START_EVENT_SUBSCRIPTIONS.findBy(x -> ((MessageStartEventSubscriptionRecordValue)x.getValue()).getProcessDefinitionKey() == item.record().getKey()).toList();
        signals = RecordStore.SIGNAL_SUBSCRIPTIONS.findBy(x -> ((SignalSubscriptionRecordValue)x.getValue()).getProcessDefinitionKey() == item.record().getKey()).toList();
        timers = RecordStore.TIMERS.findBy(x -> ((TimerRecordValue)x.getValue()).getProcessDefinitionKey() == item.record().getKey()).filter(x -> ((TimerRecordValue)x.record().getValue()).getProcessInstanceKey() <= 0L).toList();
        return new ProcessWrapper(item, xml, new ProcessDiagram(elements), instances, messages, signals, timers);
    }

    @NonBlocking
    public String xml(long id) {
        return new String(((Process)RecordStore.PROCESS_DEFINITIONS_XML.get(id).record().getValue()).getResource());
    }

    @NonBlocking
    public InstanceWrapper instance(long id) {
        byte[] xml = null;
        RecordStoreItem<ProcessInstanceRecordValue> item = RecordStore.INSTANCES.get(id);
        if (item == null) {
            return null;
        }
        boolean active = item.data().get("end") == "";
        RecordStoreItem<Process> tmp = RecordStore.PROCESS_DEFINITIONS_XML.get(((ProcessInstanceRecordValue)item.record().getValue()).getProcessDefinitionKey());
        if (tmp != null) {
            xml = ((Process)tmp.record().getValue()).getResource();
        }
        if (xml == null) {
            return null;
        }
        RecordStoreItem<ProcessInstanceRecordValue> parent = null;
        if (((ProcessInstanceRecordValue)item.record().getValue()).getParentProcessInstanceKey() > 0L) {
            parent = RecordStore.INSTANCES.get(((ProcessInstanceRecordValue)item.record().getValue()).getParentProcessInstanceKey());
        }
        HashSet<String> completedActivities = new HashSet<String>();
        HashSet<String> completedItems = new HashSet<String>();
        ArrayList<String> takenSequenceFlows = new ArrayList<String>();
        HashMap completedElementsById = new HashMap();
        HashMap enteredElementsById = new HashMap();
        HashSet completedElementInstances = new HashSet();
        HashMap<Long, String> elementIdsForKeys = new HashMap<Long, String>();
        elementIdsForKeys.put(((ProcessInstanceRecordValue)item.record().getValue()).getProcessInstanceKey(), ((ProcessInstanceRecordValue)item.record().getValue()).getBpmnProcessId());
        List<RecordStoreItem<ProcessInstanceRecordValue>> events = RecordStore.ELEMENT_INSTANCES.findBy(x -> ((ProcessInstanceRecordValue)x.getValue()).getProcessInstanceKey() == ((ProcessInstanceRecordValue)item.record().getValue()).getProcessInstanceKey()).toList();
        events.forEach(e -> {
            long key = e.record().getKey();
            String elementId = ((ProcessInstanceRecordValue)e.record().getValue()).getElementId();
            elementIdsForKeys.put(key, elementId);
            if (ProcessInstanceIntent.ELEMENT_COMPLETED.name().equals(e.record().getIntent().name()) && BpmnElementType.PROCESS != ((ProcessInstanceRecordValue)e.record().getValue()).getBpmnElementType()) {
                completedItems.add(elementId);
            }
            if (ProcessInstanceIntent.ELEMENT_COMPLETED.name().equals(e.record().getIntent().name()) || ProcessInstanceIntent.ELEMENT_TERMINATED.name().equals(e.record().getIntent().name())) {
                completedElementInstances.add(key);
                if (BpmnElementType.PROCESS != ((ProcessInstanceRecordValue)e.record().getValue()).getBpmnElementType()) {
                    completedActivities.add(elementId);
                }
                if (BpmnElementType.MULTI_INSTANCE_BODY != ((ProcessInstanceRecordValue)e.record().getValue()).getBpmnElementType()) {
                    completedElementsById.compute(elementId, ZeebeJsonRPCService::count);
                }
            }
            if (ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN.name().equals(e.record().getIntent().name())) {
                takenSequenceFlows.add(elementId);
            }
            if (ProcessInstanceIntent.ELEMENT_ACTIVATED.name().equals(e.record().getIntent().name()) && BpmnElementType.MULTI_INSTANCE_BODY != ((ProcessInstanceRecordValue)e.record().getValue()).getBpmnElementType() && BpmnElementType.PROCESS != ((ProcessInstanceRecordValue)e.record().getValue()).getBpmnElementType()) {
                enteredElementsById.compute(elementId, ZeebeJsonRPCService::count);
            }
        });
        ArrayList<RecordStoreItem<ProcessInstanceRecordValue>> ancestorActivities = new ArrayList<RecordStoreItem<ProcessInstanceRecordValue>>();
        ArrayList<RecordStoreItem<ProcessInstanceRecordValue>> terminateActiveActivities = new ArrayList<RecordStoreItem<ProcessInstanceRecordValue>>();
        List<String> activeActivitiesTmp = events.stream().filter(e -> BpmnElementType.PROCESS != ((ProcessInstanceRecordValue)e.record().getValue()).getBpmnElementType()).filter(e -> ProcessInstanceIntent.ELEMENT_ACTIVATED.name().equals(e.record().getIntent().name())).peek(ancestorActivities::add).filter(e -> !completedActivities.contains(((ProcessInstanceRecordValue)e.record().getValue()).getElementId())).peek(terminateActiveActivities::add).map(e -> ((ProcessInstanceRecordValue)e.record().getValue()).getElementId()).toList();
        List<ElementInstanceState> elementStates = enteredElementsById.entrySet().stream().map(e -> {
            long completedInstances = completedElementsById.getOrDefault(e.getKey(), 0L);
            return new ElementInstanceState((String)e.getKey(), (Long)e.getValue() - completedInstances, completedInstances);
        }).toList();
        ArrayList<String> activeActivities = new ArrayList<String>(activeActivitiesTmp);
        List<RecordStoreItem<IncidentRecordValue>> tt = RecordStore.INCIDENTS.findBy(x -> ((IncidentRecordValue)x.getValue()).getProcessInstanceKey() == id).toList();
        List<InstanceIncident> incidents = tt.stream().map(x -> new InstanceIncident(elementIdsForKeys.getOrDefault(((IncidentRecordValue)x.record().getValue()).getElementInstanceKey(), ""), (RecordStoreItem<IncidentRecordValue>)x)).toList();
        List<String> incidentActivities = incidents.stream().filter(x -> !IncidentIntent.RESOLVED.name().equals(x.item().record().getIntent().name())).map(x -> (String)elementIdsForKeys.get(((IncidentRecordValue)x.item.record().getValue()).getElementInstanceKey())).distinct().toList();
        activeActivities.removeAll(incidentActivities);
        List<ActiveScope> activeScopes = null;
        if (active) {
            activeScopes = events.stream().filter(e -> ProcessInstanceIntent.ELEMENT_ACTIVATED.name().equals(e.record().getIntent().name())).map(e -> e.record().getKey()).filter(e -> !completedElementInstances.contains(e)).map(k -> new ActiveScope((long)k, (String)elementIdsForKeys.get(k))).toList();
        }
        Stream<RecordStoreItem<VariableRecordValue>> variablesRaw = RecordStore.VARIABLES.findBy(x -> ((VariableRecordValue)x.getValue()).getProcessInstanceKey() == id);
        Map<VariableId, List<RecordStoreItem>> variablesMap = variablesRaw.collect(Collectors.groupingBy(e -> new VariableId(((VariableRecordValue)e.record().getValue()).getScopeKey(), ((VariableRecordValue)e.record().getValue()).getName())));
        List<Variable> variables = variablesMap.entrySet().stream().map(e -> {
            RecordStoreItem x = (RecordStoreItem)((List)e.getValue()).get(0);
            return new Variable((String)elementIdsForKeys.get(((VariableId)e.getKey()).scopeKey()), ((VariableRecordValue)x.record().getValue()).getName(), ((VariableRecordValue)x.record().getValue()).getScopeKey(), ((VariableRecordValue)x.record().getValue()).getValue(), x.data().get("time"), (List)e.getValue());
        }).toList();
        List<RecordStoreItem<JobRecordValue>> jobs = RecordStore.JOBS.findBy(x -> ((JobRecordValue)x.getValue()).getProcessInstanceKey() == id).toList();
        List<RecordStoreItem<ErrorRecordValue>> errors = RecordStore.ERRORS.findBy(x -> ((ErrorRecordValue)x.getValue()).getProcessInstanceKey() == id).toList();
        List<RecordStoreItem<TimerRecordValue>> timers = RecordStore.TIMERS.findBy(x -> ((TimerRecordValue)x.getValue()).getProcessInstanceKey() == id).toList();
        List<RecordStoreItem<ProcessMessageSubscriptionRecordValue>> messageSubscriptions = RecordStore.PROCESS_MESSAGE_SUBSCRIPTIONS.findBy(x -> ((ProcessMessageSubscriptionRecordValue)x.getValue()).getProcessInstanceKey() == id).toList();
        List<RecordStoreItem<EscalationRecordValue>> escalations = RecordStore.ESCALATIONS.findBy(x -> ((EscalationRecordValue)x.getValue()).getProcessInstanceKey() == id).toList();
        List<RecordStoreItem<JobRecordValue>> userTasks = RecordStore.USER_TASKS.findBy(x -> ((JobRecordValue)x.getValue()).getProcessInstanceKey() == id).toList();
        List<CalledProcessInstance> callProcessInstances = RecordStore.INSTANCES.findBy(x -> ((ProcessInstanceRecordValue)x.getValue()).getParentProcessInstanceKey() == id).map(x -> new CalledProcessInstance((String)elementIdsForKeys.get(((ProcessInstanceRecordValue)x.record().getValue()).getParentElementInstanceKey()), (RecordStoreItem<ProcessInstanceRecordValue>)x)).toList();
        ArrayList<ActivateElementItem> activateActivities = new ArrayList<ActivateElementItem>();
        BpmnModelInstance bpmn = BpmnModel.loadModel(xml);
        HashMap flowElements = new HashMap();
        bpmn.getModelElementsByType(FlowElement.class).forEach(e -> {
            String name = Optional.ofNullable(e.getName()).orElse("");
            flowElements.put(e.getId(), name);
            BpmnElementType type = BpmnElementType.bpmnElementTypeFor((String)e.getElementType().getTypeName());
            if (type != null && !MODIFY_UNSUPPORTED_ELEMENT_TYPES.contains(type.name())) {
                activateActivities.add(new ActivateElementItem(e.getId(), name));
            }
        });
        List<BpmnModel.BpmnElementInfo> bpmnElementInfos = BpmnModel.loadBpmnElements(bpmn);
        List<AuditLog> auditLogEntries = events.stream().map(x -> new AuditLog(flowElements.getOrDefault(((ProcessInstanceRecordValue)x.record().getValue()).getElementId(), ""), (RecordStoreItem<ProcessInstanceRecordValue>)x)).toList();
        Diagram diagram = new Diagram(activeActivities, incidentActivities, takenSequenceFlows, completedActivities, bpmnElementInfos);
        return new InstanceWrapper(active, item, parent, new String(xml), diagram, elementStates, activeScopes, auditLogEntries, callProcessInstances, incidents, jobs, messageSubscriptions, timers, errors, variables, completedItems, terminateActiveActivities, activateActivities, ancestorActivities, escalations, userTasks);
    }

    static Long count(String key, Long value) {
        if (value == null) {
            return 1L;
        }
        return value + 1L;
    }

    public record ProcessWrapper(RecordStoreItem<Process> item, String xml, ProcessDiagram diagram, List<RecordStoreItem<ProcessInstanceRecordValue>> instances, List<RecordStoreItem<MessageStartEventSubscriptionRecordValue>> messages, List<RecordStoreItem<SignalSubscriptionRecordValue>> signals, List<RecordStoreItem<TimerRecordValue>> timers) {
    }

    public record ProcessDiagram(Map<String, Map<String, Long>> elements) {
    }

    public record Diagram(List<String> activeActivities, List<String> incidentActivities, List<String> takenSequenceFlows, Set<String> completedActivities, List<BpmnModel.BpmnElementInfo> bpmnElementInfos) {
    }

    public record InstanceWrapper(boolean active, RecordStoreItem<ProcessInstanceRecordValue> item, RecordStoreItem<ProcessInstanceRecordValue> parent, String xml, Diagram diagram, List<ElementInstanceState> elementStates, List<ActiveScope> activeScopes, List<AuditLog> auditLogEntries, List<CalledProcessInstance> callProcessInstances, List<InstanceIncident> incidents, List<RecordStoreItem<JobRecordValue>> jobs, List<RecordStoreItem<ProcessMessageSubscriptionRecordValue>> messageSubscriptions, List<RecordStoreItem<TimerRecordValue>> timers, List<RecordStoreItem<ErrorRecordValue>> errors, List<Variable> variables, Set<String> completedItems, List<RecordStoreItem<ProcessInstanceRecordValue>> terminateActiveActivities, List<ActivateElementItem> activateActivities, List<RecordStoreItem<ProcessInstanceRecordValue>> ancestorActivities, List<RecordStoreItem<EscalationRecordValue>> escalations, List<RecordStoreItem<JobRecordValue>> userTasks) {
    }

    public record AuditLog(String elementName, RecordStoreItem<ProcessInstanceRecordValue> item) {
    }

    public record ActivateElementItem(String id, String name) {
    }

    public record CalledProcessInstance(String elementId, RecordStoreItem<ProcessInstanceRecordValue> item) {
    }

    public record Variable(String elementId, String name, long scopeKey, String value, Object time, List<RecordStoreItem<VariableRecordValue>> variables) {
    }

    public record VariableId(long scopeKey, String name) {
    }

    public record ActiveScope(long value, String name) {
    }

    public record InstanceIncident(String elementName, RecordStoreItem<IncidentRecordValue> item) {
    }

    public record ElementInstanceState(String elementId, long activeInstances, long endedInstances) {
    }
}

