/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.zeebe.runtime.devmode;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.protocol.jackson.ZeebeProtocolModule;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.value.ErrorRecordValue;
import io.camunda.zeebe.protocol.record.value.EscalationRecordValue;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageStartEventSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessMessageSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.SignalRecordValue;
import io.camunda.zeebe.protocol.record.value.SignalSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.TimerRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.Process;
import io.quarkiverse.zeebe.runtime.devmode.store.RecordStore;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeebeRecordsHandler
implements Handler<RoutingContext> {
    private static final String SERVER_HEADER = "Server";
    private static final String SERVER_INFO = "zpt-debug/1.1";
    private static final Logger log = LoggerFactory.getLogger(ZeebeRecordsHandler.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new ZeebeProtocolModule());
    private static final Map<Integer, Long> positions = new HashMap<Integer, Long>();

    public void handle(RoutingContext rc) {
        Buffer buffer = rc.body().buffer();
        this.process(rc.response(), buffer);
    }

    private void process(HttpServerResponse response, Buffer buffer) {
        if (buffer.length() == 0) {
            this.response(response, 400);
        }
        byte[] bytes = buffer.getBytes();
        try {
            List records = (List)MAPPER.readValue(bytes, new TypeReference<List<Record<?>>>(){});
            if (records == null || records.isEmpty()) {
                this.response(response, 204);
                return;
            }
            for (Record record : records) {
                if (record.getRecordType() == RecordType.EVENT) {
                    switch (record.getValueType()) {
                        case PROCESS_INSTANCE: {
                            RecordStore.importProcessInstance((Record<ProcessInstanceRecordValue>)((Record)ZeebeRecordsHandler.value(record)));
                            break;
                        }
                        case PROCESS: {
                            RecordStore.importProcess((Record<Process>)((Record)ZeebeRecordsHandler.value(record)));
                            break;
                        }
                        case TIMER: {
                            RecordStore.importTimer((Record<TimerRecordValue>)((Record)ZeebeRecordsHandler.value(record)));
                            break;
                        }
                        case PROCESS_MESSAGE_SUBSCRIPTION: {
                            RecordStore.importMessageSubscription((Record<ProcessMessageSubscriptionRecordValue>)((Record)ZeebeRecordsHandler.value(record)));
                            break;
                        }
                        case MESSAGE_START_EVENT_SUBSCRIPTION: {
                            RecordStore.importMessageStartEventSubscription((Record<MessageStartEventSubscriptionRecordValue>)((Record)ZeebeRecordsHandler.value(record)));
                            break;
                        }
                        case ERROR: {
                            RecordStore.importError((Record<ErrorRecordValue>)((Record)ZeebeRecordsHandler.value(record)));
                            break;
                        }
                        case INCIDENT: {
                            RecordStore.importIncident((Record<IncidentRecordValue>)((Record)ZeebeRecordsHandler.value(record)));
                            break;
                        }
                        case JOB: {
                            RecordStore.importJob((Record<JobRecordValue>)((Record)ZeebeRecordsHandler.value(record)));
                            break;
                        }
                        case MESSAGE: {
                            RecordStore.importMessage((Record<MessageRecordValue>)((Record)ZeebeRecordsHandler.value(record)));
                            break;
                        }
                        case VARIABLE: {
                            RecordStore.importVariable((Record<VariableRecordValue>)((Record)ZeebeRecordsHandler.value(record)));
                            break;
                        }
                        case SIGNAL: {
                            RecordStore.importSignal((Record<SignalRecordValue>)((Record)ZeebeRecordsHandler.value(record)));
                            break;
                        }
                        case SIGNAL_SUBSCRIPTION: {
                            RecordStore.importSignalSubscription((Record<SignalSubscriptionRecordValue>)((Record)ZeebeRecordsHandler.value(record)));
                            break;
                        }
                        case ESCALATION: {
                            RecordStore.importEscalation((Record<EscalationRecordValue>)((Record)ZeebeRecordsHandler.value(record)));
                            break;
                        }
                        case USER_TASK: {
                            log.info("Add record {}}/{} ==> {}", new Object[]{record.getValueType(), record.getPosition(), record.getRecordType()});
                        }
                    }
                }
                positions.merge(record.getPartitionId(), record.getPosition(), Math::max);
            }
            this.createSuccessfulResponse(response, ((Record)records.get(0)).getPartitionId());
        }
        catch (IOException e) {
            log.warn("Failed to deserialize exported records", (Throwable)e);
            this.response(response, 400);
        }
    }

    private static <T> T value(Record<?> record) {
        Record<?> result = record;
        return (T)result;
    }

    private void createSuccessfulResponse(HttpServerResponse response, int partitionId) {
        Long position = positions.get(partitionId);
        if (position == null) {
            this.response(response, 204);
            return;
        }
        try {
            String responseBody = MAPPER.writeValueAsString(Collections.singletonMap("position", position));
            response.setStatusCode(200).putHeader(SERVER_HEADER, SERVER_INFO).end(responseBody);
        }
        catch (Exception ex) {
            log.warn("Failed to serialize response", (Throwable)ex);
            this.response(response, 400);
        }
    }

    private void response(HttpServerResponse response, int statusCode) {
        response.setStatusCode(statusCode).putHeader(SERVER_HEADER, SERVER_INFO).end();
    }
}

