/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.zeebe.runtime.devmode.store;

import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.instance.CatchEvent;
import io.camunda.zeebe.model.bpmn.instance.ConditionExpression;
import io.camunda.zeebe.model.bpmn.instance.ErrorEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.SequenceFlow;
import io.camunda.zeebe.model.bpmn.instance.ServiceTask;
import io.camunda.zeebe.model.bpmn.instance.TimerEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskDefinition;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class BpmnModel {
    public static BpmnModelInstance loadModel(byte[] data) {
        return Bpmn.readModelFromStream((InputStream)new ByteArrayInputStream(data));
    }

    public static List<BpmnElementInfo> loadBpmnElements(BpmnModelInstance bpmn) {
        ArrayList<BpmnElementInfo> infos = new ArrayList<BpmnElementInfo>();
        bpmn.getModelElementsByType(ServiceTask.class).forEach(x -> infos.add(new BpmnElementInfo(x.getId(), "job-type: " + ((ZeebeTaskDefinition)x.getSingleExtensionElement(ZeebeTaskDefinition.class)).getType())));
        bpmn.getModelElementsByType(SequenceFlow.class).forEach(x -> {
            ConditionExpression conditionExpression = x.getConditionExpression();
            if (conditionExpression != null && !conditionExpression.getTextContent().isEmpty()) {
                infos.add(new BpmnElementInfo(x.getId(), "condition: " + conditionExpression.getTextContent()));
            }
        });
        bpmn.getModelElementsByType(CatchEvent.class).forEach(catchEvent -> catchEvent.getEventDefinitions().forEach(x -> {
            if (x instanceof ErrorEventDefinition) {
                ErrorEventDefinition errorEventDef = (ErrorEventDefinition)x;
                infos.add(new BpmnElementInfo(catchEvent.getId(), "errorCode: " + errorEventDef.getError().getErrorCode()));
            }
            if (x instanceof TimerEventDefinition) {
                TimerEventDefinition timerEventDefinition = (TimerEventDefinition)x;
                Optional.ofNullable(timerEventDefinition.getTimeCycle()).or(() -> Optional.ofNullable(timerEventDefinition.getTimeDate())).or(() -> Optional.ofNullable(timerEventDefinition.getTimeDuration())).map(ModelElementInstance::getTextContent).ifPresent(timer -> infos.add(new BpmnElementInfo(catchEvent.getId(), "timer: " + timer)));
            }
        }));
        return infos;
    }

    public record BpmnElementInfo(String elementId, String info) {
    }
}

