/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.zeebe.runtime.devmode.store;

import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.quarkiverse.zeebe.runtime.devmode.store.RecordStoreItem;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class Store<RECORD extends RecordValue> {
    private final Map<Object, RecordStoreItem<RECORD>> data = new ConcurrentSkipListMap(Collections.reverseOrder());

    public static <RECORD extends RecordValue> Store<RECORD> create() {
        return new Store<RECORD>();
    }

    public RecordStoreItem<RECORD> putIfAbsent(Record<RECORD> record, Function<Record<RECORD>, Object> f) {
        Object id = f.apply(record);
        RecordStoreItem<RECORD> item = this.get(id);
        if (item != null) {
            return null;
        }
        return this.put(id, record);
    }

    public RecordStoreItem<RECORD> put(Record<RECORD> record, Function<Record<RECORD>, Object> f) {
        Object id = f.apply(record);
        return this.put(id, record);
    }

    private RecordStoreItem<RECORD> put(Object id, Record<RECORD> record) {
        RecordStoreItem<RECORD> item = this.createItem(id, record);
        RecordStoreItem<RECORD> old = this.data.put(item.id(), item);
        if (old != null && !old.data().isEmpty()) {
            item.data().putAll(old.data());
        }
        return item;
    }

    public Collection<RecordStoreItem<RECORD>> values() {
        return this.data.values();
    }

    public RecordStoreItem<RECORD> get(Object id) {
        return this.data.get(id);
    }

    public Optional<RecordStoreItem<RECORD>> findFirstBy(Predicate<Record<RECORD>> filter) {
        return this.data.values().stream().filter(x -> filter.test(x.record())).findFirst();
    }

    public Stream<RecordStoreItem<RECORD>> findBy(Predicate<Record<RECORD>> filter) {
        return this.data.values().stream().filter(x -> filter.test(x.record()));
    }

    protected RecordStoreItem<RECORD> createItem(Object id, Record<RECORD> record) {
        return new RecordStoreItem<RECORD>(id, record, new HashMap<String, Object>());
    }
}

