/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.zeebe.runtime.health;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.command.ClientStatusException;
import io.camunda.zeebe.client.api.response.BrokerInfo;
import io.camunda.zeebe.client.api.response.Topology;
import jakarta.inject.Inject;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
public class ZeebeHealthCheck
implements HealthCheck {
    @Inject
    ZeebeClient client;

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Zeebe health check");
        try {
            Topology topology = (Topology)this.client.newTopologyRequest().send().join();
            List brokers = topology.getBrokers();
            if (brokers.isEmpty()) {
                return builder.withData("reason", "No brokers found").down().build();
            }
            return builder.withData("brokers", brokers.stream().map(BrokerInfo::getAddress).collect(Collectors.joining(", "))).withData("version", topology.getGatewayVersion()).withData("size", (long)topology.getClusterSize()).withData("partitions", (long)topology.getPartitionsCount()).withData("replicationFactor", (long)topology.getReplicationFactor()).up().build();
        }
        catch (ClientStatusException e) {
            return builder.down().withData("reason", e.getMessage()).withData("code", (long)e.getStatusCode().value()).build();
        }
        catch (Exception ex) {
            return builder.down().withData("reason", ex.getMessage()).build();
        }
    }
}

