/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.zeebe.runtime.health;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.command.ClientStatusException;
import io.camunda.zeebe.client.api.response.Topology;
import jakarta.inject.Inject;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Liveness;

@Liveness
public class ZeebeTopologyHealthCheck
implements HealthCheck {
    @Inject
    ZeebeClient client;

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Zeebe topology health check");
        try {
            Topology topology = (Topology)this.client.newTopologyRequest().send().join();
            if (topology.getClusterSize() > 0) {
                return builder.up().build();
            }
            return builder.down().withData("reason", "No brokers found").build();
        }
        catch (ClientStatusException e) {
            return builder.down().withData("reason", e.getMessage()).withData("code", (long)e.getStatusCode().value()).build();
        }
        catch (Exception ex) {
            return builder.down().withData("reason", ex.getMessage()).build();
        }
    }
}

