/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.zeebe.runtime.tracing;

import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.quarkiverse.zeebe.runtime.tracing.TracingRecorder;
import io.quarkiverse.zeebe.runtime.tracing.ZeebeTracing;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;

@ApplicationScoped
public class OpenTelemetryTracingRecorder
implements TracingRecorder {
    @Inject
    OpenTelemetry openTelemetry;

    @Override
    public TracingRecorder.TracingContext createTracingContext(String clazz, String method, String name, ActivatedJob job) {
        Span span = OpenTelemetryTracingRecorder.createSpan(this.openTelemetry, clazz, method, name, job);
        Scope scope = span.makeCurrent();
        return new OpenTelemetryTracingContext(span, scope);
    }

    @Override
    public Collection<String> fields() {
        return this.openTelemetry.getPropagators().getTextMapPropagator().fields();
    }

    private static Span createSpan(OpenTelemetry openTelemetry, String clazz, String method, String spanName, ActivatedJob job) {
        TextMapPropagator textMapPropagator = openTelemetry.getPropagators().getTextMapPropagator();
        Context context = textMapPropagator.extract(Context.current(), (Object)job.getVariablesAsMap(), (TextMapGetter)new TextMapGetter<Map<String, Object>>(){

            public Iterable<String> keys(Map<String, Object> data) {
                return data.keySet();
            }

            @Nullable
            public String get(@Nullable Map<String, Object> data, String key) {
                if (data == null) {
                    return null;
                }
                Object o = data.get(key);
                if (o instanceof String) {
                    return (String)o;
                }
                return String.valueOf(o);
            }
        });
        final Span span = openTelemetry.getTracer("io.quarkus.opentelemetry").spanBuilder(spanName).setParent(context).setSpanKind(SpanKind.CONSUMER).startSpan();
        ZeebeTracing.setAttributes(clazz, method, job, new ZeebeTracing.AttributeConfigCallback(){

            @Override
            public void setAttribute(String key, long value) {
                span.setAttribute(key, value);
            }

            @Override
            public void setAttribute(String key, String value) {
                span.setAttribute(key, value);
            }
        });
        return span;
    }

    public static class OpenTelemetryTracingContext
    implements TracingRecorder.TracingContext {
        Span span;
        Scope scope;

        public OpenTelemetryTracingContext(Span span, Scope scope) {
            this.span = span;
            this.scope = scope;
        }

        @Override
        public void close() {
            this.scope.close();
            this.span.end();
        }

        @Override
        public void error(String key, Throwable t) {
            this.span.setStatus(StatusCode.ERROR);
            this.span.setAttribute(key, t.getMessage());
        }

        @Override
        public void ok() {
            this.span.setStatus(StatusCode.OK);
        }
    }
}

