/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.zeebe.runtime.tracing;

import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.ClientCall;
import io.grpc.ForwardingClientCall;
import io.quarkiverse.zeebe.runtime.tracing.ZeebeTracing;
import java.util.stream.Collectors;

public abstract class ZeebeForwardingClient<ReqT, RespT>
extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
    public ZeebeForwardingClient(ClientCall<ReqT, RespT> delegate) {
        super(delegate);
    }

    public void sendMessage(ReqT message) {
        if (message instanceof GatewayOuterClass.ActivateJobsRequest) {
            super.sendMessage(message);
            return;
        }
        if (message instanceof GatewayOuterClass.TopologyRequest) {
            super.sendMessage(message);
            return;
        }
        this.createTracingMessage(message);
    }

    protected abstract void createTracingMessage(ReqT var1);

    protected void sendTracingMessage(ReqT message, AttributeCallback span, AttributeCallback callSpan) {
        if (message instanceof GatewayOuterClass.CompleteJobRequest) {
            GatewayOuterClass.CompleteJobRequest r = (GatewayOuterClass.CompleteJobRequest)message;
            callSpan.setAttribute(ZeebeTracing.JOB_KEY, r.getJobKey()).setAttribute(ZeebeTracing.JOB_VARIABLES, r.getVariables());
        } else if (message instanceof GatewayOuterClass.CreateProcessInstanceRequest) {
            message = this.createProcessInstance(message);
            GatewayOuterClass.CreateProcessInstanceRequest r = (GatewayOuterClass.CreateProcessInstanceRequest)message;
            callSpan.setAttribute(ZeebeTracing.PROCESS_DEF_KEY, r.getProcessDefinitionKey()).setAttribute(ZeebeTracing.PROCESS_ID, r.getBpmnProcessId()).setAttribute(ZeebeTracing.PROCESS_DEF_VER, r.getVersion()).setAttribute(ZeebeTracing.PROCESS_VARIABLES, r.getVariables());
        } else if (message instanceof GatewayOuterClass.FailJobRequest) {
            GatewayOuterClass.FailJobRequest r = (GatewayOuterClass.FailJobRequest)message;
            span.setError().setAttribute(ZeebeTracing.FAIL_MESSAGE, r.getErrorMessage());
            callSpan.setAttribute(ZeebeTracing.JOB_KEY, r.getJobKey()).setAttribute(ZeebeTracing.JOB_RETRIES, r.getRetries()).setAttribute(ZeebeTracing.FAIL_MESSAGE, r.getErrorMessage());
        } else if (message instanceof GatewayOuterClass.ThrowErrorRequest) {
            GatewayOuterClass.ThrowErrorRequest r = (GatewayOuterClass.ThrowErrorRequest)message;
            span.setError().setAttribute(ZeebeTracing.THROW_ERROR_MESSAGE, r.getErrorMessage()).setAttribute(ZeebeTracing.THROW_ERROR_CODE, r.getErrorCode());
            callSpan.setAttribute(ZeebeTracing.JOB_KEY, r.getJobKey()).setAttribute(ZeebeTracing.THROW_ERROR_MESSAGE, r.getErrorMessage()).setAttribute(ZeebeTracing.THROW_ERROR_CODE, r.getErrorCode());
        } else if (message instanceof GatewayOuterClass.CreateProcessInstanceWithResultRequest) {
            message = this.createProcessInstanceWithResult(message);
            GatewayOuterClass.CreateProcessInstanceWithResultRequest rr = (GatewayOuterClass.CreateProcessInstanceWithResultRequest)message;
            GatewayOuterClass.CreateProcessInstanceRequest r = rr.getRequest();
            callSpan.setAttribute(ZeebeTracing.REQUEST_TIMEOUT, rr.getRequestTimeout()).setAttribute(ZeebeTracing.PROCESS_DEF_KEY, r.getProcessDefinitionKey()).setAttribute(ZeebeTracing.PROCESS_ID, r.getBpmnProcessId()).setAttribute(ZeebeTracing.PROCESS_DEF_VER, r.getVersion()).setAttribute(ZeebeTracing.PROCESS_VARIABLES, r.getVariables());
        } else if (message instanceof GatewayOuterClass.PublishMessageRequest) {
            GatewayOuterClass.PublishMessageRequest r = (GatewayOuterClass.PublishMessageRequest)message;
            callSpan.setAttribute(ZeebeTracing.MESSAGE_CORRELATION_KEY, r.getCorrelationKey()).setAttribute(ZeebeTracing.MESSAGE_ID, r.getMessageId()).setAttribute(ZeebeTracing.MESSAGE_NAME, r.getName()).setAttribute(ZeebeTracing.MESSAGE_TIME_TO_LIVE, r.getTimeToLive()).setAttribute(ZeebeTracing.MESSAGE_VARIABLES, r.getVariables());
        } else if (message instanceof GatewayOuterClass.CancelProcessInstanceRequest) {
            GatewayOuterClass.CancelProcessInstanceRequest r = (GatewayOuterClass.CancelProcessInstanceRequest)message;
            callSpan.setAttribute(ZeebeTracing.PROCESS_INSTANCE_KEY, r.getProcessInstanceKey());
        } else if (message instanceof GatewayOuterClass.DeployResourceRequest) {
            GatewayOuterClass.DeployResourceRequest r = (GatewayOuterClass.DeployResourceRequest)message;
            String tmp = r.getResourcesList().stream().map(GatewayOuterClass.Resource::getName).collect(Collectors.joining(","));
            callSpan.setAttribute(ZeebeTracing.DEPLOY_RESOURCES, tmp);
        } else if (message instanceof GatewayOuterClass.ResolveIncidentRequest) {
            GatewayOuterClass.ResolveIncidentRequest r = (GatewayOuterClass.ResolveIncidentRequest)message;
            callSpan.setAttribute(ZeebeTracing.INCIDENT_KEY, r.getIncidentKey());
        } else if (message instanceof GatewayOuterClass.SetVariablesRequest) {
            GatewayOuterClass.SetVariablesRequest r = (GatewayOuterClass.SetVariablesRequest)message;
            callSpan.setAttribute(ZeebeTracing.PROCESS_ELEMENT_INSTANCE_KEY, r.getElementInstanceKey()).setAttribute(ZeebeTracing.PROCESS_VARIABLES, r.getVariables()).setAttribute(ZeebeTracing.PROCESS_VARIABLES_SCOPE, r.getLocal());
        } else if (message instanceof GatewayOuterClass.UpdateJobRetriesRequest) {
            GatewayOuterClass.UpdateJobRetriesRequest r = (GatewayOuterClass.UpdateJobRetriesRequest)message;
            callSpan.setAttribute(ZeebeTracing.JOB_KEY, r.getJobKey()).setAttribute(ZeebeTracing.JOB_RETRIES, r.getRetries());
        }
        super.sendMessage(message);
    }

    private <ReqT> ReqT createProcessInstance(ReqT message) {
        GatewayOuterClass.CreateProcessInstanceRequest request = this.convert((GatewayOuterClass.CreateProcessInstanceRequest)message);
        return (ReqT)request;
    }

    private <ReqT> ReqT createProcessInstanceWithResult(ReqT message) {
        GatewayOuterClass.CreateProcessInstanceWithResultRequest.Builder resultBuilder = GatewayOuterClass.CreateProcessInstanceWithResultRequest.newBuilder((GatewayOuterClass.CreateProcessInstanceWithResultRequest)((GatewayOuterClass.CreateProcessInstanceWithResultRequest)message));
        resultBuilder.setRequest(this.convert(resultBuilder.getRequest()));
        GatewayOuterClass.CreateProcessInstanceWithResultRequest request = resultBuilder.build();
        return (ReqT)request;
    }

    abstract GatewayOuterClass.CreateProcessInstanceRequest convert(GatewayOuterClass.CreateProcessInstanceRequest var1);

    static interface AttributeCallback {
        public AttributeCallback setError();

        public AttributeCallback setAttribute(String var1, String var2);

        public AttributeCallback setAttribute(String var1, int var2);

        public AttributeCallback setAttribute(String var1, long var2);

        public AttributeCallback setAttribute(String var1, boolean var2);
    }
}

