/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanConfigurator;
import io.quarkus.arc.processor.BeanDefiningAnnotation;
import io.quarkus.arc.processor.BeanDeploymentValidator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.BeanRegistrar;
import io.quarkus.arc.processor.BeanResolver;
import io.quarkus.arc.processor.Beans;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.ContextConfigurator;
import io.quarkus.arc.processor.ContextRegistrar;
import io.quarkus.arc.processor.DisposerInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.InterceptorResolver;
import io.quarkus.arc.processor.Interceptors;
import io.quarkus.arc.processor.ObserverInfo;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.arc.processor.StereotypeInfo;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.ResultHandle;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.inject.Model;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.DeploymentException;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class BeanDeployment {
    private static final Logger LOGGER = Logger.getLogger(BeanDeployment.class);
    private final IndexView index;
    private final Map<DotName, ClassInfo> qualifiers;
    private final Map<DotName, ClassInfo> interceptorBindings;
    private final Map<DotName, StereotypeInfo> stereotypes;
    private final List<BeanInfo> beans;
    private final List<InterceptorInfo> interceptors;
    private final List<ObserverInfo> observers;
    private final BeanResolver beanResolver;
    private final InterceptorResolver interceptorResolver;
    private final AnnotationStore annotationStore;
    private final Set<DotName> resourceAnnotations;
    private final List<InjectionPointInfo> injectionPoints;
    private final boolean removeUnusedBeans;
    private final List<Predicate<BeanInfo>> unusedExclusions;
    private final Set<BeanInfo> removedBeans;
    private final Map<ScopeInfo, Function<MethodCreator, ResultHandle>> customContexts;

    BeanDeployment(IndexView index, Collection<BeanDefiningAnnotation> additionalBeanDefiningAnnotations, List<AnnotationsTransformer> annotationTransformers) {
        this(index, additionalBeanDefiningAnnotations, annotationTransformers, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, false, null, Collections.emptyMap());
    }

    BeanDeployment(IndexView index, Collection<BeanDefiningAnnotation> additionalBeanDefiningAnnotations, List<AnnotationsTransformer> annotationTransformers, Collection<DotName> resourceAnnotations, List<BeanRegistrar> beanRegistrars, List<ContextRegistrar> contextRegistrars, BeanProcessor.BuildContextImpl buildContext, boolean removeUnusedBeans, List<Predicate<BeanInfo>> unusedExclusions, Map<DotName, Collection<AnnotationInstance>> additionalStereotypes) {
        long start = System.currentTimeMillis();
        HashSet<BeanDefiningAnnotation> beanDefiningAnnotations = new HashSet<BeanDefiningAnnotation>();
        if (additionalBeanDefiningAnnotations != null) {
            beanDefiningAnnotations.addAll(additionalBeanDefiningAnnotations);
        }
        this.resourceAnnotations = new HashSet<DotName>(resourceAnnotations);
        this.index = index;
        this.annotationStore = new AnnotationStore(annotationTransformers, buildContext);
        this.removeUnusedBeans = removeUnusedBeans;
        this.unusedExclusions = removeUnusedBeans ? unusedExclusions : null;
        this.removedBeans = new HashSet<BeanInfo>();
        if (buildContext != null) {
            buildContext.putInternal(BuildExtension.Key.ANNOTATION_STORE.asString(), this.annotationStore);
        }
        this.customContexts = new HashMap<ScopeInfo, Function<MethodCreator, ResultHandle>>();
        this.registerCustomContexts(contextRegistrars, beanDefiningAnnotations, buildContext);
        this.qualifiers = BeanDeployment.findQualifiers(index);
        this.interceptorBindings = BeanDeployment.findInterceptorBindings(index);
        this.stereotypes = this.findStereotypes(index, this.interceptorBindings, beanDefiningAnnotations, this.customContexts, additionalStereotypes);
        this.injectionPoints = new ArrayList<InjectionPointInfo>();
        this.interceptors = this.findInterceptors(this.injectionPoints);
        this.beanResolver = new BeanResolver(this);
        ArrayList<ObserverInfo> observers = new ArrayList<ObserverInfo>();
        this.beans = this.findBeans(BeanDeployment.initBeanDefiningAnnotations(beanDefiningAnnotations, this.stereotypes.keySet()), observers, this.injectionPoints);
        if (buildContext != null) {
            buildContext.putInternal(BuildExtension.Key.INJECTION_POINTS.asString(), Collections.unmodifiableList(this.injectionPoints));
            buildContext.putInternal(BuildExtension.Key.OBSERVERS.asString(), Collections.unmodifiableList(observers));
            buildContext.putInternal(BuildExtension.Key.BEANS.asString(), Collections.unmodifiableList(this.beans));
        }
        this.registerSyntheticBeans(beanRegistrars, buildContext);
        this.observers = observers;
        this.interceptorResolver = new InterceptorResolver(this);
        LOGGER.debugf("Bean deployment created in %s ms", System.currentTimeMillis() - start);
    }

    public Collection<BeanInfo> getBeans() {
        return Collections.unmodifiableList(this.beans);
    }

    public Collection<BeanInfo> getRemovedBeans() {
        return Collections.unmodifiableSet(this.removedBeans);
    }

    Collection<ObserverInfo> getObservers() {
        return this.observers;
    }

    Collection<InterceptorInfo> getInterceptors() {
        return this.interceptors;
    }

    IndexView getIndex() {
        return this.index;
    }

    BeanResolver getBeanResolver() {
        return this.beanResolver;
    }

    InterceptorResolver getInterceptorResolver() {
        return this.interceptorResolver;
    }

    ClassInfo getQualifier(DotName name) {
        return this.qualifiers.get(name);
    }

    ClassInfo getInterceptorBinding(DotName name) {
        return this.interceptorBindings.get(name);
    }

    StereotypeInfo getStereotype(DotName name) {
        return this.stereotypes.get(name);
    }

    Set<DotName> getResourceAnnotations() {
        return this.resourceAnnotations;
    }

    AnnotationStore getAnnotationStore() {
        return this.annotationStore;
    }

    Collection<AnnotationInstance> getAnnotations(AnnotationTarget target) {
        return this.annotationStore.getAnnotations(target);
    }

    AnnotationInstance getAnnotation(AnnotationTarget target, DotName name) {
        return this.annotationStore.getAnnotation(target, name);
    }

    Map<ScopeInfo, Function<MethodCreator, ResultHandle>> getCustomContexts() {
        return this.customContexts;
    }

    ScopeInfo getScope(DotName scopeAnnotationName) {
        return BeanDeployment.getScope(scopeAnnotationName, this.customContexts);
    }

    static ScopeInfo getScope(DotName scopeAnnotationName, Map<ScopeInfo, Function<MethodCreator, ResultHandle>> customContexts) {
        BuiltinScope builtin = BuiltinScope.from(scopeAnnotationName);
        if (builtin != null) {
            return builtin.getInfo();
        }
        for (ScopeInfo customScope : customContexts.keySet()) {
            if (!customScope.getDotName().equals((Object)scopeAnnotationName)) continue;
            return customScope;
        }
        return null;
    }

    static ScopeInfo getValidScope(Collection<ScopeInfo> stereotypeScopes, AnnotationTarget target) {
        switch (stereotypeScopes.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return stereotypeScopes.iterator().next();
            }
        }
        throw new DefinitionException("All stereotypes must specify the same scope or the bean must declare a scope: " + target + " declares scopes " + stereotypeScopes.stream().map(ScopeInfo::getDotName).map(DotName::toString).collect(Collectors.joining(", ")));
    }

    boolean hasAnnotation(AnnotationTarget target, DotName name) {
        return this.annotationStore.hasAnnotation(target, name);
    }

    void validate(BeanProcessor.BuildContextImpl buildContext, List<BeanDeploymentValidator> validators) {
        long start = System.currentTimeMillis();
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        this.validateBeans(errors);
        ValidationContextImpl validationContext = new ValidationContextImpl(buildContext);
        for (BeanDeploymentValidator validator : validators) {
            validator.validate(validationContext);
        }
        errors.addAll(validationContext.getErrors());
        this.processErrors(errors);
        LOGGER.debugf("Bean deployment validated in %s ms", System.currentTimeMillis() - start);
    }

    void init() {
        long start = System.currentTimeMillis();
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        for (BeanInfo bean : this.beans) {
            bean.init(errors);
        }
        for (ObserverInfo observer : this.observers) {
            observer.init(errors);
        }
        for (InterceptorInfo interceptor : this.interceptors) {
            interceptor.init(errors);
        }
        this.processErrors(errors);
        if (this.removeUnusedBeans) {
            long removalStart = System.currentTimeMillis();
            HashSet<BeanInfo> removable = new HashSet<BeanInfo>();
            HashSet<BeanInfo> unusedProducers = new HashSet<BeanInfo>();
            List producers = this.beans.stream().filter(b -> b.isProducerMethod() || b.isProducerField()).collect(Collectors.toList());
            List instanceInjectionPoints = this.injectionPoints.stream().filter(ip -> BuiltinBean.resolve(ip) == BuiltinBean.INSTANCE).collect(Collectors.toList());
            for (BeanInfo bean : this.beans) {
                if (bean.getName() != null || this.unusedExclusions.stream().anyMatch(e -> e.test(bean)) || this.injectionPoints.stream().anyMatch(ip -> bean.equals(ip.getResolvedBean())) || this.observers.stream().anyMatch(o -> bean.equals(o.getDeclaringBean())) || producers.stream().anyMatch(b -> bean.equals(b.getDeclaringBean())) || instanceInjectionPoints.stream().anyMatch(ip -> Beans.matchesType(bean, (Type)ip.getRequiredType().asParameterizedType().arguments().get(0)) && ip.getRequiredQualifiers().stream().allMatch(q -> Beans.hasQualifier(bean, q)))) continue;
                if (bean.isProducerField() || bean.isProducerMethod()) {
                    unusedProducers.add(bean);
                }
                removable.add(bean);
            }
            if (!unusedProducers.isEmpty()) {
                Map<BeanInfo, List<BeanInfo>> declaringMap = producers.stream().collect(Collectors.groupingBy(BeanInfo::getDeclaringBean));
                for (Map.Entry<BeanInfo, List<BeanInfo>> entry : declaringMap.entrySet()) {
                    if (!unusedProducers.containsAll((Collection)entry.getValue())) continue;
                    removable.add(entry.getKey());
                }
            }
            if (!removable.isEmpty()) {
                this.beans.removeAll(removable);
                this.removedBeans.addAll(removable);
                this.removedBeans.forEach(b -> LOGGER.debugf("Removed unused %s", b));
            }
            LOGGER.debugf("Removed %s unused beans in %s ms", (long)removable.size(), System.currentTimeMillis() - removalStart);
        }
        LOGGER.debugf("Bean deployment initialized in %s ms", System.currentTimeMillis() - start);
    }

    static Map<DotName, ClassInfo> findQualifiers(IndexView index) {
        HashMap<DotName, ClassInfo> qualifiers = new HashMap<DotName, ClassInfo>();
        for (AnnotationInstance qualifier : index.getAnnotations(DotNames.QUALIFIER)) {
            qualifiers.put(qualifier.target().asClass().name(), qualifier.target().asClass());
        }
        return qualifiers;
    }

    static Map<DotName, ClassInfo> findInterceptorBindings(IndexView index) {
        HashMap<DotName, ClassInfo> bindings = new HashMap<DotName, ClassInfo>();
        for (AnnotationInstance binding : index.getAnnotations(DotNames.INTERCEPTOR_BINDING)) {
            bindings.put(binding.target().asClass().name(), binding.target().asClass());
        }
        return bindings;
    }

    Map<DotName, StereotypeInfo> findStereotypes(IndexView index, Map<DotName, ClassInfo> interceptorBindings, Collection<BeanDefiningAnnotation> additionalBeanDefiningAnnotations, Map<ScopeInfo, Function<MethodCreator, ResultHandle>> customContexts, Map<DotName, Collection<AnnotationInstance>> additionalStereotypes) {
        HashMap<DotName, StereotypeInfo> stereotypes = new HashMap<DotName, StereotypeInfo>();
        ArrayList<AnnotationInstance> stereotypeAnnotations = new ArrayList<AnnotationInstance>(index.getAnnotations(DotNames.STEREOTYPE));
        for (Collection<AnnotationInstance> annotations : additionalStereotypes.values()) {
            stereotypeAnnotations.addAll(annotations);
        }
        for (AnnotationInstance stereotype : stereotypeAnnotations) {
            DotName stereotypeName = stereotype.target().asClass().name();
            ClassInfo stereotypeClass = index.getClassByName(stereotypeName);
            if (stereotypeClass == null) continue;
            boolean isAlternative = false;
            ArrayList<ScopeInfo> scopes = new ArrayList<ScopeInfo>();
            ArrayList<AnnotationInstance> bindings = new ArrayList<AnnotationInstance>();
            boolean isNamed = false;
            for (AnnotationInstance annotation : this.getAnnotations((AnnotationTarget)stereotypeClass)) {
                if (DotNames.ALTERNATIVE.equals((Object)annotation.name())) {
                    isAlternative = true;
                    continue;
                }
                if (interceptorBindings.containsKey(annotation.name())) {
                    bindings.add(annotation);
                    continue;
                }
                if (DotNames.NAMED.equals((Object)annotation.name())) {
                    if (annotation.value() != null && !annotation.value().asString().isEmpty()) {
                        throw new DefinitionException("Stereotype must not declare @Named with a non-empty value: " + stereotypeClass);
                    }
                    isNamed = true;
                    continue;
                }
                ScopeInfo scope = BeanDeployment.getScope(annotation.name(), customContexts);
                if (scope == null) continue;
                scopes.add(scope);
            }
            ScopeInfo scope = BeanDeployment.getValidScope(scopes, (AnnotationTarget)stereotypeClass);
            stereotypes.put(stereotypeName, new StereotypeInfo(scope, bindings, isAlternative, isNamed, stereotypeClass));
        }
        if (additionalBeanDefiningAnnotations != null) {
            for (BeanDefiningAnnotation i : additionalBeanDefiningAnnotations) {
                if (i.getDefaultScope() == null) continue;
                ScopeInfo scope = BeanDeployment.getScope(i.getDefaultScope(), customContexts);
                stereotypes.put(i.getAnnotation(), new StereotypeInfo(scope, Collections.emptyList(), false, false, index.getClassByName(i.getAnnotation())));
            }
        }
        return stereotypes;
    }

    private void registerSyntheticBeans(List<BeanRegistrar> beanRegistrars, final BuildExtension.BuildContext buildContext) {
        if (!beanRegistrars.isEmpty()) {
            BeanRegistrar.RegistrationContext registrationContext = new BeanRegistrar.RegistrationContext(){

                @Override
                public <T> BeanConfigurator<T> configure(DotName beanClassName) {
                    return new BeanConfigurator(beanClassName, BeanDeployment.this, BeanDeployment.this.beans::add);
                }

                @Override
                public <V> V get(BuildExtension.Key<V> key) {
                    return buildContext.get(key);
                }

                @Override
                public <V> V put(BuildExtension.Key<V> key, V value) {
                    return buildContext.put(key, value);
                }
            };
            for (BeanRegistrar registrar : beanRegistrars) {
                registrar.register(registrationContext);
            }
        }
    }

    private void registerCustomContexts(List<ContextRegistrar> contextRegistrars, final Collection<BeanDefiningAnnotation> beanDefiningAnnotations, final BuildExtension.BuildContext buildContext) {
        if (!contextRegistrars.isEmpty()) {
            ContextRegistrar.RegistrationContext registrationContext = new ContextRegistrar.RegistrationContext(){

                @Override
                public <V> V put(BuildExtension.Key<V> key, V value) {
                    return buildContext.put(key, value);
                }

                @Override
                public <V> V get(BuildExtension.Key<V> key) {
                    return buildContext.get(key);
                }

                @Override
                public ContextConfigurator configure(Class<? extends Annotation> scopeAnnotation) {
                    return new ContextConfigurator(scopeAnnotation, c -> {
                        ScopeInfo scope = new ScopeInfo(c.scopeAnnotation, c.isNormal);
                        beanDefiningAnnotations.add(new BeanDefiningAnnotation(scope.getDotName(), null));
                        BeanDeployment.this.customContexts.put(scope, c.creator);
                    });
                }
            };
            for (ContextRegistrar contextRegistrar : contextRegistrars) {
                contextRegistrar.register(registrationContext);
            }
        }
    }

    private void validateBeans(List<Throwable> errors) {
        HashMap<String, ArrayList<BeanInfo>> namedBeans = new HashMap<String, ArrayList<BeanInfo>>();
        for (BeanInfo beanInfo : this.beans) {
            if (beanInfo.getName() != null) {
                ArrayList<BeanInfo> named = (ArrayList<BeanInfo>)namedBeans.get(beanInfo.getName());
                if (named == null) {
                    named = new ArrayList<BeanInfo>();
                    namedBeans.put(beanInfo.getName(), named);
                }
                named.add(beanInfo);
            }
            beanInfo.validate(errors);
        }
        if (!namedBeans.isEmpty()) {
            for (Map.Entry entry : namedBeans.entrySet()) {
                if (((List)entry.getValue()).size() <= 1 || Beans.resolveAmbiguity((List)entry.getValue()) != null) continue;
                errors.add((Throwable)new DeploymentException("Unresolvable ambiguous bean name detected: " + (String)entry.getKey() + "\nBeans:\n" + ((List)entry.getValue()).stream().map(Object::toString).collect(Collectors.joining("\n"))));
            }
        }
    }

    private List<BeanInfo> findBeans(Collection<DotName> beanDefiningAnnotations, List<ObserverInfo> observers, List<InjectionPointInfo> injectionPoints) {
        Injection injection;
        BeanInfo declaringBean;
        HashSet<ClassInfo> beanClasses = new HashSet<ClassInfo>();
        HashSet<MethodInfo> producerMethods = new HashSet<MethodInfo>();
        HashSet<MethodInfo> disposerMethods = new HashSet<MethodInfo>();
        HashSet<FieldInfo> producerFields = new HashSet<FieldInfo>();
        HashSet<MethodInfo> syncObserverMethods = new HashSet<MethodInfo>();
        HashSet<MethodInfo> asyncObserverMethods = new HashSet<MethodInfo>();
        for (ClassInfo beanClass : this.index.getKnownClasses()) {
            if (Modifier.isInterface(beanClass.flags()) || DotNames.ENUM.equals((Object)beanClass.superName()) || beanClass.nestingType().equals((Object)ClassInfo.NestingType.ANONYMOUS) || beanClass.nestingType().equals((Object)ClassInfo.NestingType.LOCAL) || beanClass.nestingType().equals((Object)ClassInfo.NestingType.INNER) && !Modifier.isStatic(beanClass.flags())) continue;
            if (!beanClass.hasNoArgsConstructor()) {
                int numberOfConstructorsWithoutInject = 0;
                int numberOfConstructorsWithInject = 0;
                for (MethodInfo m : beanClass.methods()) {
                    if (!m.name().equals("<init>")) continue;
                    if (m.hasAnnotation(DotNames.INJECT)) {
                        ++numberOfConstructorsWithInject;
                        continue;
                    }
                    ++numberOfConstructorsWithoutInject;
                }
                if (numberOfConstructorsWithInject == 0 && numberOfConstructorsWithoutInject != 1) continue;
            }
            if (this.annotationStore.hasAnnotation((AnnotationTarget)beanClass, DotNames.VETOED) || this.annotationStore.hasAnnotation((AnnotationTarget)beanClass, DotNames.INTERCEPTOR) || beanClass.interfaceNames().contains(DotNames.EXTENSION)) continue;
            boolean hasBeanDefiningAnnotation = false;
            if (this.annotationStore.hasAnyAnnotation((AnnotationTarget)beanClass, beanDefiningAnnotations)) {
                hasBeanDefiningAnnotation = true;
                beanClasses.add(beanClass);
            }
            for (MethodInfo method : beanClass.methods()) {
                if (this.annotationStore.getAnnotations((AnnotationTarget)method).isEmpty()) continue;
                if (this.annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.PRODUCES)) {
                    producerMethods.add(method);
                    if (hasBeanDefiningAnnotation) continue;
                    LOGGER.debugf("Producer method found but %s has no bean defining annotation - using @Dependent", (Object)beanClass);
                    beanClasses.add(beanClass);
                    continue;
                }
                if (this.annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.DISPOSES)) {
                    disposerMethods.add(method);
                    continue;
                }
                if (this.annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.OBSERVES)) {
                    syncObserverMethods.add(method);
                    if (hasBeanDefiningAnnotation) continue;
                    LOGGER.debugf("Observer method found but %s has no bean defining annotation - using @Dependent", (Object)beanClass);
                    beanClasses.add(beanClass);
                    continue;
                }
                if (!this.annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.OBSERVES_ASYNC)) continue;
                asyncObserverMethods.add(method);
                if (hasBeanDefiningAnnotation) continue;
                LOGGER.debugf("Observer method found but %s has no bean defining annotation - using @Dependent", (Object)beanClass);
                beanClasses.add(beanClass);
            }
            for (FieldInfo field : beanClass.fields()) {
                if (!this.annotationStore.hasAnnotation((AnnotationTarget)field, DotNames.PRODUCES)) continue;
                producerFields.add(field);
                if (hasBeanDefiningAnnotation) continue;
                LOGGER.debugf("Producer field found but %s has no bean defining annotation - using @Dependent", (Object)beanClass);
                beanClasses.add(beanClass);
            }
        }
        ArrayList<BeanInfo> beans = new ArrayList<BeanInfo>();
        HashMap<ClassInfo, BeanInfo> beanClassToBean = new HashMap<ClassInfo, BeanInfo>();
        for (ClassInfo beanClass : beanClasses) {
            BeanInfo classBean = Beans.createClassBean(beanClass, this);
            beans.add(classBean);
            beanClassToBean.put(beanClass, classBean);
            injectionPoints.addAll(classBean.getAllInjectionPoints());
        }
        ArrayList<DisposerInfo> disposers = new ArrayList<DisposerInfo>();
        for (MethodInfo disposerMethod : disposerMethods) {
            declaringBean = (BeanInfo)beanClassToBean.get(disposerMethod.declaringClass());
            if (declaringBean == null) continue;
            injection = Injection.forDisposer(disposerMethod, this);
            disposers.add(new DisposerInfo(declaringBean, disposerMethod, injection));
            injectionPoints.addAll(injection.injectionPoints);
        }
        for (MethodInfo producerMethod : producerMethods) {
            declaringBean = (BeanInfo)beanClassToBean.get(producerMethod.declaringClass());
            if (declaringBean == null) continue;
            BeanInfo producerMethodBean = Beans.createProducerMethod(producerMethod, declaringBean, this, this.findDisposer(declaringBean, (AnnotationTarget)producerMethod, disposers));
            beans.add(producerMethodBean);
            injectionPoints.addAll(producerMethodBean.getAllInjectionPoints());
        }
        for (FieldInfo producerField : producerFields) {
            declaringBean = (BeanInfo)beanClassToBean.get(producerField.declaringClass());
            if (declaringBean == null) continue;
            beans.add(Beans.createProducerField(producerField, declaringBean, this, this.findDisposer(declaringBean, (AnnotationTarget)producerField, disposers)));
        }
        for (MethodInfo observerMethod : syncObserverMethods) {
            declaringBean = (BeanInfo)beanClassToBean.get(observerMethod.declaringClass());
            if (declaringBean == null) continue;
            injection = Injection.forObserver(observerMethod, this);
            observers.add(new ObserverInfo(declaringBean, observerMethod, injection, false));
            injectionPoints.addAll(injection.injectionPoints);
        }
        for (MethodInfo observerMethod : asyncObserverMethods) {
            declaringBean = (BeanInfo)beanClassToBean.get(observerMethod.declaringClass());
            if (declaringBean == null) continue;
            injection = Injection.forObserver(observerMethod, this);
            observers.add(new ObserverInfo(declaringBean, observerMethod, injection, true));
            injectionPoints.addAll(injection.injectionPoints);
        }
        if (LOGGER.isTraceEnabled()) {
            for (BeanInfo bean : beans) {
                LOGGER.logf(Logger.Level.TRACE, "Created %s", (Object)bean);
            }
        }
        return beans;
    }

    private DisposerInfo findDisposer(BeanInfo declaringBean, AnnotationTarget annotationTarget, List<DisposerInfo> disposers) {
        Set qualifiers;
        Type beanType;
        ArrayList<DisposerInfo> found = new ArrayList<DisposerInfo>();
        if (AnnotationTarget.Kind.FIELD.equals((Object)annotationTarget.kind())) {
            beanType = annotationTarget.asField().type();
            qualifiers = annotationTarget.asField().annotations().stream().filter(a -> this.getQualifier(a.name()) != null).collect(Collectors.toSet());
        } else if (AnnotationTarget.Kind.METHOD.equals((Object)annotationTarget.kind())) {
            beanType = annotationTarget.asMethod().returnType();
            qualifiers = annotationTarget.asMethod().annotations().stream().filter(a -> AnnotationTarget.Kind.METHOD.equals((Object)a.target().kind()) && this.getQualifier(a.name()) != null).collect(Collectors.toSet());
        } else {
            throw new RuntimeException("Unsupported annotation target: " + annotationTarget);
        }
        for (DisposerInfo disposer : disposers) {
            if (!disposer.getDeclaringBean().equals(declaringBean)) continue;
            boolean hasQualifier = true;
            for (AnnotationInstance qualifier : qualifiers) {
                if (Beans.hasQualifier(this.getQualifier(qualifier.name()), qualifier, disposer.getDisposedParameterQualifiers())) continue;
                hasQualifier = false;
            }
            if (!hasQualifier || !this.beanResolver.matches(beanType, disposer.getDisposedParameterType())) continue;
            found.add(disposer);
        }
        if (found.size() > 1) {
            throw new DefinitionException("Multiple disposer methods found for " + annotationTarget);
        }
        return found.isEmpty() ? null : (DisposerInfo)found.get(0);
    }

    private List<InterceptorInfo> findInterceptors(List<InjectionPointInfo> injectionPoints) {
        HashSet<ClassInfo> interceptorClasses = new HashSet<ClassInfo>();
        for (AnnotationInstance annotation : this.index.getAnnotations(DotNames.INTERCEPTOR)) {
            if (!AnnotationTarget.Kind.CLASS.equals((Object)annotation.target().kind())) continue;
            interceptorClasses.add(annotation.target().asClass());
        }
        ArrayList<InterceptorInfo> interceptors = new ArrayList<InterceptorInfo>();
        for (ClassInfo interceptorClass : interceptorClasses) {
            interceptors.add(Interceptors.createInterceptor(interceptorClass, this));
        }
        if (LOGGER.isTraceEnabled()) {
            for (InterceptorInfo interceptor : interceptors) {
                LOGGER.logf(Logger.Level.TRACE, "Created %s", (Object)interceptor);
            }
        }
        for (InterceptorInfo i : interceptors) {
            injectionPoints.addAll(i.getAllInjectionPoints());
        }
        return interceptors;
    }

    private void processErrors(List<Throwable> errors) {
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                Throwable error = errors.get(0);
                if (error instanceof DeploymentException) {
                    throw (DeploymentException)error;
                }
                throw new DeploymentException(errors.get(0));
            }
            StringBuilder message = new StringBuilder("Found " + errors.size() + " deployment problems: ");
            int idx = 1;
            for (Throwable error : errors) {
                message.append("\n").append("[").append(idx++).append("] ").append(error.getMessage());
            }
            DeploymentException deploymentException = new DeploymentException(message.toString());
            for (Throwable error : errors) {
                deploymentException.addSuppressed(error);
            }
            throw deploymentException;
        }
    }

    public static Set<DotName> initBeanDefiningAnnotations(Collection<BeanDefiningAnnotation> additionalBeanDefiningAnnotations, Set<DotName> stereotypes) {
        HashSet<DotName> beanDefiningAnnotations = new HashSet<DotName>();
        for (BuiltinScope scope : BuiltinScope.values()) {
            beanDefiningAnnotations.add(scope.getInfo().getDotName());
        }
        if (additionalBeanDefiningAnnotations != null) {
            for (BeanDefiningAnnotation additional : additionalBeanDefiningAnnotations) {
                beanDefiningAnnotations.add(additional.getAnnotation());
            }
        }
        beanDefiningAnnotations.addAll(stereotypes);
        beanDefiningAnnotations.add(DotNames.create(Model.class));
        return beanDefiningAnnotations;
    }

    static class ValidationContextImpl
    implements BeanDeploymentValidator.ValidationContext {
        private final BuildExtension.BuildContext buildContext;
        private final List<Throwable> errors;

        public ValidationContextImpl(BuildExtension.BuildContext buildContext) {
            this.buildContext = buildContext;
            this.errors = new ArrayList<Throwable>();
        }

        @Override
        public <V> V get(BuildExtension.Key<V> key) {
            return this.buildContext.get(key);
        }

        @Override
        public <V> V put(BuildExtension.Key<V> key, V value) {
            return this.buildContext.put(key, value);
        }

        @Override
        public void addDeploymentProblem(Throwable problem) {
            this.errors.add(problem);
        }

        List<Throwable> getErrors() {
            return this.errors;
        }
    }
}

