/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanResolver;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.DisposerInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.arc.processor.StereotypeInfo;
import io.quarkus.arc.processor.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.DefinitionException;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

final class Beans {
    private Beans() {
    }

    static BeanInfo createClassBean(ClassInfo beanClass, BeanDeployment beanDeployment) {
        HashSet<AnnotationInstance> qualifiers = new HashSet<AnnotationInstance>();
        ArrayList<ScopeInfo> scopes = new ArrayList<ScopeInfo>();
        Set<Type> types = Types.getClassBeanTypeClosure(beanClass, Collections.emptyMap(), beanDeployment);
        Integer alternativePriority = null;
        boolean isAlternative = false;
        ArrayList<StereotypeInfo> stereotypes = new ArrayList<StereotypeInfo>();
        String name = null;
        for (AnnotationInstance annotation : beanDeployment.getAnnotations((AnnotationTarget)beanClass)) {
            if (beanDeployment.getQualifier(annotation.name()) != null) {
                qualifiers.add(annotation);
                if (!DotNames.NAMED.equals((Object)annotation.name())) continue;
                AnnotationValue nameValue = annotation.value();
                if (nameValue != null) {
                    name = nameValue.asString();
                    continue;
                }
                name = Beans.getDefaultName(beanClass);
                continue;
            }
            if (annotation.name().equals((Object)DotNames.ALTERNATIVE)) {
                isAlternative = true;
                continue;
            }
            if (annotation.name().equals((Object)DotNames.PRIORITY)) {
                alternativePriority = annotation.value().asInt();
                continue;
            }
            ScopeInfo scopeAnnotation = beanDeployment.getScope(annotation.name());
            if (scopeAnnotation != null) {
                scopes.add(scopeAnnotation);
                continue;
            }
            StereotypeInfo stereotype = beanDeployment.getStereotype(annotation.name());
            if (stereotype == null) continue;
            stereotypes.add(stereotype);
        }
        if (scopes.size() > 1) {
            throw Beans.multipleScopesFound("Bean class " + beanClass, scopes);
        }
        ScopeInfo scope = scopes.isEmpty() ? Beans.initStereotypeScope(stereotypes, (AnnotationTarget)beanClass) : (ScopeInfo)scopes.get(0);
        if (!isAlternative) {
            isAlternative = Beans.initStereotypeAlternative(stereotypes);
        }
        if (name == null) {
            name = Beans.initStereotypeName(stereotypes, (AnnotationTarget)beanClass);
        }
        BeanInfo bean = new BeanInfo((AnnotationTarget)beanClass, beanDeployment, scope, types, qualifiers, Injection.forBean((AnnotationTarget)beanClass, beanDeployment), null, null, isAlternative ? alternativePriority : null, stereotypes, name);
        return bean;
    }

    static BeanInfo createProducerMethod(MethodInfo producerMethod, BeanInfo declaringBean, BeanDeployment beanDeployment, DisposerInfo disposer) {
        HashSet<AnnotationInstance> qualifiers = new HashSet<AnnotationInstance>();
        ArrayList<ScopeInfo> scopes = new ArrayList<ScopeInfo>();
        Set<Type> types = Types.getProducerMethodTypeClosure(producerMethod, beanDeployment);
        Integer alternativePriority = null;
        boolean isAlternative = false;
        ArrayList<StereotypeInfo> stereotypes = new ArrayList<StereotypeInfo>();
        String name = null;
        for (AnnotationInstance annotation : beanDeployment.getAnnotations((AnnotationTarget)producerMethod)) {
            if (annotation.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            if (beanDeployment.getQualifier(annotation.name()) != null) {
                qualifiers.add(annotation);
                if (!DotNames.NAMED.equals((Object)annotation.name())) continue;
                AnnotationValue nameValue = annotation.value();
                if (nameValue != null) {
                    name = nameValue.asString();
                    continue;
                }
                name = Beans.getDefaultName(producerMethod);
                continue;
            }
            if (DotNames.ALTERNATIVE.equals((Object)annotation.name())) {
                isAlternative = true;
                continue;
            }
            ScopeInfo scopeAnnotation = beanDeployment.getScope(annotation.name());
            if (scopeAnnotation != null) {
                scopes.add(scopeAnnotation);
                continue;
            }
            StereotypeInfo stereotype = beanDeployment.getStereotype(annotation.name());
            if (stereotype == null) continue;
            stereotypes.add(stereotype);
        }
        if (scopes.size() > 1) {
            throw Beans.multipleScopesFound("Producer method " + producerMethod, scopes);
        }
        ScopeInfo scope = scopes.isEmpty() ? Beans.initStereotypeScope(stereotypes, (AnnotationTarget)producerMethod) : (ScopeInfo)scopes.get(0);
        if (!isAlternative) {
            isAlternative = Beans.initStereotypeAlternative(stereotypes);
        }
        if (name == null) {
            name = Beans.initStereotypeName(stereotypes, (AnnotationTarget)producerMethod);
        }
        if (isAlternative && (alternativePriority = declaringBean.getAlternativePriority()) == null) {
            alternativePriority = declaringBean.getTarget().get().asClass().classAnnotations().stream().filter(a -> a.name().equals((Object)DotNames.PRIORITY)).findAny().map(a -> a.value().asInt()).orElse(null);
        }
        BeanInfo bean = new BeanInfo((AnnotationTarget)producerMethod, beanDeployment, scope, types, qualifiers, Injection.forBean((AnnotationTarget)producerMethod, beanDeployment), declaringBean, disposer, alternativePriority, stereotypes, name);
        return bean;
    }

    static BeanInfo createProducerField(FieldInfo producerField, BeanInfo declaringBean, BeanDeployment beanDeployment, DisposerInfo disposer) {
        HashSet<AnnotationInstance> qualifiers = new HashSet<AnnotationInstance>();
        ArrayList<ScopeInfo> scopes = new ArrayList<ScopeInfo>();
        Set<Type> types = Types.getProducerFieldTypeClosure(producerField, beanDeployment);
        Integer alternativePriority = null;
        boolean isAlternative = false;
        ArrayList<StereotypeInfo> stereotypes = new ArrayList<StereotypeInfo>();
        String name = null;
        for (AnnotationInstance annotation : beanDeployment.getAnnotations((AnnotationTarget)producerField)) {
            if (beanDeployment.getQualifier(annotation.name()) != null) {
                qualifiers.add(annotation);
                if (!DotNames.NAMED.equals((Object)annotation.name())) continue;
                AnnotationValue nameValue = annotation.value();
                if (nameValue != null) {
                    name = nameValue.asString();
                    continue;
                }
                name = producerField.name();
                continue;
            }
            ScopeInfo scopeAnnotation = beanDeployment.getScope(annotation.name());
            if (scopeAnnotation != null) {
                scopes.add(scopeAnnotation);
                continue;
            }
            StereotypeInfo stereotype = beanDeployment.getStereotype(annotation.name());
            if (stereotype == null) continue;
            stereotypes.add(stereotype);
        }
        if (scopes.size() > 1) {
            throw Beans.multipleScopesFound("Producer field " + producerField, scopes);
        }
        ScopeInfo scope = scopes.isEmpty() ? Beans.initStereotypeScope(stereotypes, (AnnotationTarget)producerField) : (ScopeInfo)scopes.get(0);
        if (!isAlternative) {
            isAlternative = Beans.initStereotypeAlternative(stereotypes);
        }
        if (name == null) {
            name = Beans.initStereotypeName(stereotypes, (AnnotationTarget)producerField);
        }
        if (isAlternative && (alternativePriority = declaringBean.getAlternativePriority()) == null) {
            alternativePriority = declaringBean.getTarget().get().asClass().classAnnotations().stream().filter(a -> a.name().equals((Object)DotNames.PRIORITY)).findAny().map(a -> a.value().asInt()).orElse(null);
        }
        BeanInfo bean = new BeanInfo((AnnotationTarget)producerField, beanDeployment, scope, types, qualifiers, Collections.emptyList(), declaringBean, disposer, alternativePriority, stereotypes, name);
        return bean;
    }

    private static DefinitionException multipleScopesFound(String baseMessage, List<ScopeInfo> scopes) {
        return new DefinitionException(baseMessage + " declares multiple scope type annotations: " + scopes.stream().map(s -> s.getDotName().toString()).collect(Collectors.joining(", ")));
    }

    private static ScopeInfo initStereotypeScope(List<StereotypeInfo> stereotypes, AnnotationTarget target) {
        if (stereotypes.isEmpty()) {
            return null;
        }
        HashSet<ScopeInfo> stereotypeScopes = new HashSet<ScopeInfo>();
        for (StereotypeInfo stereotype : stereotypes) {
            stereotypeScopes.add(stereotype.getDefaultScope());
        }
        return BeanDeployment.getValidScope(stereotypeScopes, target);
    }

    private static boolean initStereotypeAlternative(List<StereotypeInfo> stereotypes) {
        if (stereotypes.isEmpty()) {
            return false;
        }
        for (StereotypeInfo stereotype : stereotypes) {
            if (!stereotype.isAlternative()) continue;
            return true;
        }
        return false;
    }

    private static String initStereotypeName(List<StereotypeInfo> stereotypes, AnnotationTarget target) {
        if (stereotypes.isEmpty()) {
            return null;
        }
        for (StereotypeInfo stereotype : stereotypes) {
            if (!stereotype.isNamed()) continue;
            switch (target.kind()) {
                case CLASS: {
                    return Beans.getDefaultName(target.asClass());
                }
                case FIELD: {
                    return target.asField().name();
                }
                case METHOD: {
                    return Beans.getDefaultName(target.asMethod());
                }
            }
        }
        return null;
    }

    static boolean matches(BeanInfo bean, InjectionPointInfo.TypeAndQualifiers typeAndQualifiers) {
        for (AnnotationInstance requiredQualifier : typeAndQualifiers.qualifiers) {
            if (Beans.hasQualifier(bean, requiredQualifier)) continue;
            return false;
        }
        return Beans.matchesType(bean, typeAndQualifiers.type);
    }

    static boolean matchesType(BeanInfo bean, Type requiredType) {
        BeanResolver beanResolver = bean.getDeployment().getBeanResolver();
        for (Type beanType : bean.getTypes()) {
            if (!beanResolver.matches(requiredType, beanType)) continue;
            return true;
        }
        return false;
    }

    static void resolveInjectionPoint(BeanDeployment deployment, BeanInfo bean, InjectionPointInfo injectionPoint, List<Throwable> errors) {
        if (BuiltinBean.resolvesTo(injectionPoint)) {
            return;
        }
        List<BeanInfo> resolved = deployment.getBeanResolver().resolve(injectionPoint.getTypeAndQualifiers());
        BeanInfo selected = null;
        if (resolved.isEmpty()) {
            StringBuilder message = new StringBuilder("Unsatisfied dependency for type ");
            message.append(injectionPoint.getRequiredType());
            message.append(" and qualifiers ");
            message.append(injectionPoint.getRequiredQualifiers());
            message.append("\n\t- java member: ");
            message.append(injectionPoint.getTargetInfo());
            message.append("\n\t- declared on ");
            message.append(bean);
            errors.add((Throwable)new UnsatisfiedResolutionException(message.toString()));
        } else if (resolved.size() > 1) {
            selected = Beans.resolveAmbiguity(resolved);
            if (selected == null) {
                StringBuilder message = new StringBuilder("Ambiguous dependencies for type ");
                message.append(injectionPoint.getRequiredType());
                message.append(" and qualifiers ");
                message.append(injectionPoint.getRequiredQualifiers());
                message.append("\n\t- java member: ");
                message.append(injectionPoint.getTargetInfo());
                message.append("\n\t- declared on ");
                message.append(bean);
                message.append("\n\t- available beans:\n\t\t- ");
                message.append(resolved.stream().map(Object::toString).collect(Collectors.joining("\n\t\t- ")));
                errors.add((Throwable)new AmbiguousResolutionException(message.toString()));
            }
        } else {
            selected = resolved.get(0);
        }
        if (selected != null) {
            injectionPoint.resolve(selected);
        }
    }

    static BeanInfo resolveAmbiguity(List<BeanInfo> resolved) {
        BeanInfo selected = null;
        ArrayList<BeanInfo> resolvedAmbiguity = new ArrayList<BeanInfo>(resolved);
        Iterator iterator = resolvedAmbiguity.iterator();
        while (iterator.hasNext()) {
            BeanInfo beanInfo = (BeanInfo)iterator.next();
            if (beanInfo.isAlternative() || beanInfo.getDeclaringBean() != null && beanInfo.getDeclaringBean().isAlternative()) continue;
            iterator.remove();
        }
        if (resolvedAmbiguity.size() == 1) {
            selected = (BeanInfo)resolvedAmbiguity.get(0);
        } else if (resolvedAmbiguity.size() > 1) {
            resolvedAmbiguity.sort(Beans::compareAlternativeBeans);
            Integer highest = Beans.getAlternativePriority((BeanInfo)resolvedAmbiguity.get(0));
            Iterator iterator2 = resolvedAmbiguity.iterator();
            while (iterator2.hasNext()) {
                if (highest.equals(Beans.getAlternativePriority((BeanInfo)iterator2.next()))) continue;
                iterator2.remove();
            }
            if (resolved.size() == 1) {
                selected = (BeanInfo)resolvedAmbiguity.get(0);
            }
        }
        return selected;
    }

    private static Integer getAlternativePriority(BeanInfo bean) {
        return bean.getDeclaringBean() != null ? bean.getDeclaringBean().getAlternativePriority() : bean.getAlternativePriority();
    }

    private static int compareAlternativeBeans(BeanInfo bean1, BeanInfo bean2) {
        Integer priority2 = bean2.getDeclaringBean() != null ? bean2.getDeclaringBean().getAlternativePriority() : bean2.getAlternativePriority();
        Integer priority1 = bean1.getDeclaringBean() != null ? bean1.getDeclaringBean().getAlternativePriority() : bean1.getAlternativePriority();
        return priority2.compareTo(priority1);
    }

    static boolean hasQualifier(BeanInfo bean, AnnotationInstance required) {
        return Beans.hasQualifier(bean.getDeployment().getQualifier(required.name()), required, bean.getQualifiers());
    }

    static boolean hasQualifier(ClassInfo requiredInfo, AnnotationInstance required, Collection<AnnotationInstance> qualifiers) {
        ArrayList<AnnotationValue> binding = new ArrayList<AnnotationValue>();
        for (AnnotationValue val : required.values()) {
            if (requiredInfo.method(val.name(), new Type[0]).hasAnnotation(DotNames.NONBINDING)) continue;
            binding.add(val);
        }
        for (AnnotationInstance qualifier : qualifiers) {
            if (!required.name().equals((Object)qualifier.name())) continue;
            boolean matches = true;
            for (AnnotationValue value : binding) {
                if (value.equals((Object)qualifier.value(value.name()))) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return true;
        }
        return false;
    }

    static List<MethodInfo> getCallbacks(ClassInfo beanClass, DotName annotation, IndexView index) {
        ArrayList<MethodInfo> callbacks = new ArrayList<MethodInfo>();
        Beans.collectCallbacks(beanClass, callbacks, annotation, index);
        Collections.reverse(callbacks);
        return callbacks;
    }

    static void analyzeType(Type type, BeanDeployment beanDeployment) {
        if (type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            for (Type argument : type.asParameterizedType().arguments()) {
                Beans.fetchType(argument, beanDeployment);
            }
        } else if (type.kind() == Type.Kind.TYPE_VARIABLE) {
            for (Type bound : type.asTypeVariable().bounds()) {
                Beans.fetchType(bound, beanDeployment);
            }
        } else if (type.kind() == Type.Kind.WILDCARD_TYPE) {
            Beans.fetchType(type.asWildcardType().extendsBound(), beanDeployment);
            Beans.fetchType(type.asWildcardType().superBound(), beanDeployment);
        }
    }

    private static void fetchType(Type type, BeanDeployment beanDeployment) {
        if (type == null) {
            return;
        }
        if (type.kind() == Type.Kind.CLASS) {
            beanDeployment.getIndex().getClassByName(type.name());
        } else {
            Beans.analyzeType(type, beanDeployment);
        }
    }

    private static void collectCallbacks(ClassInfo clazz, List<MethodInfo> callbacks, DotName annotation, IndexView index) {
        ClassInfo superClass;
        for (MethodInfo method : clazz.methods()) {
            if (!method.hasAnnotation(annotation) || method.returnType().kind() != Type.Kind.VOID || !method.parameters().isEmpty()) continue;
            callbacks.add(method);
        }
        if (clazz.superName() != null && (superClass = index.getClassByName(clazz.superName())) != null) {
            Beans.collectCallbacks(superClass, callbacks, annotation, index);
        }
    }

    private static String getPropertyName(String methodName) {
        String get = "get";
        String is = "is";
        if (methodName.startsWith("get")) {
            return Beans.decapitalize(methodName.substring("get".length()));
        }
        if (methodName.startsWith("is")) {
            return Beans.decapitalize(methodName.substring("is".length()));
        }
        return null;
    }

    private static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        StringBuilder decapitalized = new StringBuilder(name);
        decapitalized.setCharAt(0, Character.toLowerCase(decapitalized.charAt(0)));
        return decapitalized.toString();
    }

    private static String getDefaultName(ClassInfo beanClass) {
        StringBuilder defaultName = new StringBuilder();
        defaultName.append(DotNames.simpleName(beanClass));
        defaultName.setCharAt(0, Character.toLowerCase(defaultName.charAt(0)));
        return defaultName.toString();
    }

    private static String getDefaultName(MethodInfo producerMethod) {
        String propertyName = Beans.getPropertyName(producerMethod.name());
        if (propertyName != null) {
            return propertyName;
        }
        return producerMethod.name();
    }
}

