/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.ObserverInfo;
import java.util.List;
import org.jboss.jandex.IndexView;

public interface BuildExtension {
    public static final int DEFAULT_PRIORITY = 1000;

    public static int compare(BuildExtension e1, BuildExtension e2) {
        return Integer.compare(e2.getPriority(), e1.getPriority());
    }

    default public int getPriority() {
        return 1000;
    }

    default public boolean initialize(BuildContext buildContext) {
        return true;
    }

    public static class SimpleKey<V>
    implements Key<V> {
        private final String str;

        public SimpleKey(String str) {
            this.str = str;
        }

        @Override
        public String asString() {
            return this.str;
        }
    }

    public static interface Key<T> {
        public static final String BUILT_IN_PREFIX = BuildExtension.class.getPackage().getName() + ".";
        public static final Key<IndexView> INDEX = new SimpleKey<IndexView>(BUILT_IN_PREFIX + "index");
        public static final Key<List<InjectionPointInfo>> INJECTION_POINTS = new SimpleKey<List<InjectionPointInfo>>(BUILT_IN_PREFIX + "injectionPoints");
        public static final Key<List<BeanInfo>> BEANS = new SimpleKey<List<BeanInfo>>(BUILT_IN_PREFIX + "beans");
        public static final Key<List<ObserverInfo>> OBSERVERS = new SimpleKey<List<ObserverInfo>>(BUILT_IN_PREFIX + "observers");
        public static final Key<AnnotationStore> ANNOTATION_STORE = new SimpleKey<AnnotationStore>(BUILT_IN_PREFIX + "annotationStore");

        public String asString();
    }

    public static interface BuildContext {
        public <V> V get(Key<V> var1);

        public <V> V put(Key<V> var1, V var2);
    }
}

