/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.BeanManagerProvider;
import io.quarkus.arc.BeanMetadataProvider;
import io.quarkus.arc.EventProvider;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableReferenceProvider;
import io.quarkus.arc.InjectionPointProvider;
import io.quarkus.arc.InstanceProvider;
import io.quarkus.arc.ResourceProvider;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanGenerator;
import io.quarkus.arc.processor.BuiltinQualifier;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.Types;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

enum BuiltinBean {
    INSTANCE(DotNames.INSTANCE, new Generator(){

        @Override
        void generate(ClassOutput classOutput, BeanDeployment beanDeployment, InjectionPointInfo injectionPoint, ClassCreator clazzCreator, MethodCreator constructor, String providerName, AnnotationLiteralProcessor annotationLiterals) {
            ResultHandle qualifiers = BeanGenerator.collectQualifiers(classOutput, clazzCreator, beanDeployment, constructor, injectionPoint, annotationLiterals);
            ResultHandle parameterizedType = Types.getTypeHandle((BytecodeCreator)constructor, injectionPoint.getRequiredType());
            ResultHandle annotationsHandle = BeanGenerator.collectAnnotations(classOutput, clazzCreator, beanDeployment, constructor, injectionPoint, annotationLiterals);
            ResultHandle javaMemberHandle = BeanGenerator.getJavaMemberHandle(constructor, injectionPoint);
            ResultHandle instanceProvider = constructor.newInstance(MethodDescriptor.ofConstructor(InstanceProvider.class, (Class[])new Class[]{Type.class, Set.class, InjectableBean.class, Set.class, Member.class, Integer.TYPE}), new ResultHandle[]{parameterizedType, qualifiers, constructor.getThis(), annotationsHandle, javaMemberHandle, constructor.load(injectionPoint.getPosition())});
            constructor.writeInstanceField(FieldDescriptor.of((String)clazzCreator.getClassName(), (String)providerName, (String)InjectableReferenceProvider.class.getName()), constructor.getThis(), instanceProvider);
        }
    }, BuiltinBean::isInstanceInjectionPoint),
    INJECTION_POINT(DotNames.INJECTION_POINT, new Generator(){

        @Override
        void generate(ClassOutput classOutput, BeanDeployment beanDeployment, InjectionPointInfo injectionPoint, ClassCreator clazzCreator, MethodCreator constructor, String providerName, AnnotationLiteralProcessor annotationLiterals) {
            constructor.writeInstanceField(FieldDescriptor.of((String)clazzCreator.getClassName(), (String)providerName, (String)InjectableReferenceProvider.class.getName()), constructor.getThis(), constructor.newInstance(MethodDescriptor.ofConstructor(InjectionPointProvider.class, (Class[])new Class[0]), new ResultHandle[0]));
        }
    }),
    BEAN(DotNames.BEAN, new Generator(){

        @Override
        void generate(ClassOutput classOutput, BeanDeployment beanDeployment, InjectionPointInfo injectionPoint, ClassCreator clazzCreator, MethodCreator constructor, String providerName, AnnotationLiteralProcessor annotationLiterals) {
            constructor.writeInstanceField(FieldDescriptor.of((String)clazzCreator.getClassName(), (String)providerName, (String)InjectableReferenceProvider.class.getName()), constructor.getThis(), constructor.newInstance(MethodDescriptor.ofConstructor(BeanMetadataProvider.class, (Class[])new Class[0]), new ResultHandle[0]));
        }
    }),
    BEAN_MANAGER(DotNames.BEAN_MANAGER, new Generator(){

        @Override
        void generate(ClassOutput classOutput, BeanDeployment beanDeployment, InjectionPointInfo injectionPoint, ClassCreator clazzCreator, MethodCreator constructor, String providerName, AnnotationLiteralProcessor annotationLiterals) {
            constructor.writeInstanceField(FieldDescriptor.of((String)clazzCreator.getClassName(), (String)providerName, (String)InjectableReferenceProvider.class.getName()), constructor.getThis(), constructor.newInstance(MethodDescriptor.ofConstructor(BeanManagerProvider.class, (Class[])new Class[0]), new ResultHandle[0]));
        }
    }),
    EVENT(DotNames.EVENT, new Generator(){

        @Override
        void generate(ClassOutput classOutput, BeanDeployment beanDeployment, InjectionPointInfo injectionPoint, ClassCreator clazzCreator, MethodCreator constructor, String providerName, AnnotationLiteralProcessor annotationLiterals) {
            ResultHandle qualifiers = constructor.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
            if (!injectionPoint.getRequiredQualifiers().isEmpty()) {
                for (AnnotationInstance qualifierAnnotation : injectionPoint.getRequiredQualifiers()) {
                    BuiltinQualifier qualifier = BuiltinQualifier.of(qualifierAnnotation);
                    if (qualifier != null) {
                        constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, qualifiers, new ResultHandle[]{qualifier.getLiteralInstance((BytecodeCreator)constructor)});
                        continue;
                    }
                    ClassInfo qualifierClass = beanDeployment.getQualifier(qualifierAnnotation.name());
                    constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, qualifiers, new ResultHandle[]{annotationLiterals.process((BytecodeCreator)constructor, classOutput, qualifierClass, qualifierAnnotation, Types.getPackageName(clazzCreator.getClassName()))});
                }
            }
            ResultHandle parameterizedType = Types.getTypeHandle((BytecodeCreator)constructor, injectionPoint.getRequiredType());
            ResultHandle eventProvider = constructor.newInstance(MethodDescriptor.ofConstructor(EventProvider.class, (Class[])new Class[]{Type.class, Set.class}), new ResultHandle[]{parameterizedType, qualifiers});
            constructor.writeInstanceField(FieldDescriptor.of((String)clazzCreator.getClassName(), (String)providerName, (String)InjectableReferenceProvider.class.getName()), constructor.getThis(), eventProvider);
        }
    }),
    RESOURCE(DotNames.OBJECT, new Generator(){

        @Override
        void generate(ClassOutput classOutput, BeanDeployment beanDeployment, InjectionPointInfo injectionPoint, ClassCreator clazzCreator, MethodCreator constructor, String providerName, AnnotationLiteralProcessor annotationLiterals) {
            ResultHandle annotations = constructor.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
            if (!injectionPoint.getRequiredQualifiers().isEmpty()) {
                for (AnnotationInstance annotation : injectionPoint.getRequiredQualifiers()) {
                    ClassInfo annotationClass = beanDeployment.getIndex().getClassByName(annotation.name());
                    constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, annotations, new ResultHandle[]{annotationLiterals.process((BytecodeCreator)constructor, classOutput, annotationClass, annotation, Types.getPackageName(clazzCreator.getClassName()))});
                }
            }
            ResultHandle parameterizedType = Types.getTypeHandle((BytecodeCreator)constructor, injectionPoint.getRequiredType());
            ResultHandle resourceProvider = constructor.newInstance(MethodDescriptor.ofConstructor(ResourceProvider.class, (Class[])new Class[]{Type.class, Set.class}), new ResultHandle[]{parameterizedType, annotations});
            constructor.writeInstanceField(FieldDescriptor.of((String)clazzCreator.getClassName(), (String)providerName, (String)InjectableReferenceProvider.class.getName()), constructor.getThis(), resourceProvider);
        }
    }, ip -> ip.getKind() == InjectionPointInfo.InjectionPointKind.RESOURCE);

    private final DotName rawTypeDotName;
    private final Generator generator;
    private final Predicate<InjectionPointInfo> matcher;

    private BuiltinBean(DotName rawTypeDotName, Generator generator) {
        this(rawTypeDotName, generator, ip -> BuiltinBean.isCdiAndRawTypeMatches(ip, rawTypeDotName));
    }

    private BuiltinBean(DotName rawTypeDotName, Generator generator, Predicate<InjectionPointInfo> matcher) {
        this.rawTypeDotName = rawTypeDotName;
        this.generator = generator;
        this.matcher = matcher;
    }

    boolean matches(InjectionPointInfo injectionPoint) {
        return this.matcher.test(injectionPoint);
    }

    DotName getRawTypeDotName() {
        return this.rawTypeDotName;
    }

    Generator getGenerator() {
        return this.generator;
    }

    static boolean resolvesTo(InjectionPointInfo injectionPoint) {
        return BuiltinBean.resolve(injectionPoint) != null;
    }

    static BuiltinBean resolve(InjectionPointInfo injectionPoint) {
        for (BuiltinBean bean : BuiltinBean.values()) {
            if (!bean.matches(injectionPoint)) continue;
            return bean;
        }
        return null;
    }

    private static boolean isCdiAndRawTypeMatches(InjectionPointInfo injectionPoint, DotName rawTypeDotName) {
        if (injectionPoint.getKind() != InjectionPointInfo.InjectionPointKind.CDI) {
            return false;
        }
        return rawTypeDotName.equals((Object)injectionPoint.getRequiredType().name());
    }

    private static boolean isInstanceInjectionPoint(InjectionPointInfo injectionPoint) {
        if (injectionPoint.getKind() != InjectionPointInfo.InjectionPointKind.CDI) {
            return false;
        }
        return DotNames.INSTANCE.equals((Object)injectionPoint.getRequiredType().name()) || DotNames.PROVIDER.equals((Object)injectionPoint.getRequiredType().name());
    }

    static abstract class Generator {
        Generator() {
        }

        abstract void generate(ClassOutput var1, BeanDeployment var2, InjectionPointInfo var3, ClassCreator var4, MethodCreator var5, String var6, AnnotationLiteralProcessor var7);
    }
}

