/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.ClientProxy;
import io.quarkus.arc.CreationalContextImpl;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.Methods;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.Types;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.enterprise.context.ContextNotActiveException;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;

public class ClientProxyGenerator
extends AbstractGenerator {
    static final String CLIENT_PROXY_SUFFIX = "_ClientProxy";
    private final Predicate<DotName> applicationClassPredicate;

    public ClientProxyGenerator(Predicate<DotName> applicationClassPredicate) {
        this.applicationClassPredicate = applicationClassPredicate;
    }

    Collection<ResourceOutput.Resource> generate(BeanInfo bean, String beanClassName, ReflectionRegistration reflectionRegistration) {
        ResourceClassOutput classOutput = new ResourceClassOutput(this.applicationClassPredicate.test(bean.getBeanClass()));
        Type providerType = bean.getProviderType();
        ClassInfo providerClass = bean.getDeployment().getIndex().getClassByName(providerType.name());
        String providerTypeName = providerClass.name().toString();
        String baseName = this.getBaseName(bean, beanClassName);
        String targetPackage = this.getPackageName(bean);
        String generatedName = ClientProxyGenerator.generatedNameFromTarget(targetPackage, baseName, CLIENT_PROXY_SUFFIX);
        ArrayList<String> interfaces = new ArrayList<String>();
        String superClass = Object.class.getName();
        interfaces.add(ClientProxy.class.getName());
        boolean isInterface = false;
        if (Modifier.isInterface(providerClass.flags())) {
            isInterface = true;
            interfaces.add(providerTypeName);
        } else {
            superClass = providerTypeName;
        }
        ClassCreator clientProxy = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).superClass(superClass).interfaces(interfaces.toArray(new String[0])).build();
        FieldCreator beanField = (FieldCreator)clientProxy.getFieldCreator("bean", DescriptorUtils.extToInt((String)beanClassName)).setModifiers(18);
        this.createConstructor(clientProxy, beanClassName, superClass, beanField.getFieldDescriptor());
        this.implementDelegate(clientProxy, providerTypeName, beanField.getFieldDescriptor());
        this.implementGetContextualInstance(clientProxy, providerTypeName);
        for (MethodInfo method : this.getDelegatingMethods(bean)) {
            ResultHandle ret;
            MethodDescriptor originalMethodDescriptor = MethodDescriptor.of((MethodInfo)method);
            MethodCreator forward = clientProxy.getMethodCreator(originalMethodDescriptor);
            for (Type exception : method.exceptions()) {
                forward.addException(exception.asClassType().toString());
            }
            ResultHandle[] params = new ResultHandle[method.parameters().size()];
            for (int i = 0; i < method.parameters().size(); ++i) {
                params[i] = forward.getMethodParam(i);
            }
            ResultHandle delegate = forward.invokeVirtualMethod(MethodDescriptor.ofMethod((String)generatedName, (String)"delegate", (String)DescriptorUtils.typeToString((Type)providerType), (String[])new String[0]), forward.getThis(), new ResultHandle[0]);
            if (isInterface) {
                ret = forward.invokeInterfaceMethod(method, delegate, params);
            } else if (this.isReflectionFallbackNeeded(method, targetPackage)) {
                ResultHandle paramTypesArray = forward.newArray(Class.class, forward.load(method.parameters().size()));
                int idx = 0;
                for (Type param : method.parameters()) {
                    forward.writeArrayValue(paramTypesArray, idx++, forward.loadClass(param.name().toString()));
                }
                ResultHandle argsArray = forward.newArray(Object.class, forward.load(params.length));
                idx = 0;
                for (ResultHandle argHandle : params) {
                    forward.writeArrayValue(argsArray, idx++, argHandle);
                }
                reflectionRegistration.registerMethod(method);
                ret = forward.invokeStaticMethod(MethodDescriptors.REFLECTIONS_INVOKE_METHOD, new ResultHandle[]{forward.loadClass(method.declaringClass().name().toString()), forward.load(method.name()), paramTypesArray, delegate, argsArray});
            } else {
                MethodDescriptor virtualMethod = MethodDescriptor.ofMethod((String)providerTypeName, (String)originalMethodDescriptor.getName(), (String)originalMethodDescriptor.getReturnType(), (String[])originalMethodDescriptor.getParameterTypes());
                ret = forward.invokeVirtualMethod(virtualMethod, delegate, params);
            }
            forward.returnValue(ret);
        }
        clientProxy.close();
        return classOutput.getResources();
    }

    void createConstructor(ClassCreator clientProxy, String beanClassName, String superClasName, FieldDescriptor beanField) {
        MethodCreator creator = clientProxy.getMethodCreator("<init>", Void.TYPE, new Object[]{beanClassName});
        creator.invokeSpecialMethod(MethodDescriptor.ofConstructor((String)superClasName, (String[])new String[0]), creator.getThis(), new ResultHandle[0]);
        creator.writeInstanceField(beanField, creator.getThis(), creator.getMethodParam(0));
        creator.returnValue(null);
    }

    void implementDelegate(ClassCreator clientProxy, String providerTypeName, FieldDescriptor beanField) {
        MethodCreator creator = (MethodCreator)clientProxy.getMethodCreator("delegate", providerTypeName, new String[0]).setModifiers(2);
        ResultHandle container = creator.invokeStaticMethod(MethodDescriptors.ARC_CONTAINER, new ResultHandle[0]);
        ResultHandle bean = creator.readInstanceField(beanField, creator.getThis());
        ResultHandle scope = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(InjectableBean.class, (String)"getScope", Class.class, (Class[])new Class[0]), bean, new ResultHandle[0]);
        ResultHandle context = creator.invokeInterfaceMethod(MethodDescriptors.ARC_CONTAINER_GET_ACTIVE_CONTEXT, container, new ResultHandle[]{scope});
        BytecodeCreator inactiveBranch = creator.ifNull(context).trueBranch();
        ResultHandle exception = inactiveBranch.newInstance(MethodDescriptor.ofConstructor(ContextNotActiveException.class, (Class[])new Class[]{String.class}), new ResultHandle[]{inactiveBranch.invokeVirtualMethod(MethodDescriptors.OBJECT_TO_STRING, scope, new ResultHandle[0])});
        inactiveBranch.throwException(exception);
        AssignableResultHandle ret = creator.createVariable(Object.class);
        creator.assign(ret, creator.invokeInterfaceMethod(MethodDescriptors.CONTEXT_GET_IF_PRESENT, context, new ResultHandle[]{bean}));
        BytecodeCreator isNullBranch = creator.ifNull((ResultHandle)ret).trueBranch();
        ResultHandle creationContext = isNullBranch.newInstance(MethodDescriptor.ofConstructor(CreationalContextImpl.class, (Class[])new Class[0]), new ResultHandle[0]);
        isNullBranch.assign(ret, isNullBranch.invokeInterfaceMethod(MethodDescriptors.CONTEXT_GET, context, new ResultHandle[]{bean, creationContext}));
        creator.returnValue((ResultHandle)ret);
    }

    void implementGetContextualInstance(ClassCreator clientProxy, String providerTypeName) {
        MethodCreator creator = (MethodCreator)clientProxy.getMethodCreator("getContextualInstance", Object.class, new Class[0]).setModifiers(1);
        creator.returnValue(creator.invokeVirtualMethod(MethodDescriptor.ofMethod((String)clientProxy.getClassName(), (String)"delegate", (String)providerTypeName, (String[])new String[0]), creator.getThis(), new ResultHandle[0]));
    }

    Collection<MethodInfo> getDelegatingMethods(BeanInfo bean) {
        HashMap<Methods.MethodKey, MethodInfo> methods = new HashMap<Methods.MethodKey, MethodInfo>();
        if (bean.isClassBean()) {
            Methods.addDelegatingMethods(bean.getDeployment().getIndex(), bean.getTarget().get().asClass(), Collections.emptyMap(), methods);
        } else if (bean.isProducerMethod()) {
            MethodInfo producerMethod = bean.getTarget().get().asMethod();
            Map<TypeVariable, Type> resolved = Collections.emptyMap();
            ClassInfo returnTypeClass = bean.getDeployment().getIndex().getClassByName(producerMethod.returnType().name());
            if (!returnTypeClass.typeParameters().isEmpty() && !Modifier.isInterface(returnTypeClass.flags())) {
                resolved = Types.buildResolvedMap(producerMethod.returnType().asParameterizedType().arguments(), returnTypeClass.typeParameters(), Collections.emptyMap());
            }
            Methods.addDelegatingMethods(bean.getDeployment().getIndex(), returnTypeClass, resolved, methods);
        } else if (bean.isProducerField()) {
            FieldInfo producerField = bean.getTarget().get().asField();
            Map<TypeVariable, Type> resolved = Collections.emptyMap();
            ClassInfo fieldClass = bean.getDeployment().getIndex().getClassByName(producerField.type().name());
            if (!fieldClass.typeParameters().isEmpty()) {
                resolved = Types.buildResolvedMap(producerField.type().asParameterizedType().arguments(), fieldClass.typeParameters(), Collections.emptyMap());
            }
            Methods.addDelegatingMethods(bean.getDeployment().getIndex(), fieldClass, resolved, methods);
        } else if (bean.isSynthetic()) {
            Methods.addDelegatingMethods(bean.getDeployment().getIndex(), bean.getImplClazz(), Collections.emptyMap(), methods);
        }
        return methods.values();
    }
}

