/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.GenericArrayTypeImpl;
import io.quarkus.arc.ParameterizedTypeImpl;
import io.quarkus.arc.TypeVariableImpl;
import io.quarkus.arc.WildcardTypeImpl;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;

final class Types {
    private static final org.jboss.jandex.Type OBJECT_TYPE = org.jboss.jandex.Type.create((DotName)DotNames.OBJECT, (Type.Kind)Type.Kind.CLASS);

    private Types() {
    }

    static ResultHandle getTypeHandle(BytecodeCreator creator, org.jboss.jandex.Type type) {
        if (Type.Kind.CLASS.equals((Object)type.kind())) {
            return creator.loadClass(type.asClassType().name().toString());
        }
        if (Type.Kind.TYPE_VARIABLE.equals((Object)type.kind())) {
            ResultHandle boundsHandle;
            TypeVariable typeVariable = type.asTypeVariable();
            List bounds = typeVariable.bounds();
            if (bounds.isEmpty()) {
                boundsHandle = creator.newArray(Type.class, creator.load(0));
            } else {
                boundsHandle = creator.newArray(Type.class, creator.load(bounds.size()));
                for (int i = 0; i < bounds.size(); ++i) {
                    creator.writeArrayValue(boundsHandle, i, Types.getTypeHandle(creator, (org.jboss.jandex.Type)bounds.get(i)));
                }
            }
            return creator.newInstance(MethodDescriptor.ofConstructor(TypeVariableImpl.class, (Class[])new Class[]{String.class, Type[].class}), new ResultHandle[]{creator.load(typeVariable.identifier()), boundsHandle});
        }
        if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)type.kind())) {
            ParameterizedType parameterizedType = type.asParameterizedType();
            List arguments = parameterizedType.arguments();
            ResultHandle typeArgsHandle = creator.newArray(Type.class, creator.load(arguments.size()));
            for (int i = 0; i < arguments.size(); ++i) {
                creator.writeArrayValue(typeArgsHandle, i, Types.getTypeHandle(creator, (org.jboss.jandex.Type)arguments.get(i)));
            }
            return creator.newInstance(MethodDescriptor.ofConstructor(ParameterizedTypeImpl.class, (Class[])new Class[]{Type.class, Type[].class}), new ResultHandle[]{creator.loadClass(parameterizedType.name().toString()), typeArgsHandle});
        }
        if (Type.Kind.ARRAY.equals((Object)type.kind())) {
            org.jboss.jandex.Type componentType = type.asArrayType().component();
            return creator.newInstance(MethodDescriptor.ofConstructor(GenericArrayTypeImpl.class, (Class[])new Class[]{Type.class}), new ResultHandle[]{Types.getTypeHandle(creator, componentType)});
        }
        if (Type.Kind.WILDCARD_TYPE.equals((Object)type.kind())) {
            org.jboss.jandex.WildcardType wildcardType = type.asWildcardType();
            if (wildcardType.superBound() == null) {
                return creator.invokeStaticMethod(MethodDescriptor.ofMethod(WildcardTypeImpl.class, (String)"withUpperBound", WildcardType.class, (Class[])new Class[]{Type.class}), new ResultHandle[]{Types.getTypeHandle(creator, wildcardType.extendsBound())});
            }
            return creator.invokeStaticMethod(MethodDescriptor.ofMethod(WildcardTypeImpl.class, (String)"withLowerBound", WildcardType.class, (Class[])new Class[]{Type.class}), new ResultHandle[]{Types.getTypeHandle(creator, wildcardType.superBound())});
        }
        if (Type.Kind.PRIMITIVE.equals((Object)type.kind())) {
            switch (type.asPrimitiveType().primitive()) {
                case INT: {
                    return creator.loadClass(Integer.TYPE);
                }
                case LONG: {
                    return creator.loadClass(Long.TYPE);
                }
                case BOOLEAN: {
                    return creator.loadClass(Boolean.TYPE);
                }
                case BYTE: {
                    return creator.loadClass(Byte.TYPE);
                }
                case CHAR: {
                    return creator.loadClass(Character.TYPE);
                }
                case DOUBLE: {
                    return creator.loadClass(Double.TYPE);
                }
                case FLOAT: {
                    return creator.loadClass(Float.TYPE);
                }
                case SHORT: {
                    return creator.loadClass(Short.TYPE);
                }
            }
            throw new IllegalArgumentException("Unsupported primitive type: " + type);
        }
        throw new IllegalArgumentException("Unsupported bean type: " + type.kind() + ", " + type);
    }

    static org.jboss.jandex.Type getProviderType(ClassInfo classInfo) {
        List typeParameters = classInfo.typeParameters();
        if (!typeParameters.isEmpty()) {
            return ParameterizedType.create((DotName)classInfo.name(), (org.jboss.jandex.Type[])typeParameters.toArray(new org.jboss.jandex.Type[0]), null);
        }
        return org.jboss.jandex.Type.create((DotName)classInfo.name(), (Type.Kind)Type.Kind.CLASS);
    }

    static Set<org.jboss.jandex.Type> getProducerMethodTypeClosure(MethodInfo producerMethod, BeanDeployment beanDeployment) {
        Set<org.jboss.jandex.Type> types;
        org.jboss.jandex.Type returnType = producerMethod.returnType();
        if (returnType.kind() == Type.Kind.PRIMITIVE) {
            HashSet<org.jboss.jandex.Type> types2 = new HashSet<org.jboss.jandex.Type>();
            types2.add(returnType);
            types2.add(OBJECT_TYPE);
            return types2;
        }
        ClassInfo returnTypeClassInfo = beanDeployment.getIndex().getClassByName(returnType.name());
        if (returnTypeClassInfo == null) {
            throw new IllegalArgumentException("Producer method return type not found in index: " + producerMethod.returnType().name());
        }
        if (Type.Kind.CLASS.equals((Object)returnType.kind())) {
            types = Types.getTypeClosure(returnTypeClassInfo, Collections.emptyMap(), beanDeployment);
        } else if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)returnType.kind())) {
            types = Types.getTypeClosure(returnTypeClassInfo, Types.buildResolvedMap(returnType.asParameterizedType().arguments(), returnTypeClassInfo.typeParameters(), Collections.emptyMap()), beanDeployment);
        } else {
            throw new IllegalArgumentException("Unsupported return type");
        }
        return Types.restrictBeanTypes(types, beanDeployment.getAnnotations((AnnotationTarget)producerMethod));
    }

    static Set<org.jboss.jandex.Type> getProducerFieldTypeClosure(FieldInfo producerField, BeanDeployment beanDeployment) {
        Set<org.jboss.jandex.Type> types;
        org.jboss.jandex.Type fieldType = producerField.type();
        if (fieldType.kind() == Type.Kind.PRIMITIVE) {
            types = new HashSet<org.jboss.jandex.Type>();
            types.add(fieldType);
            types.add(OBJECT_TYPE);
        } else {
            ClassInfo fieldClassInfo = beanDeployment.getIndex().getClassByName(producerField.type().name());
            if (fieldClassInfo == null) {
                throw new IllegalArgumentException("Producer field type not found in index: " + producerField.type().name());
            }
            if (Type.Kind.CLASS.equals((Object)fieldType.kind())) {
                types = Types.getTypeClosure(fieldClassInfo, Collections.emptyMap(), beanDeployment);
            } else if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)fieldType.kind())) {
                types = Types.getTypeClosure(fieldClassInfo, Types.buildResolvedMap(fieldType.asParameterizedType().arguments(), fieldClassInfo.typeParameters(), Collections.emptyMap()), beanDeployment);
            } else {
                throw new IllegalArgumentException("Unsupported return type");
            }
        }
        return Types.restrictBeanTypes(types, beanDeployment.getAnnotations((AnnotationTarget)producerField));
    }

    static Set<org.jboss.jandex.Type> getClassBeanTypeClosure(ClassInfo classInfo, Map<TypeVariable, org.jboss.jandex.Type> resolvedTypeParameters, BeanDeployment beanDeployment) {
        return Types.restrictBeanTypes(Types.getTypeClosure(classInfo, resolvedTypeParameters, beanDeployment), beanDeployment.getAnnotations((AnnotationTarget)classInfo));
    }

    private static Set<org.jboss.jandex.Type> getTypeClosure(ClassInfo classInfo, Map<TypeVariable, org.jboss.jandex.Type> resolvedTypeParameters, BeanDeployment beanDeployment) {
        ClassInfo superClassInfo;
        HashSet<org.jboss.jandex.Type> types = new HashSet<org.jboss.jandex.Type>();
        List typeParameters = classInfo.typeParameters();
        if (!typeParameters.isEmpty()) {
            org.jboss.jandex.Type[] typeParams = new org.jboss.jandex.Type[typeParameters.size()];
            for (int i = 0; i < typeParameters.size(); ++i) {
                TypeVariable paramType = (TypeVariable)typeParameters.get(i);
                org.jboss.jandex.Type resolvedType = resolvedTypeParameters.get(paramType);
                if (resolvedType == null) {
                    resolvedType = (org.jboss.jandex.Type)paramType.bounds().get(0);
                }
                typeParams[i] = resolvedType;
            }
            types.add((org.jboss.jandex.Type)ParameterizedType.create((DotName)classInfo.name(), (org.jboss.jandex.Type[])typeParams, null));
        } else {
            types.add(org.jboss.jandex.Type.create((DotName)classInfo.name(), (Type.Kind)Type.Kind.CLASS));
        }
        for (org.jboss.jandex.Type interfaceType : classInfo.interfaceTypes()) {
            ClassInfo interfaceClassInfo = beanDeployment.getIndex().getClassByName(interfaceType.name());
            if (interfaceClassInfo == null) continue;
            Map<TypeVariable, org.jboss.jandex.Type> resolved = Collections.emptyMap();
            if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)interfaceType.kind())) {
                resolved = Types.buildResolvedMap(interfaceType.asParameterizedType().arguments(), interfaceClassInfo.typeParameters(), resolvedTypeParameters);
            }
            types.addAll(Types.getTypeClosure(interfaceClassInfo, resolved, beanDeployment));
        }
        if (classInfo.superClassType() != null && (superClassInfo = beanDeployment.getIndex().getClassByName(classInfo.superName())) != null) {
            Map<TypeVariable, org.jboss.jandex.Type> resolved = Collections.emptyMap();
            if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)classInfo.superClassType().kind())) {
                resolved = Types.buildResolvedMap(classInfo.superClassType().asParameterizedType().arguments(), superClassInfo.typeParameters(), resolvedTypeParameters);
            }
            types.addAll(Types.getTypeClosure(superClassInfo, resolved, beanDeployment));
        }
        return types;
    }

    static Set<org.jboss.jandex.Type> restrictBeanTypes(Set<org.jboss.jandex.Type> types, Collection<AnnotationInstance> annotations) {
        AnnotationInstance typed = annotations.stream().filter(a -> a.name().equals((Object)DotNames.TYPED)).findFirst().orElse(null);
        if (typed != null) {
            AnnotationValue typedValue = typed.value();
            if (typedValue == null) {
                types.clear();
                types.add(OBJECT_TYPE);
            } else {
                HashSet<DotName> typedClasses = new HashSet<DotName>();
                for (org.jboss.jandex.Type type : typedValue.asClassArray()) {
                    typedClasses.add(type.name());
                }
                Iterator<org.jboss.jandex.Type> iterator = types.iterator();
                while (iterator.hasNext()) {
                    if (typedClasses.contains(iterator.next().name())) continue;
                    iterator.remove();
                }
            }
        }
        return types;
    }

    static Map<TypeVariable, org.jboss.jandex.Type> buildResolvedMap(List<org.jboss.jandex.Type> resolvedTypeVariables, List<TypeVariable> typeVariables, Map<TypeVariable, org.jboss.jandex.Type> resolvedTypeParameters) {
        HashMap<TypeVariable, org.jboss.jandex.Type> resolvedMap = new HashMap<TypeVariable, org.jboss.jandex.Type>();
        for (int i = 0; i < resolvedTypeVariables.size(); ++i) {
            org.jboss.jandex.Type resolvedTypeVariable = resolvedTypeVariables.get(i);
            org.jboss.jandex.Type resolvedTypeParam = Type.Kind.TYPE_VARIABLE.equals((Object)resolvedTypeVariable.kind()) ? resolvedTypeParameters.getOrDefault(resolvedTypeVariable, resolvedTypeVariable) : resolvedTypeVariable;
            resolvedMap.put(typeVariables.get(i), resolvedTypeParam);
        }
        return resolvedMap;
    }

    static String getPackageName(String className) {
        return (className = className.replace('/', '.')).contains(".") ? className.substring(0, className.lastIndexOf(".")) : "";
    }

    static String getSimpleName(String className) {
        return className.contains(".") ? className.substring(className.lastIndexOf(".") + 1, className.length()) : className;
    }
}

