/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.BeanCreator;
import io.quarkus.arc.BeanDestroyer;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public final class BeanConfigurator<T> {
    private final Consumer<BeanInfo> beanConsumer;
    private final BeanDeployment beanDeployment;
    private final ClassInfo implClass;
    private Type providerType;
    private final Set<Type> types;
    private final Set<AnnotationInstance> qualifiers;
    private ScopeInfo scope;
    private Integer alternativePriority;
    private String name;
    private Consumer<MethodCreator> creatorConsumer;
    private Consumer<MethodCreator> destroyerConsumer;
    private final Map<String, Object> params;

    BeanConfigurator(DotName implClassName, BeanDeployment beanDeployment, Consumer<BeanInfo> beanConsumer) {
        this.implClass = beanDeployment.getIndex().getClassByName(Objects.requireNonNull(implClassName));
        this.beanDeployment = beanDeployment;
        this.beanConsumer = beanConsumer;
        this.types = new HashSet<Type>();
        this.qualifiers = new HashSet<AnnotationInstance>();
        this.scope = BuiltinScope.DEPENDENT.getInfo();
        this.params = new HashMap<String, Object>();
        this.name = null;
    }

    public BeanConfigurator<T> param(String name, Class<?> value) {
        this.params.put(name, value);
        return this;
    }

    public BeanConfigurator<T> param(String name, int value) {
        this.params.put(name, value);
        return this;
    }

    public BeanConfigurator<T> param(String name, long value) {
        this.params.put(name, value);
        return this;
    }

    public BeanConfigurator<T> param(String name, double value) {
        this.params.put(name, value);
        return this;
    }

    public BeanConfigurator<T> param(String name, String value) {
        this.params.put(name, value);
        return this;
    }

    public BeanConfigurator<T> param(String name, boolean value) {
        this.params.put(name, value);
        return this;
    }

    public BeanConfigurator<T> types(Class<?> ... types) {
        for (Class<?> type : types) {
            this.types.add(Type.create((DotName)DotName.createSimple((String)type.getName()), (Type.Kind)Type.Kind.CLASS));
        }
        return this;
    }

    public BeanConfigurator<T> types(Type ... types) {
        Collections.addAll(this.types, types);
        return this;
    }

    public BeanConfigurator<T> addType(DotName className) {
        this.types.add(Type.create((DotName)className, (Type.Kind)Type.Kind.CLASS));
        return this;
    }

    public BeanConfigurator<T> addQualifier(DotName annotationName) {
        this.qualifiers.add(AnnotationInstance.create((DotName)annotationName, null, (AnnotationValue[])new AnnotationValue[0]));
        return this;
    }

    public BeanConfigurator<T> qualifiers(AnnotationInstance ... qualifiers) {
        Collections.addAll(this.qualifiers, qualifiers);
        return this;
    }

    public BeanConfigurator<T> scope(ScopeInfo scope) {
        this.scope = scope;
        return this;
    }

    public BeanConfigurator<T> name(String name) {
        this.name = name;
        return this;
    }

    public BeanConfigurator<T> alternativePriority(int priority) {
        this.alternativePriority = priority;
        return this;
    }

    public BeanConfigurator<T> providerType(Type providerType) {
        this.providerType = providerType;
        return this;
    }

    public <U extends T> BeanConfigurator<U> creator(Class<? extends BeanCreator<U>> creatorClazz) {
        return this.creator((MethodCreator mc) -> {
            ResultHandle paramsHandle = mc.readInstanceField(FieldDescriptor.of((String)mc.getMethodDescriptor().getDeclaringClass(), (String)"params", Map.class), mc.getThis());
            ResultHandle creatorHandle = mc.newInstance(MethodDescriptor.ofConstructor((Class)creatorClazz, (Class[])new Class[0]), new ResultHandle[0]);
            ResultHandle[] params = new ResultHandle[]{mc.getMethodParam(0), paramsHandle};
            ResultHandle ret = mc.invokeInterfaceMethod(MethodDescriptor.ofMethod(BeanCreator.class, (String)"create", Object.class, (Class[])new Class[]{CreationalContext.class, Map.class}), creatorHandle, params);
            mc.returnValue(ret);
        });
    }

    public <U extends T> BeanConfigurator<U> creator(Consumer<MethodCreator> methodCreatorConsumer) {
        this.creatorConsumer = methodCreatorConsumer;
        return (BeanConfigurator)BeanConfigurator.cast(this);
    }

    public <U extends T> BeanConfigurator<U> destroyer(Class<? extends BeanDestroyer<U>> destroyerClazz) {
        return this.destroyer((MethodCreator mc) -> {
            ResultHandle paramsHandle = mc.readInstanceField(FieldDescriptor.of((String)mc.getMethodDescriptor().getDeclaringClass(), (String)"params", Map.class), mc.getThis());
            ResultHandle destoyerHandle = mc.newInstance(MethodDescriptor.ofConstructor((Class)destroyerClazz, (Class[])new Class[0]), new ResultHandle[0]);
            ResultHandle[] params = new ResultHandle[]{mc.getMethodParam(0), mc.getMethodParam(1), paramsHandle};
            mc.invokeInterfaceMethod(MethodDescriptor.ofMethod(BeanDestroyer.class, (String)"destroy", Void.class, (Class[])new Class[]{Object.class, CreationalContext.class, Map.class}), destoyerHandle, params);
            mc.returnValue(null);
        });
    }

    public <U extends T> BeanConfigurator<U> destroyer(Consumer<MethodCreator> methodCreatorConsumer) {
        this.destroyerConsumer = methodCreatorConsumer;
        return (BeanConfigurator)BeanConfigurator.cast(this);
    }

    public void done() {
        this.beanConsumer.accept(new BeanInfo.Builder().implClazz(this.implClass).providerType(this.providerType).beanDeployment(this.beanDeployment).scope(this.scope).types(this.types).qualifiers(this.qualifiers).alternativePriority(this.alternativePriority).name(this.name).creator(this.creatorConsumer).destroyer(this.destroyerConsumer).params(this.params).build());
    }

    private static <T> T cast(Object obj) {
        return (T)obj;
    }
}

