/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class Injection {
    private static final Logger LOGGER = Logger.getLogger(Injection.class);
    final AnnotationTarget target;
    final List<InjectionPointInfo> injectionPoints;

    static List<Injection> forBean(AnnotationTarget beanTarget, BeanDeployment beanDeployment) {
        if (AnnotationTarget.Kind.CLASS.equals((Object)beanTarget.kind())) {
            ArrayList<Injection> injections = new ArrayList<Injection>();
            Injection.forClassBean(beanTarget.asClass(), beanDeployment, injections, true);
            return injections;
        }
        if (AnnotationTarget.Kind.METHOD.equals((Object)beanTarget.kind())) {
            if (beanTarget.asMethod().parameters().isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.singletonList(new Injection((AnnotationTarget)beanTarget.asMethod(), InjectionPointInfo.fromMethod(beanTarget.asMethod(), beanDeployment)));
        }
        throw new IllegalArgumentException("Unsupported annotation target");
    }

    private static void forClassBean(ClassInfo beanTarget, BeanDeployment beanDeployment, List<Injection> injections, boolean isFirstLevel) {
        ClassInfo info;
        List<AnnotationInstance> injectAnnotations = Injection.getAllInjectionPoints(beanDeployment, beanTarget, DotNames.INJECT);
        block4: for (AnnotationInstance annotationInstance : injectAnnotations) {
            AnnotationTarget injectTarget = annotationInstance.target();
            switch (annotationInstance.target().kind()) {
                case FIELD: {
                    injections.add(new Injection(injectTarget, Collections.singletonList(InjectionPointInfo.fromField(injectTarget.asField(), beanDeployment))));
                    continue block4;
                }
                case METHOD: {
                    injections.add(new Injection(injectTarget, InjectionPointInfo.fromMethod(injectTarget.asMethod(), beanDeployment)));
                    continue block4;
                }
            }
            LOGGER.warn((Object)("Unsupported @Inject target ignored: " + annotationInstance.target()));
        }
        if (isFirstLevel) {
            boolean bl;
            boolean constrInjectionExists = false;
            for (Injection injection : injections) {
                if (!injection.isConstructor()) continue;
                constrInjectionExists = true;
                break;
            }
            boolean bl2 = bl = beanTarget.name().isInner() && !Modifier.isStatic(beanTarget.flags());
            if (!bl && !constrInjectionExists) {
                ArrayList<MethodInfo> nonNoargConstrs = new ArrayList<MethodInfo>();
                for (MethodInfo constr : beanTarget.methods()) {
                    if (!"<init>".equals(constr.name()) || constr.parameters().size() <= 0) continue;
                    nonNoargConstrs.add(constr);
                }
                if (nonNoargConstrs.size() == 1) {
                    MethodInfo injectTarget = (MethodInfo)nonNoargConstrs.get(0);
                    injections.add(new Injection((AnnotationTarget)injectTarget, InjectionPointInfo.fromMethod(injectTarget.asMethod(), beanDeployment)));
                }
            }
        }
        for (DotName dotName : beanDeployment.getResourceAnnotations()) {
            List<AnnotationInstance> resourceAnnotations = Injection.getAllInjectionPoints(beanDeployment, beanTarget, dotName);
            if (resourceAnnotations == null) continue;
            for (AnnotationInstance resourceAnnotationInstance : resourceAnnotations) {
                if (AnnotationTarget.Kind.FIELD != resourceAnnotationInstance.target().kind() || !resourceAnnotationInstance.target().asField().annotations().stream().noneMatch(a -> DotNames.INJECT.equals((Object)a.name()))) continue;
                injections.add(new Injection(resourceAnnotationInstance.target(), Collections.singletonList(InjectionPointInfo.fromResourceField(resourceAnnotationInstance.target().asField(), beanDeployment))));
            }
        }
        if (!beanTarget.superName().equals((Object)DotNames.OBJECT) && (info = beanDeployment.getIndex().getClassByName(beanTarget.superName())) != null) {
            Injection.forClassBean(info, beanDeployment, injections, false);
        }
    }

    static Injection forDisposer(MethodInfo disposerMethod, BeanDeployment beanDeployment) {
        return new Injection((AnnotationTarget)disposerMethod, InjectionPointInfo.fromMethod(disposerMethod, beanDeployment, annotations -> annotations.stream().anyMatch(a -> a.name().equals((Object)DotNames.DISPOSES))));
    }

    static Injection forObserver(MethodInfo observerMethod, BeanDeployment beanDeployment) {
        return new Injection((AnnotationTarget)observerMethod, InjectionPointInfo.fromMethod(observerMethod, beanDeployment, annotations -> annotations.stream().anyMatch(a -> a.name().equals((Object)DotNames.OBSERVES) || a.name().equals((Object)DotNames.OBSERVES_ASYNC))));
    }

    public Injection(AnnotationTarget target, List<InjectionPointInfo> injectionPoints) {
        this.target = target;
        this.injectionPoints = injectionPoints;
    }

    boolean isMethod() {
        return AnnotationTarget.Kind.METHOD == this.target.kind();
    }

    boolean isConstructor() {
        return this.isMethod() && this.target.asMethod().name().equals("<init>");
    }

    boolean isField() {
        return AnnotationTarget.Kind.FIELD == this.target.kind();
    }

    private static List<AnnotationInstance> getAllInjectionPoints(BeanDeployment beanDeployment, ClassInfo beanClass, DotName name) {
        AnnotationInstance inject;
        ArrayList<AnnotationInstance> injectAnnotations = new ArrayList<AnnotationInstance>();
        for (FieldInfo field : beanClass.fields()) {
            inject = beanDeployment.getAnnotation((AnnotationTarget)field, name);
            if (inject == null) continue;
            injectAnnotations.add(inject);
        }
        for (MethodInfo method : beanClass.methods()) {
            inject = beanDeployment.getAnnotation((AnnotationTarget)method, name);
            if (inject == null) continue;
            injectAnnotations.add(inject);
        }
        return injectAnnotations;
    }
}

