/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DotNames;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class InjectionPointInfo {
    private final TypeAndQualifiers typeAndQualifiers;
    private final AtomicReference<BeanInfo> resolvedBean;
    private final InjectionPointKind kind;
    private final boolean hasDefaultedQualifier;
    private final AnnotationTarget target;
    private final int position;

    static InjectionPointInfo fromField(FieldInfo field, BeanDeployment beanDeployment) {
        HashSet qualifiers = new HashSet();
        for (AnnotationInstance annotation : beanDeployment.getAnnotations((AnnotationTarget)field)) {
            if (beanDeployment.getQualifier(annotation.name()) == null) continue;
            qualifiers.add(annotation);
        }
        return new InjectionPointInfo(field.type(), qualifiers.isEmpty() ? Collections.emptySet() : qualifiers, (AnnotationTarget)field, -1);
    }

    static InjectionPointInfo fromResourceField(FieldInfo field, BeanDeployment beanDeployment) {
        return new InjectionPointInfo(field.type(), new HashSet<AnnotationInstance>(field.annotations()), InjectionPointKind.RESOURCE, (AnnotationTarget)field, -1);
    }

    static List<InjectionPointInfo> fromMethod(MethodInfo method, BeanDeployment beanDeployment) {
        return InjectionPointInfo.fromMethod(method, beanDeployment, null);
    }

    static List<InjectionPointInfo> fromMethod(MethodInfo method, BeanDeployment beanDeployment, Predicate<Set<AnnotationInstance>> skipPredicate) {
        ArrayList<InjectionPointInfo> injectionPoints = new ArrayList<InjectionPointInfo>();
        ListIterator iterator = method.parameters().listIterator();
        while (iterator.hasNext()) {
            Type paramType = (Type)iterator.next();
            int position = iterator.previousIndex();
            Set<AnnotationInstance> paramAnnotations = Annotations.getParameterAnnotations(beanDeployment, method, position);
            if (skipPredicate != null && skipPredicate.test(paramAnnotations)) continue;
            HashSet<AnnotationInstance> paramQualifiers = new HashSet<AnnotationInstance>();
            for (AnnotationInstance paramAnnotation : paramAnnotations) {
                if (beanDeployment.getQualifier(paramAnnotation.name()) == null) continue;
                paramQualifiers.add(paramAnnotation);
            }
            injectionPoints.add(new InjectionPointInfo(paramType, paramQualifiers, (AnnotationTarget)method, position));
        }
        return injectionPoints;
    }

    InjectionPointInfo(Type requiredType, Set<AnnotationInstance> requiredQualifiers, AnnotationTarget target, int position) {
        this(requiredType, requiredQualifiers, InjectionPointKind.CDI, target, position);
    }

    InjectionPointInfo(Type requiredType, Set<AnnotationInstance> requiredQualifiers, InjectionPointKind kind, AnnotationTarget target, int position) {
        this.typeAndQualifiers = new TypeAndQualifiers(requiredType, requiredQualifiers.isEmpty() ? Collections.singleton(AnnotationInstance.create((DotName)DotNames.DEFAULT, null, Collections.emptyList())) : requiredQualifiers);
        this.resolvedBean = new AtomicReference<Object>(null);
        this.kind = kind;
        this.hasDefaultedQualifier = requiredQualifiers.isEmpty();
        this.target = target;
        this.position = position;
    }

    void resolve(BeanInfo bean) {
        this.resolvedBean.set(bean);
    }

    BeanInfo getResolvedBean() {
        return this.resolvedBean.get();
    }

    InjectionPointKind getKind() {
        return this.kind;
    }

    public Type getRequiredType() {
        return this.typeAndQualifiers.type;
    }

    public Set<AnnotationInstance> getRequiredQualifiers() {
        return this.typeAndQualifiers.qualifiers;
    }

    public AnnotationInstance getRequiredQualifier(DotName name) {
        for (AnnotationInstance qualifier : this.typeAndQualifiers.qualifiers) {
            if (!qualifier.name().equals((Object)name)) continue;
            return qualifier;
        }
        return null;
    }

    public boolean hasDefaultedQualifier() {
        return this.hasDefaultedQualifier;
    }

    TypeAndQualifiers getTypeAndQualifiers() {
        return this.typeAndQualifiers;
    }

    public AnnotationTarget getTarget() {
        return this.target;
    }

    public boolean isField() {
        return this.target.kind() == AnnotationTarget.Kind.FIELD;
    }

    public boolean isParam() {
        return this.target.kind() == AnnotationTarget.Kind.METHOD;
    }

    public int getPosition() {
        return this.position;
    }

    public String getTargetInfo() {
        switch (this.target.kind()) {
            case FIELD: {
                return this.target.asField().declaringClass().name() + "#" + this.target.asField().name();
            }
            case METHOD: {
                return this.target.asMethod().declaringClass().name() + "#" + this.target.asMethod().name() + "()";
            }
        }
        return this.target.toString();
    }

    public String toString() {
        return "InjectionPointInfo [requiredType=" + this.typeAndQualifiers.type + ", requiredQualifiers=" + this.typeAndQualifiers.qualifiers + "]";
    }

    static class TypeAndQualifiers {
        final Type type;
        final Set<AnnotationInstance> qualifiers;

        public TypeAndQualifiers(Type type, Set<AnnotationInstance> qualifiers) {
            this.type = type;
            this.qualifiers = qualifiers;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.qualifiers == null ? 0 : this.qualifiers.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeAndQualifiers other = (TypeAndQualifiers)obj;
            if (this.qualifiers == null ? other.qualifiers != null : !this.qualifiers.equals(other.qualifiers)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
        }
    }

    static enum InjectionPointKind {
        CDI,
        RESOURCE;

    }
}

