/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InterceptorInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.InterceptionType;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Type;

public class InterceptorResolver {
    private final BeanDeployment beanDeployment;

    public InterceptorResolver(BeanDeployment beanDeployment) {
        this.beanDeployment = beanDeployment;
    }

    public List<InterceptorInfo> resolve(InterceptionType interceptionType, Set<AnnotationInstance> bindings) {
        if (bindings.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<InterceptorInfo> interceptors = new ArrayList<InterceptorInfo>();
        for (InterceptorInfo interceptor : this.beanDeployment.getInterceptors()) {
            if (!interceptor.intercepts(interceptionType)) continue;
            boolean matches = true;
            for (AnnotationInstance interceptorBinding : interceptor.getBindings()) {
                if (this.hasInterceptorBinding(bindings, interceptorBinding)) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            interceptors.add(interceptor);
        }
        if (interceptors.isEmpty()) {
            return Collections.emptyList();
        }
        interceptors.sort(this::compare);
        return interceptors;
    }

    private int compare(InterceptorInfo i1, InterceptorInfo i2) {
        return Integer.compare(i1.getPriority(), i2.getPriority());
    }

    private boolean hasInterceptorBinding(Set<AnnotationInstance> bindings, AnnotationInstance interceptorBinding) {
        ClassInfo interceptorBindingClass = this.beanDeployment.getInterceptorBinding(interceptorBinding.name());
        for (AnnotationInstance binding : bindings) {
            if (!binding.name().equals((Object)interceptorBinding.name())) continue;
            boolean matches = true;
            for (AnnotationValue value : binding.valuesWithDefaults(this.beanDeployment.getIndex())) {
                if (interceptorBindingClass.method(value.name(), new Type[0]).hasAnnotation(DotNames.NONBINDING) || value.equals((Object)interceptorBinding.value(value.name()))) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return true;
        }
        return false;
    }
}

