/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.DotNames;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.jandex.WildcardType;
import org.jboss.logging.Logger;

final class Methods {
    private static final Logger LOGGER = Logger.getLogger(Methods.class);
    public static final String INIT = "<init>";
    public static final String CLINIT = "<clinit>";
    static final int SYNTHETIC = 4096;
    private static final List<String> IGNORED_METHODS = Methods.initIgnoredMethods();

    private static List<String> initIgnoredMethods() {
        ArrayList<String> ignored = new ArrayList<String>();
        ignored.add(INIT);
        ignored.add(CLINIT);
        return ignored;
    }

    private Methods() {
    }

    static boolean isSynthetic(MethodInfo method) {
        return (method.flags() & 0x1000) != 0;
    }

    static void addDelegatingMethods(IndexView index, ClassInfo classInfo, Map<MethodKey, MethodInfo> methods) {
        if (classInfo != null) {
            ClassInfo superClassInfo;
            for (MethodInfo method : classInfo.methods()) {
                if (Methods.skipForClientProxy(method)) continue;
                methods.computeIfAbsent(new MethodKey(method), key -> {
                    Type returnType = key.method.returnType();
                    Type[] params = new Type[key.method.parameters().size()];
                    for (int i = 0; i < params.length; ++i) {
                        params[i] = (Type)key.method.parameters().get(i);
                    }
                    List typeVariables = key.method.typeParameters();
                    return MethodInfo.create((ClassInfo)classInfo, (String)key.method.name(), (Type[])params, (Type)returnType, (short)key.method.flags(), (TypeVariable[])typeVariables.toArray(new TypeVariable[0]), (Type[])key.method.exceptions().toArray(Type.EMPTY_ARRAY));
                });
            }
            for (Type interfaceType : classInfo.interfaceTypes()) {
                ClassInfo interfaceClassInfo = index.getClassByName(interfaceType.name());
                if (interfaceClassInfo == null) continue;
                Methods.addDelegatingMethods(index, interfaceClassInfo, methods);
            }
            if (classInfo.superClassType() != null && (superClassInfo = index.getClassByName(classInfo.superName())) != null) {
                Methods.addDelegatingMethods(index, superClassInfo, methods);
            }
        }
    }

    private static boolean skipForClientProxy(MethodInfo method) {
        if (Modifier.isStatic(method.flags()) || Modifier.isPrivate(method.flags())) {
            return true;
        }
        if (IGNORED_METHODS.contains(method.name())) {
            return true;
        }
        if (method.declaringClass().name().equals((Object)DotNames.OBJECT)) {
            return true;
        }
        if (Modifier.isFinal(method.flags())) {
            String className = method.declaringClass().name().toString();
            if (!className.startsWith("java.")) {
                LOGGER.warn((Object)String.format("Method %s.%s() is final, skipped during generation of the corresponding client proxy", className, method.name()));
            }
            return true;
        }
        return false;
    }

    static void addInterceptedMethodCandidates(BeanDeployment beanDeployment, ClassInfo classInfo, Map<MethodKey, Set<AnnotationInstance>> candidates, List<AnnotationInstance> classLevelBindings) {
        ClassInfo superClassInfo;
        for (MethodInfo method : classInfo.methods()) {
            if (Methods.skipForSubclass(method)) continue;
            Collection<AnnotationInstance> methodAnnnotations = beanDeployment.getAnnotations((AnnotationTarget)method);
            List methodLevelBindings = methodAnnnotations.stream().filter(a -> beanDeployment.getInterceptorBinding(a.name()) != null).collect(Collectors.toList());
            HashSet<Object> merged = new HashSet<Object>();
            merged.addAll(methodLevelBindings);
            for (AnnotationInstance classLevelBinding : classLevelBindings) {
                if (!methodLevelBindings.isEmpty() && !methodLevelBindings.stream().noneMatch(a -> classLevelBinding.name().equals((Object)a.name()))) continue;
                merged.add(classLevelBinding);
            }
            if (merged.isEmpty()) continue;
            if (Modifier.isFinal(method.flags())) {
                String className = method.declaringClass().name().toString();
                if (className.startsWith("java.")) continue;
                LOGGER.warn((Object)String.format("Method %s.%s() is final, skipped during generation of the corresponding intercepted subclass", className, method.name()));
                continue;
            }
            candidates.computeIfAbsent(new MethodKey(method), key -> merged);
        }
        if (classInfo.superClassType() != null && (superClassInfo = beanDeployment.getIndex().getClassByName(classInfo.superName())) != null) {
            Methods.addInterceptedMethodCandidates(beanDeployment, superClassInfo, candidates, classLevelBindings);
        }
    }

    private static boolean skipForSubclass(MethodInfo method) {
        if (Modifier.isStatic(method.flags())) {
            return true;
        }
        if (IGNORED_METHODS.contains(method.name())) {
            return true;
        }
        return method.declaringClass().name().equals((Object)DotNames.OBJECT);
    }

    static Type resolveType(Type type, Map<TypeVariable, Type> resolvedTypeParameters) {
        switch (type.kind()) {
            case CLASS: 
            case PRIMITIVE: 
            case VOID: {
                return type;
            }
            case TYPE_VARIABLE: {
                return resolvedTypeParameters.getOrDefault(type.asTypeVariable(), type);
            }
            case PARAMETERIZED_TYPE: {
                ParameterizedType parameterizedType = type.asParameterizedType();
                Type[] args = new Type[parameterizedType.arguments().size()];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = Methods.resolveType((Type)parameterizedType.arguments().get(i), resolvedTypeParameters);
                }
                return ParameterizedType.create((DotName)parameterizedType.name(), (Type[])args, null);
            }
            case WILDCARD_TYPE: {
                WildcardType wildcardType = type.asWildcardType();
                return WildcardType.create((Type)Methods.resolveType(wildcardType.superBound() != null ? wildcardType.superBound() : wildcardType.extendsBound(), resolvedTypeParameters), (wildcardType.superBound() == null ? 1 : 0) != 0);
            }
            case ARRAY: {
                ArrayType arrayType = type.asArrayType();
                return ArrayType.create((Type)Methods.resolveType(arrayType.component(), resolvedTypeParameters), (int)arrayType.dimensions());
            }
        }
        throw new IllegalArgumentException("Unsupported type to resolve: " + type);
    }

    static boolean isOverriden(MethodInfo method, Collection<MethodInfo> previousMethods) {
        for (MethodInfo other : previousMethods) {
            if (!Methods.matchesSignature(method, other)) continue;
            return true;
        }
        return false;
    }

    static boolean matchesSignature(MethodInfo method, MethodInfo subclassMethod) {
        if (!method.name().equals(subclassMethod.name())) {
            return false;
        }
        List parameters = method.parameters();
        List subParameters = subclassMethod.parameters();
        int paramCount = parameters.size();
        if (paramCount != subParameters.size()) {
            return false;
        }
        if (paramCount == 0) {
            return true;
        }
        for (int i = 0; i < paramCount; ++i) {
            if (Methods.isTypeEqual((Type)parameters.get(i), (Type)subParameters.get(i))) continue;
            return false;
        }
        return true;
    }

    static boolean isTypeEqual(Type a, Type b) {
        return Methods.toRawType(a).equals((Object)Methods.toRawType(b));
    }

    static DotName toRawType(Type a) {
        switch (a.kind()) {
            case CLASS: 
            case PRIMITIVE: 
            case ARRAY: {
                return a.name();
            }
            case PARAMETERIZED_TYPE: {
                return a.asParameterizedType().name();
            }
        }
        return DotNames.OBJECT;
    }

    static class MethodKey {
        final String name;
        final List<DotName> params;
        final MethodInfo method;

        public MethodKey(MethodInfo method) {
            this.method = method;
            this.name = method.name();
            this.params = new ArrayList<DotName>();
            for (Type i : method.parameters()) {
                this.params.add(i.name());
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MethodKey)) {
                return false;
            }
            MethodKey other = (MethodKey)obj;
            if (!this.name.equals(other.name)) {
                return false;
            }
            return this.params.equals(other.params);
        }
    }
}

