/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.BeanManagerProvider;
import io.quarkus.arc.BeanMetadataProvider;
import io.quarkus.arc.EventProvider;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableReferenceProvider;
import io.quarkus.arc.InjectionPointProvider;
import io.quarkus.arc.InstanceProvider;
import io.quarkus.arc.InterceptedBeanMetadataProvider;
import io.quarkus.arc.ResourceProvider;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanGenerator;
import io.quarkus.arc.processor.BuiltinQualifier;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InjectionTargetInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.Types;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

enum BuiltinBean {
    INSTANCE(DotNames.INSTANCE, ctx -> {
        ResultHandle qualifiers = BeanGenerator.collectQualifiers(ctx.classOutput, ctx.clazzCreator, ctx.beanDeployment, ctx.constructor, ctx.injectionPoint, ctx.annotationLiterals);
        ResultHandle parameterizedType = Types.getTypeHandle((BytecodeCreator)ctx.constructor, ctx.injectionPoint.getRequiredType());
        ResultHandle annotationsHandle = BeanGenerator.collectAnnotations(ctx.classOutput, ctx.clazzCreator, ctx.beanDeployment, ctx.constructor, ctx.injectionPoint, ctx.annotationLiterals);
        ResultHandle javaMemberHandle = BeanGenerator.getJavaMemberHandle(ctx.constructor, ctx.injectionPoint);
        ResultHandle instanceProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(InstanceProvider.class, (Class[])new Class[]{Type.class, Set.class, InjectableBean.class, Set.class, Member.class, Integer.TYPE}), new ResultHandle[]{parameterizedType, qualifiers, ctx.constructor.getThis(), annotationsHandle, javaMemberHandle, ctx.constructor.load(ctx.injectionPoint.getPosition())});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)InjectableReferenceProvider.class.getName()), ctx.constructor.getThis(), instanceProvider);
    }, BuiltinBean::isInstanceInjectionPoint),
    INJECTION_POINT(DotNames.INJECTION_POINT, ctx -> ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)InjectableReferenceProvider.class.getName()), ctx.constructor.getThis(), ctx.constructor.newInstance(MethodDescriptor.ofConstructor(InjectionPointProvider.class, (Class[])new Class[0]), new ResultHandle[0]))),
    BEAN(DotNames.BEAN, ctx -> {
        if (ctx.targetInfo.kind() != InjectionTargetInfo.TargetKind.BEAN) {
            throw new IllegalStateException("Invalid injection target info: " + ctx.targetInfo);
        }
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)InjectableReferenceProvider.class.getName()), ctx.constructor.getThis(), ctx.constructor.newInstance(MethodDescriptor.ofConstructor(BeanMetadataProvider.class, (Class[])new Class[]{String.class}), new ResultHandle[]{ctx.constructor.load(ctx.targetInfo.asBean().getIdentifier())}));
    }, ip -> BuiltinBean.isCdiAndRawTypeMatches(ip, DotNames.BEAN) && ip.hasDefaultedQualifier()),
    INTERCEPTED_BEAN(DotNames.BEAN, ctx -> {
        if (!(ctx.targetInfo instanceof InterceptorInfo)) {
            throw new IllegalStateException("Invalid injection target info: " + ctx.targetInfo);
        }
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)InjectableReferenceProvider.class.getName()), ctx.constructor.getThis(), ctx.constructor.newInstance(MethodDescriptor.ofConstructor(InterceptedBeanMetadataProvider.class, (Class[])new Class[0]), new ResultHandle[0]));
    }, ip -> BuiltinBean.isCdiAndRawTypeMatches(ip, DotNames.BEAN) && !ip.hasDefaultedQualifier() && ip.getRequiredQualifiers().size() == 1 && ip.getRequiredQualifiers().iterator().next().name().equals((Object)DotNames.INTERCEPTED)),
    BEAN_MANAGER(DotNames.BEAN_MANAGER, ctx -> ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)InjectableReferenceProvider.class.getName()), ctx.constructor.getThis(), ctx.constructor.newInstance(MethodDescriptor.ofConstructor(BeanManagerProvider.class, (Class[])new Class[0]), new ResultHandle[0]))),
    EVENT(DotNames.EVENT, ctx -> {
        ResultHandle qualifiers = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
        if (!ctx.injectionPoint.getRequiredQualifiers().isEmpty()) {
            for (AnnotationInstance qualifierAnnotation : ctx.injectionPoint.getRequiredQualifiers()) {
                BuiltinQualifier qualifier = BuiltinQualifier.of(qualifierAnnotation);
                if (qualifier != null) {
                    ctx.constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, qualifiers, new ResultHandle[]{qualifier.getLiteralInstance((BytecodeCreator)ctx.constructor)});
                    continue;
                }
                ClassInfo qualifierClass = ctx.beanDeployment.getQualifier(qualifierAnnotation.name());
                ctx.constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, qualifiers, new ResultHandle[]{ctx.annotationLiterals.process((BytecodeCreator)ctx.constructor, ctx.classOutput, qualifierClass, qualifierAnnotation, Types.getPackageName(ctx.clazzCreator.getClassName()))});
            }
        }
        ResultHandle parameterizedType = Types.getTypeHandle((BytecodeCreator)ctx.constructor, ctx.injectionPoint.getRequiredType());
        ResultHandle eventProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(EventProvider.class, (Class[])new Class[]{Type.class, Set.class}), new ResultHandle[]{parameterizedType, qualifiers});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)InjectableReferenceProvider.class.getName()), ctx.constructor.getThis(), eventProvider);
    }),
    RESOURCE(DotNames.OBJECT, ctx -> {
        ResultHandle annotations = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
        if (!ctx.injectionPoint.getRequiredQualifiers().isEmpty()) {
            for (AnnotationInstance annotation : ctx.injectionPoint.getRequiredQualifiers()) {
                ClassInfo annotationClass = ctx.beanDeployment.getIndex().getClassByName(annotation.name());
                ctx.constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, annotations, new ResultHandle[]{ctx.annotationLiterals.process((BytecodeCreator)ctx.constructor, ctx.classOutput, annotationClass, annotation, Types.getPackageName(ctx.clazzCreator.getClassName()))});
            }
        }
        ResultHandle parameterizedType = Types.getTypeHandle((BytecodeCreator)ctx.constructor, ctx.injectionPoint.getRequiredType());
        ResultHandle resourceProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(ResourceProvider.class, (Class[])new Class[]{Type.class, Set.class}), new ResultHandle[]{parameterizedType, annotations});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)InjectableReferenceProvider.class.getName()), ctx.constructor.getThis(), resourceProvider);
    }, ip -> ip.getKind() == InjectionPointInfo.InjectionPointKind.RESOURCE),
    EVENT_METADATA(DotNames.EVENT_METADATA, ctx -> {});

    private final DotName rawTypeDotName;
    private final Generator generator;
    private final Predicate<InjectionPointInfo> matcher;

    private BuiltinBean(DotName rawTypeDotName, Generator generator) {
        this(rawTypeDotName, generator, ip -> BuiltinBean.isCdiAndRawTypeMatches(ip, rawTypeDotName));
    }

    private BuiltinBean(DotName rawTypeDotName, Generator generator, Predicate<InjectionPointInfo> matcher) {
        this.rawTypeDotName = rawTypeDotName;
        this.generator = generator;
        this.matcher = matcher;
    }

    boolean matches(InjectionPointInfo injectionPoint) {
        return this.matcher.test(injectionPoint);
    }

    DotName getRawTypeDotName() {
        return this.rawTypeDotName;
    }

    Generator getGenerator() {
        return this.generator;
    }

    static boolean resolvesTo(InjectionPointInfo injectionPoint) {
        return BuiltinBean.resolve(injectionPoint) != null;
    }

    static BuiltinBean resolve(InjectionPointInfo injectionPoint) {
        for (BuiltinBean bean : BuiltinBean.values()) {
            if (!bean.matches(injectionPoint)) continue;
            return bean;
        }
        return null;
    }

    private static boolean isCdiAndRawTypeMatches(InjectionPointInfo injectionPoint, DotName rawTypeDotName) {
        if (injectionPoint.getKind() != InjectionPointInfo.InjectionPointKind.CDI) {
            return false;
        }
        return rawTypeDotName.equals((Object)injectionPoint.getRequiredType().name());
    }

    private static boolean isInstanceInjectionPoint(InjectionPointInfo injectionPoint) {
        if (injectionPoint.getKind() != InjectionPointInfo.InjectionPointKind.CDI) {
            return false;
        }
        return DotNames.INSTANCE.equals((Object)injectionPoint.getRequiredType().name()) || DotNames.PROVIDER.equals((Object)injectionPoint.getRequiredType().name());
    }

    @FunctionalInterface
    static interface Generator {
        public void generate(GeneratorContext var1);
    }

    public static class GeneratorContext {
        final ClassOutput classOutput;
        final BeanDeployment beanDeployment;
        final InjectionPointInfo injectionPoint;
        final ClassCreator clazzCreator;
        final MethodCreator constructor;
        final String providerName;
        final AnnotationLiteralProcessor annotationLiterals;
        final InjectionTargetInfo targetInfo;

        public GeneratorContext(ClassOutput classOutput, BeanDeployment beanDeployment, InjectionPointInfo injectionPoint, ClassCreator clazzCreator, MethodCreator constructor, String providerName, AnnotationLiteralProcessor annotationLiterals, InjectionTargetInfo targetInfo) {
            this.classOutput = classOutput;
            this.beanDeployment = beanDeployment;
            this.injectionPoint = injectionPoint;
            this.clazzCreator = clazzCreator;
            this.constructor = constructor;
            this.providerName = providerName;
            this.annotationLiterals = annotationLiterals;
            this.targetInfo = targetInfo;
        }
    }
}

