/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointModifier;
import io.quarkus.arc.processor.InterceptorInfo;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.DefinitionException;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;

final class Interceptors {
    private Interceptors() {
    }

    static InterceptorInfo createInterceptor(ClassInfo interceptorClass, BeanDeployment beanDeployment, InjectionPointModifier transformer, AnnotationStore store) {
        HashSet<AnnotationInstance> bindings = new HashSet<AnnotationInstance>();
        Integer priority = 0;
        for (AnnotationInstance annotation : store.getAnnotations((AnnotationTarget)interceptorClass)) {
            if (beanDeployment.getInterceptorBinding(annotation.name()) != null) {
                bindings.add(annotation);
                Set<AnnotationInstance> transitiveInterceptorBindings = beanDeployment.getTransitiveInterceptorBindings(annotation.name());
                if (transitiveInterceptorBindings == null) continue;
                bindings.addAll(transitiveInterceptorBindings);
                continue;
            }
            if (!annotation.name().equals((Object)DotNames.PRIORITY)) continue;
            priority = annotation.value().asInt();
        }
        if (bindings.isEmpty()) {
            throw new DefinitionException("Interceptor has no bindings: " + interceptorClass);
        }
        return new InterceptorInfo((AnnotationTarget)interceptorClass, beanDeployment, bindings, Injection.forBean((AnnotationTarget)interceptorClass, null, beanDeployment, transformer), priority);
    }
}

