/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.Arc;
import io.quarkus.arc.Components;
import io.quarkus.arc.ComponentsProvider;
import io.quarkus.arc.impl.LazyValue;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.ObserverInfo;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceImpl;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.objectweb.asm.Type;

public class ComponentsProviderGenerator
extends AbstractGenerator {
    static final String COMPONENTS_PROVIDER_SUFFIX = "_ComponentsProvider";
    static final String SETUP_PACKAGE = Arc.class.getPackage().getName() + ".setup";
    protected final AnnotationLiteralProcessor annotationLiterals;

    public ComponentsProviderGenerator(AnnotationLiteralProcessor annotationLiterals) {
        this.annotationLiterals = annotationLiterals;
    }

    Collection<ResourceOutput.Resource> generate(String name, BeanDeployment beanDeployment, Map<BeanInfo, String> beanToGeneratedName, Map<ObserverInfo, String> observerToGeneratedName) {
        ResourceClassOutput classOutput = new ResourceClassOutput(true);
        String generatedName = SETUP_PACKAGE + "." + name + COMPONENTS_PROVIDER_SUFFIX;
        ClassCreator componentsProvider = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).interfaces(new Class[]{ComponentsProvider.class}).build();
        MethodCreator getComponents = (MethodCreator)componentsProvider.getMethodCreator("getComponents", Components.class, new Class[0]).setModifiers(1);
        ResultHandle beanIdToBeanSupplierHandle = getComponents.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
        HashMap<BeanInfo, List<BeanInfo>> beanToInjections = new HashMap<BeanInfo, List<BeanInfo>>();
        for (BeanInfo bean : beanDeployment.getBeans()) {
            if (bean.isProducerMethod() || bean.isProducerField()) {
                beanToInjections.computeIfAbsent(bean.getDeclaringBean(), d -> new ArrayList()).add(bean);
            }
            for (Injection injection : bean.getInjections()) {
                for (InjectionPointInfo injectionPointInfo : injection.injectionPoints) {
                    if (BuiltinBean.resolvesTo(injectionPointInfo)) continue;
                    beanToInjections.computeIfAbsent(injectionPointInfo.getResolvedBean(), d -> new ArrayList()).add(bean);
                }
            }
            if (bean.getDisposer() != null) {
                for (InjectionPointInfo injectionPointInfo : bean.getDisposer().getInjection().injectionPoints) {
                    if (BuiltinBean.resolvesTo(injectionPointInfo)) continue;
                    beanToInjections.computeIfAbsent(injectionPointInfo.getResolvedBean(), d -> new ArrayList()).add(bean);
                }
            }
            for (InterceptorInfo interceptorInfo : bean.getBoundInterceptors()) {
                beanToInjections.computeIfAbsent(interceptorInfo, d -> new ArrayList()).add(bean);
            }
        }
        for (InterceptorInfo interceptor : beanDeployment.getInterceptors()) {
            for (Injection injection : interceptor.getInjections()) {
                for (InjectionPointInfo injectionPointInfo : injection.injectionPoints) {
                    if (BuiltinBean.resolvesTo(injectionPointInfo)) continue;
                    beanToInjections.computeIfAbsent(injectionPointInfo.getResolvedBean(), d -> new ArrayList()).add(interceptor);
                }
            }
        }
        HashMap<BeanInfo, LazyValue<ResultHandle>> beanToResultSupplierHandle = new HashMap<BeanInfo, LazyValue<ResultHandle>>();
        ArrayList<BeanInfo> processed = new ArrayList<BeanInfo>();
        boolean stuck = false;
        while (!beanToInjections.isEmpty()) {
            if (stuck) {
                throw new IllegalStateException("Circular dependencies not supported: \n" + beanToInjections.entrySet().stream().map(e -> "\t " + e.getKey() + " injected into: " + ((List)e.getValue()).stream().map(b -> b.getBeanClass().toString()).collect(Collectors.joining(", "))).collect(Collectors.joining("\n")));
            }
            stuck = true;
            stuck = this.addBeans(beanToInjections, processed, beanToResultSupplierHandle, getComponents, beanIdToBeanSupplierHandle, beanToGeneratedName, b -> !this.isDependency((BeanInfo)b, (Map<BeanInfo, List<BeanInfo>>)beanToInjections));
            if (!stuck || !(stuck = this.addBeans(beanToInjections, processed, beanToResultSupplierHandle, getComponents, beanIdToBeanSupplierHandle, beanToGeneratedName, b -> {
                if (b.isProducerField() || b.isProducerMethod()) {
                    return false;
                }
                return b.getScope().isNormal() || !this.isDependency((BeanInfo)b, (Map<BeanInfo, List<BeanInfo>>)beanToInjections);
            }))) continue;
            stuck = this.addBeans(beanToInjections, processed, beanToResultSupplierHandle, getComponents, beanIdToBeanSupplierHandle, beanToGeneratedName, b -> !this.isDependency((BeanInfo)b, (Map<BeanInfo, List<BeanInfo>>)beanToInjections) || b.getScope().isNormal());
        }
        for (BeanInfo beanInfo : beanDeployment.getBeans()) {
            if (processed.contains(beanInfo)) continue;
            this.addBean(getComponents, beanIdToBeanSupplierHandle, beanInfo, beanToGeneratedName, beanToResultSupplierHandle);
        }
        for (BeanInfo beanInfo : beanDeployment.getInterceptors()) {
            if (processed.contains(beanInfo)) continue;
            this.addBean(getComponents, beanIdToBeanSupplierHandle, beanInfo, beanToGeneratedName, beanToResultSupplierHandle);
        }
        ResultHandle resultHandle = getComponents.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (ObserverInfo observerInfo : beanDeployment.getObservers()) {
            String string = observerToGeneratedName.get(observerInfo);
            List list = observerInfo.getInjection().injectionPoints.stream().filter(ip -> !BuiltinBean.resolvesTo(ip)).collect(Collectors.toList());
            ArrayList<ResultHandle> params = new ArrayList<ResultHandle>();
            ArrayList<String> paramTypes = new ArrayList<String>();
            ResultHandle resultSupplierHandle = (ResultHandle)((LazyValue)beanToResultSupplierHandle.get(observerInfo.getDeclaringBean())).get();
            params.add(resultSupplierHandle);
            paramTypes.add(Type.getDescriptor(Supplier.class));
            for (InjectionPointInfo injectionPoint : list) {
                resultSupplierHandle = (ResultHandle)((LazyValue)beanToResultSupplierHandle.get(injectionPoint.getResolvedBean())).get();
                params.add(resultSupplierHandle);
                paramTypes.add(Type.getDescriptor(Supplier.class));
            }
            ResultHandle observerInstance = getComponents.newInstance(MethodDescriptor.ofConstructor((String)string, (String[])paramTypes.toArray(new String[0])), params.toArray(new ResultHandle[0]));
            getComponents.invokeInterfaceMethod(MethodDescriptors.LIST_ADD, resultHandle, new ResultHandle[]{observerInstance});
        }
        ResultHandle resultHandle2 = getComponents.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (Map.Entry<ScopeInfo, Function<MethodCreator, ResultHandle>> entry : beanDeployment.getCustomContexts().entrySet()) {
            ResultHandle resultHandle3 = entry.getValue().apply(getComponents);
            getComponents.invokeInterfaceMethod(MethodDescriptors.LIST_ADD, resultHandle2, new ResultHandle[]{resultHandle3});
        }
        ResultHandle resultHandle4 = getComponents.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (Map.Entry<DotName, Set<AnnotationInstance>> entry : beanDeployment.getTransitiveInterceptorBindings().entrySet()) {
            ResultHandle bindingsHandle = getComponents.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (AnnotationInstance binding : entry.getValue()) {
                ClassInfo bindingClass = beanDeployment.getInterceptorBinding(binding.name());
                getComponents.invokeInterfaceMethod(MethodDescriptors.SET_ADD, bindingsHandle, new ResultHandle[]{this.annotationLiterals.process((BytecodeCreator)getComponents, classOutput, bindingClass, binding, SETUP_PACKAGE)});
            }
            getComponents.invokeInterfaceMethod(MethodDescriptors.MAP_PUT, resultHandle4, new ResultHandle[]{getComponents.loadClass(entry.getKey().toString()), bindingsHandle});
        }
        ResultHandle resultHandle5 = getComponents.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.class, (String)"values", Collection.class, (Class[])new Class[0]), beanIdToBeanSupplierHandle, new ResultHandle[0]);
        ResultHandle resultHandle6 = getComponents.newInstance(MethodDescriptor.ofConstructor(Components.class, (Class[])new Class[]{Collection.class, Collection.class, Collection.class, Map.class}), new ResultHandle[]{resultHandle5, resultHandle, resultHandle2, resultHandle4});
        getComponents.returnValue(resultHandle6);
        componentsProvider.close();
        ArrayList<ResourceOutput.Resource> resources = new ArrayList<ResourceOutput.Resource>();
        for (ResourceOutput.Resource resource : classOutput.getResources()) {
            resources.add(resource);
            resources.add(ResourceImpl.serviceProvider(ComponentsProvider.class.getName(), resource.getName().replace('/', '.').getBytes(Charset.forName("UTF-8"))));
        }
        return resources;
    }

    private boolean addBeans(Map<BeanInfo, List<BeanInfo>> beanToInjections, List<BeanInfo> processed, Map<BeanInfo, LazyValue<ResultHandle>> beanToResultSupplierHandle, MethodCreator getComponents, ResultHandle beanIdToBeanSupplierHandle, Map<BeanInfo, String> beanToGeneratedName, Predicate<BeanInfo> filter) {
        boolean stuck = true;
        Iterator<Map.Entry<BeanInfo, List<BeanInfo>>> iterator = beanToInjections.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BeanInfo, List<BeanInfo>> entry = iterator.next();
            BeanInfo bean = entry.getKey();
            if (!filter.test(bean)) continue;
            this.addBean(getComponents, beanIdToBeanSupplierHandle, bean, beanToGeneratedName, beanToResultSupplierHandle);
            iterator.remove();
            processed.add(bean);
            stuck = false;
        }
        return stuck;
    }

    private void addBean(MethodCreator getComponents, ResultHandle beanIdToBeanSupplierHandle, BeanInfo bean, Map<BeanInfo, String> beanToGeneratedName, Map<BeanInfo, LazyValue<ResultHandle>> beanToResultSupplierHandle) {
        ResultHandle resultSupplierHandle;
        String beanType = beanToGeneratedName.get(bean);
        if (beanType == null) {
            throw new IllegalStateException("No bean type found for: " + bean);
        }
        List injectionPoints = bean.getInjections().stream().flatMap(i -> i.injectionPoints.stream()).filter(ip -> !BuiltinBean.resolvesTo(ip)).collect(Collectors.toList());
        ArrayList<ResultHandle> params = new ArrayList<ResultHandle>();
        ArrayList<String> paramTypes = new ArrayList<String>();
        if (bean.isProducerMethod() || bean.isProducerField()) {
            ResultHandle resultSupplierHandle2 = (ResultHandle)beanToResultSupplierHandle.get(bean.getDeclaringBean()).get();
            if (resultSupplierHandle2 == null) {
                throw new IllegalStateException("A supplier for a declaring bean of a producer bean is not available - most probaly an unsupported circular dependency use case \n - declaring bean: " + bean.getDeclaringBean() + "\n - producer bean: " + bean);
            }
            params.add(resultSupplierHandle2);
            paramTypes.add(Type.getDescriptor(Supplier.class));
        }
        for (InjectionPointInfo injectionPoint : injectionPoints) {
            ResultHandle beanIdHandle = getComponents.load(injectionPoint.getResolvedBean().getIdentifier());
            ResultHandle beanSupplierHandle = getComponents.newInstance(MethodDescriptors.MAP_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{beanIdToBeanSupplierHandle, beanIdHandle});
            params.add(beanSupplierHandle);
            paramTypes.add(Type.getDescriptor(Supplier.class));
        }
        if (bean.getDisposer() != null) {
            for (InjectionPointInfo injectionPoint : bean.getDisposer().getInjection().injectionPoints) {
                resultSupplierHandle = (ResultHandle)beanToResultSupplierHandle.get(injectionPoint.getResolvedBean()).get();
                params.add(resultSupplierHandle);
                paramTypes.add(Type.getDescriptor(Supplier.class));
            }
        }
        for (InterceptorInfo interceptor : bean.getBoundInterceptors()) {
            resultSupplierHandle = (ResultHandle)beanToResultSupplierHandle.get(interceptor).get();
            params.add(resultSupplierHandle);
            paramTypes.add(Type.getDescriptor(Supplier.class));
        }
        ResultHandle beanInstance = getComponents.newInstance(MethodDescriptor.ofConstructor((String)beanType, (String[])paramTypes.toArray(new String[0])), params.toArray(new ResultHandle[0]));
        ResultHandle beanInfoHandle = getComponents.load(bean.getIdentifier());
        getComponents.invokeInterfaceMethod(MethodDescriptors.MAP_PUT, beanIdToBeanSupplierHandle, new ResultHandle[]{beanInfoHandle, beanInstance});
        beanToResultSupplierHandle.put(bean, (LazyValue<ResultHandle>)new LazyValue(() -> getComponents.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{beanInstance})));
    }

    private boolean isDependency(BeanInfo bean, Map<BeanInfo, List<BeanInfo>> beanToInjections) {
        for (Map.Entry<BeanInfo, List<BeanInfo>> entry : beanToInjections.entrySet()) {
            if (!entry.getValue().contains(bean)) continue;
            return true;
        }
        return false;
    }
}

