/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.ArcUndeclaredThrowableException;
import io.quarkus.arc.InjectableInterceptor;
import io.quarkus.arc.Subclass;
import io.quarkus.arc.impl.SubclassMethodMetadata;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.Types;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InterceptionType;
import javax.interceptor.InvocationContext;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class SubclassGenerator
extends AbstractGenerator {
    private static final DotName JAVA_LANG_THROWABLE = DotNames.create(Throwable.class.getName());
    private static final DotName JAVA_LANG_EXCEPTION = DotNames.create(Exception.class.getName());
    private static final DotName JAVA_LANG_RUNTIME_EXCEPTION = DotNames.create(RuntimeException.class.getName());
    static final String SUBCLASS_SUFFIX = "_Subclass";
    static final String DESTROY_METHOD_NAME = "arc$destroy";
    protected static final String FIELD_NAME_PREDESTROYS = "preDestroys";
    protected static final String FIELD_NAME_METADATA = "metadata";
    protected static final FieldDescriptor FIELD_METADATA_METHOD = FieldDescriptor.of(SubclassMethodMetadata.class, (String)"method", Method.class);
    protected static final FieldDescriptor FIELD_METADATA_CHAIN = FieldDescriptor.of(SubclassMethodMetadata.class, (String)"chain", List.class);
    protected static final FieldDescriptor FIELD_METADATA_BINDINGS = FieldDescriptor.of(SubclassMethodMetadata.class, (String)"bindings", Set.class);
    private final Predicate<DotName> applicationClassPredicate;
    private final AnnotationLiteralProcessor annotationLiterals;

    static String generatedName(DotName providerTypeName, String baseName) {
        return DotNames.packageName(providerTypeName).replace('.', '/') + "/" + baseName + SUBCLASS_SUFFIX;
    }

    public SubclassGenerator(AnnotationLiteralProcessor annotationLiterals, Predicate<DotName> applicationClassPredicate) {
        this.applicationClassPredicate = applicationClassPredicate;
        this.annotationLiterals = annotationLiterals;
    }

    Collection<ResourceOutput.Resource> generate(BeanInfo bean, String beanClassName, ReflectionRegistration reflectionRegistration) {
        ResourceClassOutput classOutput = new ResourceClassOutput(this.applicationClassPredicate.test(bean.getBeanClass()));
        Type providerType = bean.getProviderType();
        ClassInfo providerClass = IndexClassLookupUtils.getClassByName(bean.getDeployment().getIndex(), providerType.name());
        String providerTypeName = providerClass.name().toString();
        String baseName = this.getBaseName(bean, beanClassName);
        String generatedName = SubclassGenerator.generatedName(providerType.name(), baseName);
        ClassCreator subclass = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).superClass(providerTypeName).interfaces(new Class[]{Subclass.class}).build();
        FieldDescriptor preDestroyField = this.createConstructor(classOutput, bean, subclass, providerTypeName, reflectionRegistration);
        this.createDestroy(classOutput, bean, subclass, preDestroyField);
        subclass.close();
        return classOutput.getResources();
    }

    protected FieldDescriptor createConstructor(ClassOutput classOutput, BeanInfo bean, ClassCreator subclass, String providerTypeName, ReflectionRegistration reflectionRegistration) {
        ArrayList<String> parameterTypes = new ArrayList<String>();
        Optional<Injection> constructorInjection = bean.getConstructorInjection();
        if (constructorInjection.isPresent()) {
            for (InjectionPointInfo injectionPoint : constructorInjection.get().injectionPoints) {
                parameterTypes.add(injectionPoint.getRequiredType().name().toString());
            }
        }
        int superParamsSize = parameterTypes.size();
        parameterTypes.add(CreationalContext.class.getName());
        List<InterceptorInfo> boundInterceptors = bean.getBoundInterceptors();
        for (int j = 0; j < boundInterceptors.size(); ++j) {
            parameterTypes.add(InjectableInterceptor.class.getName());
        }
        MethodCreator constructor = subclass.getMethodCreator("<init>", "V", parameterTypes.toArray(new String[0]));
        ResultHandle creationalContextHandle = constructor.getMethodParam(superParamsSize);
        ResultHandle[] superParams = new ResultHandle[superParamsSize];
        for (int j = 0; j < superParamsSize; ++j) {
            superParams[j] = constructor.getMethodParam(j);
        }
        constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor((String)providerTypeName, (String[])parameterTypes.subList(0, superParamsSize).toArray(new String[0])), constructor.getThis(), superParams);
        ResultHandle interceptorInstanceMap = constructor.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
        HashMap<InterceptorInfo, ResultHandle> interceptorToResultHandle = new HashMap<InterceptorInfo, ResultHandle>();
        for (int j = 0; j < boundInterceptors.size(); ++j) {
            ResultHandle constructorMethodParam = constructor.getMethodParam(j + superParamsSize + 1);
            interceptorToResultHandle.put(boundInterceptors.get(j), constructorMethodParam);
            ResultHandle creationalContext = constructor.invokeStaticMethod(MethodDescriptors.CREATIONAL_CTX_CHILD, new ResultHandle[]{creationalContextHandle});
            ResultHandle interceptorInstance = constructor.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, constructorMethodParam, new ResultHandle[]{creationalContext});
            ResultHandle idResultHandle = constructor.invokeInterfaceMethod(MethodDescriptors.GET_IDENTIFIER, constructorMethodParam, new ResultHandle[0]);
            constructor.invokeInterfaceMethod(MethodDescriptors.MAP_PUT, interceptorInstanceMap, new ResultHandle[]{idResultHandle, interceptorInstance});
        }
        FieldCreator preDestroysField = null;
        BeanInfo.InterceptionInfo preDestroys = bean.getLifecycleInterceptors(InterceptionType.PRE_DESTROY);
        if (!preDestroys.isEmpty()) {
            preDestroysField = (FieldCreator)subclass.getFieldCreator(FIELD_NAME_PREDESTROYS, DescriptorUtils.extToInt((String)ArrayList.class.getName())).setModifiers(18);
            constructor.writeInstanceField(preDestroysField.getFieldDescriptor(), constructor.getThis(), constructor.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]));
            for (InterceptorInfo interceptor : preDestroys.interceptors) {
                ResultHandle interceptorInstance = constructor.invokeInterfaceMethod(MethodDescriptors.MAP_GET, interceptorInstanceMap, new ResultHandle[]{constructor.invokeInterfaceMethod(MethodDescriptors.GET_IDENTIFIER, (ResultHandle)interceptorToResultHandle.get(interceptor), new ResultHandle[0])});
                ResultHandle interceptionInvocation = constructor.invokeStaticMethod(MethodDescriptors.INTERCEPTOR_INVOCATION_PRE_DESTROY, new ResultHandle[]{(ResultHandle)interceptorToResultHandle.get(interceptor), interceptorInstance});
                constructor.invokeInterfaceMethod(MethodDescriptors.LIST_ADD, constructor.readInstanceField(preDestroysField.getFieldDescriptor(), constructor.getThis()), new ResultHandle[]{interceptionInvocation});
            }
        }
        FieldCreator metadataField = (FieldCreator)subclass.getFieldCreator(FIELD_NAME_METADATA, Map.class.getName()).setModifiers(18);
        ResultHandle metadataHandle = constructor.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
        constructor.writeInstanceField(metadataField.getFieldDescriptor(), constructor.getThis(), metadataHandle);
        int methodIdx = 1;
        for (Map.Entry<MethodInfo, BeanInfo.InterceptionInfo> entry : bean.getInterceptedMethods().entrySet()) {
            String methodId = "m" + methodIdx++;
            MethodInfo method = entry.getKey();
            ResultHandle methodIdHandle = constructor.load(methodId);
            ResultHandle chainHandle = constructor.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
            BeanInfo.InterceptionInfo interceptedMethod = entry.getValue();
            for (InterceptorInfo interceptor : interceptedMethod.interceptors) {
                ResultHandle interceptorInstance = constructor.invokeInterfaceMethod(MethodDescriptors.MAP_GET, interceptorInstanceMap, new ResultHandle[]{constructor.invokeInterfaceMethod(MethodDescriptors.GET_IDENTIFIER, (ResultHandle)interceptorToResultHandle.get(interceptor), new ResultHandle[0])});
                ResultHandle interceptionInvocation = constructor.invokeStaticMethod(MethodDescriptors.INTERCEPTOR_INVOCATION_AROUND_INVOKE, new ResultHandle[]{(ResultHandle)interceptorToResultHandle.get(interceptor), interceptorInstance});
                constructor.invokeInterfaceMethod(MethodDescriptors.LIST_ADD, chainHandle, new ResultHandle[]{interceptionInvocation});
            }
            ResultHandle[] paramsHandles = new ResultHandle[3];
            paramsHandles[0] = constructor.loadClass(providerTypeName);
            paramsHandles[1] = constructor.load(method.name());
            if (!method.parameters().isEmpty()) {
                ResultHandle paramsArray = constructor.newArray(Class.class, constructor.load(method.parameters().size()));
                ListIterator iterator = method.parameters().listIterator();
                while (iterator.hasNext()) {
                    constructor.writeArrayValue(paramsArray, iterator.nextIndex(), constructor.loadClass(((Type)iterator.next()).name().toString()));
                }
                paramsHandles[2] = paramsArray;
            } else {
                paramsHandles[2] = constructor.newArray(Class.class, constructor.load(0));
            }
            ResultHandle methodHandle = constructor.invokeStaticMethod(MethodDescriptors.REFLECTIONS_FIND_METHOD, paramsHandles);
            ResultHandle bindingsHandle = constructor.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (AnnotationInstance binding : interceptedMethod.bindings) {
                ClassInfo bindingClass = bean.getDeployment().getInterceptorBinding(binding.name());
                constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, bindingsHandle, new ResultHandle[]{this.annotationLiterals.process((BytecodeCreator)constructor, classOutput, bindingClass, binding, Types.getPackageName(subclass.getClassName()))});
            }
            ResultHandle methodMetadataHandle = constructor.newInstance(MethodDescriptors.SUBCLASS_METHOD_METADATA_CONSTRUCTOR, new ResultHandle[]{chainHandle, methodHandle, bindingsHandle});
            constructor.invokeInterfaceMethod(MethodDescriptors.MAP_PUT, metadataHandle, new ResultHandle[]{methodIdHandle, methodMetadataHandle});
            reflectionRegistration.registerMethod(method);
            this.createForwardingMethod(classOutput, bean, method, methodId, subclass, providerTypeName, metadataField.getFieldDescriptor(), interceptedMethod);
        }
        constructor.returnValue(null);
        return preDestroysField != null ? preDestroysField.getFieldDescriptor() : null;
    }

    private void createForwardingMethod(ClassOutput classOutput, BeanInfo bean, MethodInfo method, String methodId, ClassCreator subclass, String providerTypeName, FieldDescriptor metadataField, BeanInfo.InterceptionInfo interceptedMethod) {
        MethodDescriptor originalMethodDescriptor = MethodDescriptor.of((MethodInfo)method);
        MethodCreator forwardMethod = subclass.getMethodCreator(originalMethodDescriptor);
        ResultHandle paramsHandle = forwardMethod.newArray(Object.class, forwardMethod.load(method.parameters().size()));
        for (int i = 0; i < method.parameters().size(); ++i) {
            forwardMethod.writeArrayValue(paramsHandle, i, forwardMethod.getMethodParam(i));
        }
        BytecodeCreator notConstructed = forwardMethod.ifNull(forwardMethod.readInstanceField(metadataField, forwardMethod.getThis())).trueBranch();
        ResultHandle[] params = new ResultHandle[method.parameters().size()];
        for (int i = 0; i < method.parameters().size(); ++i) {
            params[i] = notConstructed.getMethodParam(i);
        }
        if (Modifier.isAbstract(method.flags())) {
            notConstructed.throwException(IllegalStateException.class, "Cannot delegate to an abstract method");
        } else {
            MethodDescriptor superDescriptor = MethodDescriptor.ofMethod((Object)providerTypeName, (String)method.name(), (Object)method.returnType().name().toString(), (Object[])method.parameters().stream().map(p -> p.name().toString()).toArray());
            notConstructed.returnValue(notConstructed.invokeSpecialMethod(superDescriptor, notConstructed.getThis(), params));
        }
        FunctionCreator func = forwardMethod.createFunction(Function.class);
        BytecodeCreator funcBytecode = func.getBytecode();
        ResultHandle ctxHandle = funcBytecode.getMethodParam(0);
        ResultHandle[] superParamHandles = new ResultHandle[method.parameters().size()];
        ResultHandle ctxParamsHandle = funcBytecode.invokeInterfaceMethod(MethodDescriptor.ofMethod(InvocationContext.class, (String)"getParameters", Object[].class, (Class[])new Class[0]), ctxHandle, new ResultHandle[0]);
        for (int i = 0; i < superParamHandles.length; ++i) {
            superParamHandles[i] = funcBytecode.readArrayValue(ctxParamsHandle, i);
        }
        ResultHandle superResult = funcBytecode.invokeSpecialMethod(MethodDescriptor.ofMethod((String)providerTypeName, (String)method.name(), (String)method.returnType().name().toString(), (String[])method.parameters().stream().map(p -> p.name().toString()).collect(Collectors.toList()).toArray(new String[0])), forwardMethod.getThis(), superParamHandles);
        funcBytecode.returnValue(superResult != null ? superResult : funcBytecode.loadNull());
        for (Type declaredException : method.exceptions()) {
            forwardMethod.addException(declaredException.name().toString());
        }
        TryBlock tryCatch = forwardMethod.tryBlock();
        boolean addCatchRuntimeException = true;
        boolean addCatchException = true;
        for (Type declaredException : method.exceptions()) {
            CatchBlockCreator catchDeclaredException = tryCatch.addCatch(declaredException.name().toString());
            catchDeclaredException.throwException(catchDeclaredException.getCaughtException());
            if (JAVA_LANG_RUNTIME_EXCEPTION.equals((Object)declaredException.name()) || JAVA_LANG_THROWABLE.equals((Object)declaredException.name())) {
                addCatchRuntimeException = false;
            }
            if (!JAVA_LANG_EXCEPTION.equals((Object)declaredException.name()) && !JAVA_LANG_THROWABLE.equals((Object)declaredException.name())) continue;
            addCatchException = false;
        }
        if (addCatchRuntimeException) {
            CatchBlockCreator catchRuntimeException = tryCatch.addCatch(RuntimeException.class);
            catchRuntimeException.throwException(catchRuntimeException.getCaughtException());
        }
        if (addCatchException) {
            CatchBlockCreator catchOtherExceptions = tryCatch.addCatch(Exception.class);
            catchOtherExceptions.throwException(ArcUndeclaredThrowableException.class, "Error invoking subclass method", catchOtherExceptions.getCaughtException());
        }
        ResultHandle methodIdHandle = tryCatch.load(methodId);
        ResultHandle methodMetadataHandle = tryCatch.invokeInterfaceMethod(MethodDescriptors.MAP_GET, tryCatch.readInstanceField(metadataField, tryCatch.getThis()), new ResultHandle[]{methodIdHandle});
        ResultHandle ret = tryCatch.invokeStaticMethod(MethodDescriptors.INVOCATION_CONTEXTS_PERFORM_AROUND_INVOKE, new ResultHandle[]{tryCatch.getThis(), tryCatch.readInstanceField(FIELD_METADATA_METHOD, methodMetadataHandle), func.getInstance(), paramsHandle, tryCatch.readInstanceField(FIELD_METADATA_CHAIN, methodMetadataHandle), tryCatch.readInstanceField(FIELD_METADATA_BINDINGS, methodMetadataHandle)});
        tryCatch.returnValue((ResultHandle)(superResult != null ? ret : null));
    }

    protected void createDestroy(ClassOutput classOutput, BeanInfo bean, ClassCreator subclass, FieldDescriptor preDestroysField) {
        if (preDestroysField != null) {
            MethodCreator destroy = subclass.getMethodCreator(MethodDescriptor.ofMethod((Object)subclass.getClassName(), (String)DESTROY_METHOD_NAME, Void.TYPE, (Object[])new Object[0]));
            ResultHandle predestroysHandle = destroy.readInstanceField(preDestroysField, destroy.getThis());
            ResultHandle bindingsHandle = destroy.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (AnnotationInstance binding : bean.getLifecycleInterceptors((InterceptionType)InterceptionType.PRE_DESTROY).bindings) {
                ClassInfo bindingClass = bean.getDeployment().getInterceptorBinding(binding.name());
                destroy.invokeInterfaceMethod(MethodDescriptors.SET_ADD, bindingsHandle, new ResultHandle[]{this.annotationLiterals.process((BytecodeCreator)destroy, classOutput, bindingClass, binding, Types.getPackageName(subclass.getClassName()))});
            }
            TryBlock tryCatch = destroy.tryBlock();
            CatchBlockCreator exception = tryCatch.addCatch(Exception.class);
            exception.throwException(RuntimeException.class, "Error destroying subclass", exception.getCaughtException());
            ResultHandle invocationContext = tryCatch.invokeStaticMethod(MethodDescriptors.INVOCATION_CONTEXTS_PRE_DESTROY, new ResultHandle[]{tryCatch.getThis(), predestroysHandle, bindingsHandle});
            tryCatch.invokeInterfaceMethod(MethodDescriptors.INVOCATION_CONTEXT_PROCEED, invocationContext, new ResultHandle[0]);
            destroy.returnValue(null);
        }
    }
}

