/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanDeploymentValidator;
import io.quarkus.arc.processor.Beans;
import io.quarkus.arc.processor.BuiltinQualifier;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DisposerInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Hashes;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InjectionTargetInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.Methods;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.arc.processor.StereotypeInfo;
import io.quarkus.arc.processor.Types;
import io.quarkus.gizmo.MethodCreator;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.InterceptionType;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class BeanInfo
implements InjectionTargetInfo {
    private final String identifier;
    private final ClassInfo implClazz;
    private final Type providerType;
    private final Optional<AnnotationTarget> target;
    private final BeanDeployment beanDeployment;
    private final ScopeInfo scope;
    private final Set<Type> types;
    private final Set<AnnotationInstance> qualifiers;
    private final List<Injection> injections;
    private final BeanInfo declaringBean;
    private final DisposerInfo disposer;
    private final Map<MethodInfo, InterceptionInfo> interceptedMethods;
    private final Map<InterceptionType, InterceptionInfo> lifecycleInterceptors;
    private final Integer alternativePriority;
    private final List<StereotypeInfo> stereotypes;
    private final String name;
    private final boolean isDefaultBean;
    private final Consumer<MethodCreator> creatorConsumer;
    private final Consumer<MethodCreator> destroyerConsumer;
    private final Map<String, Object> params;

    BeanInfo(AnnotationTarget target, BeanDeployment beanDeployment, ScopeInfo scope, Set<Type> types, Set<AnnotationInstance> qualifiers, List<Injection> injections, BeanInfo declaringBean, DisposerInfo disposer, Integer alternativePriority, List<StereotypeInfo> stereotypes, String name, boolean isDefaultBean) {
        this(null, null, target, beanDeployment, scope, types, qualifiers, injections, declaringBean, disposer, alternativePriority, stereotypes, name, isDefaultBean, null, null, Collections.emptyMap());
    }

    BeanInfo(ClassInfo implClazz, Type providerType, AnnotationTarget target, BeanDeployment beanDeployment, ScopeInfo scope, Set<Type> types, Set<AnnotationInstance> qualifiers, List<Injection> injections, BeanInfo declaringBean, DisposerInfo disposer, Integer alternativePriority, List<StereotypeInfo> stereotypes, String name, boolean isDefaultBean, Consumer<MethodCreator> creatorConsumer, Consumer<MethodCreator> destroyerConsumer, Map<String, Object> params) {
        this.target = Optional.ofNullable(target);
        if (implClazz == null && target != null) {
            implClazz = this.initImplClazz(target, beanDeployment);
        }
        this.implClazz = implClazz;
        if (providerType == null) {
            providerType = this.initProviderType(target, implClazz);
        }
        this.providerType = providerType;
        this.beanDeployment = beanDeployment;
        this.scope = scope != null ? scope : BuiltinScope.DEPENDENT.getInfo();
        this.types = types;
        for (Type type : types) {
            Beans.analyzeType(type, beanDeployment);
        }
        if (qualifiers.isEmpty() || qualifiers.size() <= 2 && qualifiers.stream().allMatch(a -> DotNames.NAMED.equals((Object)a.name()) || DotNames.ANY.equals((Object)a.name()))) {
            qualifiers.add(BuiltinQualifier.DEFAULT.getInstance());
        }
        qualifiers.add(BuiltinQualifier.ANY.getInstance());
        this.qualifiers = qualifiers;
        this.injections = injections;
        this.declaringBean = declaringBean;
        this.disposer = disposer;
        this.alternativePriority = alternativePriority;
        this.stereotypes = stereotypes;
        this.name = name;
        this.isDefaultBean = isDefaultBean;
        this.creatorConsumer = creatorConsumer;
        this.destroyerConsumer = destroyerConsumer;
        this.params = params;
        this.identifier = Hashes.sha1(this.toString());
        this.interceptedMethods = new ConcurrentHashMap<MethodInfo, InterceptionInfo>();
        this.lifecycleInterceptors = new ConcurrentHashMap<InterceptionType, InterceptionInfo>();
    }

    @Override
    public InjectionTargetInfo.TargetKind kind() {
        return InjectionTargetInfo.TargetKind.BEAN;
    }

    @Override
    public BeanInfo asBean() {
        return this;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Optional<AnnotationTarget> getTarget() {
        return this.target;
    }

    public ClassInfo getImplClazz() {
        return this.implClazz;
    }

    public boolean isClassBean() {
        return this.target.isPresent() && AnnotationTarget.Kind.CLASS.equals((Object)this.target.get().kind());
    }

    public boolean isProducerMethod() {
        return this.target.isPresent() && AnnotationTarget.Kind.METHOD.equals((Object)this.target.get().kind());
    }

    public boolean isProducerField() {
        return this.target.isPresent() && AnnotationTarget.Kind.FIELD.equals((Object)this.target.get().kind());
    }

    public boolean isSynthetic() {
        return !this.target.isPresent();
    }

    public DotName getBeanClass() {
        if (this.declaringBean != null) {
            return this.declaringBean.implClazz.name();
        }
        return this.implClazz.name();
    }

    public boolean isInterceptor() {
        return false;
    }

    public BeanInfo getDeclaringBean() {
        return this.declaringBean;
    }

    BeanDeployment getDeployment() {
        return this.beanDeployment;
    }

    Type getProviderType() {
        return this.providerType;
    }

    public ScopeInfo getScope() {
        return this.scope;
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public boolean hasType(DotName typeName) {
        for (Type type : this.types) {
            if (!type.name().equals((Object)typeName)) continue;
            return true;
        }
        return false;
    }

    public Set<AnnotationInstance> getQualifiers() {
        return this.qualifiers;
    }

    public boolean hasDefaultQualifiers() {
        return this.qualifiers.size() == 2 && this.qualifiers.contains(BuiltinQualifier.DEFAULT.getInstance()) && this.qualifiers.contains(BuiltinQualifier.ANY.getInstance());
    }

    List<Injection> getInjections() {
        return this.injections;
    }

    public List<InjectionPointInfo> getAllInjectionPoints() {
        if (this.injections.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<InjectionPointInfo> injectionPoints = new ArrayList<InjectionPointInfo>();
        for (Injection injection : this.injections) {
            injectionPoints.addAll(injection.injectionPoints);
        }
        return injectionPoints;
    }

    Optional<Injection> getConstructorInjection() {
        return this.injections.isEmpty() ? Optional.empty() : this.injections.stream().filter(Injection::isConstructor).findAny();
    }

    Map<MethodInfo, InterceptionInfo> getInterceptedMethods() {
        return this.interceptedMethods;
    }

    InterceptionInfo getLifecycleInterceptors(InterceptionType interceptionType) {
        return this.lifecycleInterceptors.containsKey(interceptionType) ? this.lifecycleInterceptors.get(interceptionType) : InterceptionInfo.EMPTY;
    }

    public boolean hasLifecycleInterceptors() {
        return !this.lifecycleInterceptors.isEmpty();
    }

    boolean isSubclassRequired() {
        return !this.interceptedMethods.isEmpty() || this.lifecycleInterceptors.containsKey(InterceptionType.PRE_DESTROY);
    }

    boolean hasDefaultDestroy() {
        if (this.isInterceptor()) {
            return true;
        }
        if (this.isClassBean()) {
            return this.getLifecycleInterceptors(InterceptionType.PRE_DESTROY).isEmpty() && Beans.getCallbacks(this.target.get().asClass(), DotNames.PRE_DESTROY, this.beanDeployment.getIndex()).isEmpty();
        }
        return this.disposer == null;
    }

    List<InterceptorInfo> getBoundInterceptors() {
        if (this.lifecycleInterceptors.isEmpty() && this.interceptedMethods.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<InterceptorInfo> bound = new ArrayList<InterceptorInfo>();
        for (InterceptionInfo interception : this.lifecycleInterceptors.values()) {
            for (InterceptorInfo interceptor : interception.interceptors) {
                if (bound.contains(interceptor)) continue;
                bound.add(interceptor);
            }
        }
        for (InterceptionInfo interception : this.interceptedMethods.values()) {
            for (InterceptorInfo interceptor : interception.interceptors) {
                if (bound.contains(interceptor)) continue;
                bound.add(interceptor);
            }
        }
        Collections.sort(bound);
        return bound;
    }

    public DisposerInfo getDisposer() {
        return this.disposer;
    }

    public boolean isAlternative() {
        return this.alternativePriority != null;
    }

    public Integer getAlternativePriority() {
        return this.alternativePriority;
    }

    public List<StereotypeInfo> getStereotypes() {
        return this.stereotypes;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDefaultBean() {
        return this.isDefaultBean;
    }

    Consumer<MethodCreator> getCreatorConsumer() {
        return this.creatorConsumer;
    }

    Consumer<MethodCreator> getDestroyerConsumer() {
        return this.destroyerConsumer;
    }

    Map<String, Object> getParams() {
        return this.params;
    }

    void validate(List<Throwable> errors, List<BeanDeploymentValidator> validators) {
        ClassInfo returnTypeClass;
        if (this.isClassBean()) {
            String classifier;
            ClassInfo beanClass = this.target.get().asClass();
            String string = classifier = this.scope.isNormal() ? "Normal scoped" : null;
            if (classifier == null && this.isSubclassRequired()) {
                classifier = "Intercepted";
            }
            if (Modifier.isFinal(beanClass.flags()) && classifier != null) {
                errors.add((Throwable)new DefinitionException(String.format("%s bean must not be final: %s", classifier, this)));
            }
            MethodInfo noArgsConstructor = beanClass.method("<init>", new Type[0]);
            if (!BeanDeploymentValidator.ValidationRule.NO_ARGS_CONSTRUCTOR.skipFor(validators, this) && this.scope.isNormal() && noArgsConstructor == null) {
                errors.add((Throwable)new DefinitionException(String.format("Normal scoped beans must declare a non-private constructor with no parameters: %s", this)));
            }
            if (noArgsConstructor != null && Modifier.isPrivate(noArgsConstructor.flags()) && classifier != null) {
                errors.add((Throwable)new DefinitionException(String.format("%s bean is not proxyable because it has a private no-args constructor: %s. To fix this problem, change the constructor to be package-private", classifier, this)));
            }
        } else if ((this.isProducerField() || this.isProducerMethod()) && (returnTypeClass = IndexClassLookupUtils.getClassByName(this.beanDeployment.getIndex(), (this.isProducerMethod() ? this.target.get().asMethod().returnType() : this.target.get().asField().type()).name())) != null && this.scope.isNormal() && !Modifier.isInterface(returnTypeClass.flags())) {
            String methodOrField = this.isProducerMethod() ? "method" : "field";
            String classifier = "Producer " + methodOrField + " for a normal scoped bean";
            if (Modifier.isFinal(returnTypeClass.flags())) {
                errors.add((Throwable)new DefinitionException(String.format("%s must not have a return type that is final: %s", classifier, this)));
            }
            MethodInfo noArgsConstructor = returnTypeClass.method("<init>", new Type[0]);
            if (!BeanDeploymentValidator.ValidationRule.NO_ARGS_CONSTRUCTOR.skipFor(validators, this) && noArgsConstructor == null) {
                errors.add((Throwable)new DefinitionException(String.format("Return type of a producer " + methodOrField + " for normal scoped beans must declare a non-private constructor with no parameters: %s", this)));
            }
            if (noArgsConstructor != null && Modifier.isPrivate(noArgsConstructor.flags())) {
                errors.add((Throwable)new DefinitionException(String.format("%s is not proxyable because it has a private no-args constructor: %s.", classifier, this)));
            }
        }
    }

    void init(List<Throwable> errors) {
        for (Injection injection : this.injections) {
            for (InjectionPointInfo injectionPoint : injection.injectionPoints) {
                Beans.resolveInjectionPoint(this.beanDeployment, this, injectionPoint, errors);
            }
        }
        if (this.disposer != null) {
            this.disposer.init(errors);
        }
        this.interceptedMethods.putAll(this.initInterceptedMethods(errors));
        if (errors.isEmpty()) {
            this.lifecycleInterceptors.putAll(this.initLifecycleInterceptors());
        }
    }

    protected String getType() {
        if (this.isProducerMethod()) {
            return "PRODUCER METHOD";
        }
        if (this.isProducerField()) {
            return "PRODUCER FIELD";
        }
        if (this.isSynthetic()) {
            return "SYNTHETIC";
        }
        return this.target.get().kind().toString();
    }

    private Map<MethodInfo, InterceptionInfo> initInterceptedMethods(List<Throwable> errors) {
        if (!this.isInterceptor() && this.isClassBean()) {
            Set<MethodInfo> finalMethods;
            HashMap<MethodInfo, InterceptionInfo> interceptedMethods = new HashMap<MethodInfo, InterceptionInfo>();
            HashMap<Methods.MethodKey, Set<AnnotationInstance>> candidates = new HashMap<Methods.MethodKey, Set<AnnotationInstance>>();
            ArrayList<AnnotationInstance> classLevelBindings = new ArrayList<AnnotationInstance>();
            this.addClassLevelBindings(this.target.get().asClass(), classLevelBindings);
            if (!this.stereotypes.isEmpty()) {
                for (StereotypeInfo stereotype : this.stereotypes) {
                    this.addClassLevelBindings(stereotype.getTarget(), classLevelBindings);
                }
            }
            if (!(finalMethods = Methods.addInterceptedMethodCandidates(this.beanDeployment, this.target.get().asClass(), candidates, classLevelBindings)).isEmpty()) {
                errors.add((Throwable)new DeploymentException(String.format("Intercepted methods of the bean %s may not be declared final:\n\t- %s", this.getBeanClass(), finalMethods.stream().map(Object::toString).sorted().collect(Collectors.joining("\n\t- ")))));
                return Collections.emptyMap();
            }
            for (Map.Entry entry : candidates.entrySet()) {
                List<InterceptorInfo> interceptors = this.beanDeployment.getInterceptorResolver().resolve(InterceptionType.AROUND_INVOKE, (Set)entry.getValue());
                if (interceptors.isEmpty()) continue;
                interceptedMethods.put(((Methods.MethodKey)entry.getKey()).method, new InterceptionInfo(interceptors, (Set)entry.getValue()));
            }
            return interceptedMethods;
        }
        return Collections.emptyMap();
    }

    private Map<InterceptionType, InterceptionInfo> initLifecycleInterceptors() {
        if (!this.isInterceptor() && this.isClassBean()) {
            HashMap<InterceptionType, InterceptionInfo> lifecycleInterceptors = new HashMap<InterceptionType, InterceptionInfo>();
            HashSet<AnnotationInstance> classLevelBindings = new HashSet<AnnotationInstance>();
            HashSet<AnnotationInstance> constructorLevelBindings = new HashSet<AnnotationInstance>();
            this.addClassLevelBindings(this.target.get().asClass(), classLevelBindings);
            this.addConstructorLevelBindings(this.target.get().asClass(), constructorLevelBindings);
            this.putLifecycleInterceptors(lifecycleInterceptors, classLevelBindings, InterceptionType.POST_CONSTRUCT);
            this.putLifecycleInterceptors(lifecycleInterceptors, classLevelBindings, InterceptionType.PRE_DESTROY);
            constructorLevelBindings.addAll(classLevelBindings);
            this.putLifecycleInterceptors(lifecycleInterceptors, constructorLevelBindings, InterceptionType.AROUND_CONSTRUCT);
            return lifecycleInterceptors;
        }
        return Collections.emptyMap();
    }

    private void putLifecycleInterceptors(Map<InterceptionType, InterceptionInfo> lifecycleInterceptors, Set<AnnotationInstance> classLevelBindings, InterceptionType interceptionType) {
        List<InterceptorInfo> interceptors = this.beanDeployment.getInterceptorResolver().resolve(interceptionType, classLevelBindings);
        if (!interceptors.isEmpty()) {
            lifecycleInterceptors.put(interceptionType, new InterceptionInfo(interceptors, classLevelBindings));
        }
    }

    private void addClassLevelBindings(ClassInfo classInfo, Collection<AnnotationInstance> bindings) {
        ClassInfo superClass;
        this.beanDeployment.getAnnotations((AnnotationTarget)classInfo).stream().filter(a -> this.beanDeployment.getInterceptorBinding(a.name()) != null && bindings.stream().noneMatch(e -> e.name().equals((Object)a.name()))).forEach(a -> bindings.add((AnnotationInstance)a));
        if (classInfo.superClassType() != null && !classInfo.superClassType().name().equals((Object)DotNames.OBJECT) && (superClass = IndexClassLookupUtils.getClassByName(this.beanDeployment.getIndex(), classInfo.superName())) != null) {
            this.addClassLevelBindings(superClass, bindings);
        }
    }

    private void addConstructorLevelBindings(ClassInfo classInfo, Collection<AnnotationInstance> bindings) {
        Optional<Injection> constructorWithInject = this.getConstructorInjection();
        MethodInfo constructor = constructorWithInject.isPresent() ? constructorWithInject.get().target.asMethod() : classInfo.method("<init>", new Type[0]);
        if (constructor != null) {
            this.beanDeployment.getAnnotations((AnnotationTarget)constructor).stream().filter(a -> this.beanDeployment.getInterceptorBinding(a.name()) != null && bindings.stream().noneMatch(e -> e.name().equals((Object)a.name()))).forEach(a -> bindings.add((AnnotationInstance)a));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getType());
        builder.append(" bean [types=");
        builder.append(this.types);
        builder.append(", qualifiers=");
        builder.append(this.qualifiers);
        builder.append(", target=");
        builder.append(this.target.isPresent() ? this.target.get() : "n/a");
        if (this.declaringBean != null) {
            builder.append(", declaringBean=");
            builder.append(this.declaringBean.target.isPresent() ? this.declaringBean.target.get() : "n/a");
        }
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BeanInfo other = (BeanInfo)obj;
        return Objects.equals(this.identifier, other.identifier);
    }

    private Type initProviderType(AnnotationTarget target, ClassInfo implClazz) {
        if (target != null) {
            switch (target.kind()) {
                case CLASS: {
                    return Types.getProviderType(target.asClass());
                }
                case FIELD: {
                    return target.asField().type();
                }
                case METHOD: {
                    return target.asMethod().returnType();
                }
            }
        } else if (implClazz != null) {
            return Type.create((DotName)implClazz.name(), (Type.Kind)Type.Kind.CLASS);
        }
        throw new IllegalStateException("Cannot infer the provider type");
    }

    private ClassInfo initImplClazz(AnnotationTarget target, BeanDeployment beanDeployment) {
        switch (target.kind()) {
            case CLASS: {
                return target.asClass();
            }
            case FIELD: {
                Type fieldType = target.asField().type();
                if (fieldType.kind() == Type.Kind.PRIMITIVE || fieldType.kind() == Type.Kind.ARRAY) break;
                return IndexClassLookupUtils.getClassByName(beanDeployment.getIndex(), fieldType.name());
            }
            case METHOD: {
                Type returnType = target.asMethod().returnType();
                if (returnType.kind() == Type.Kind.PRIMITIVE || returnType.kind() == Type.Kind.ARRAY) break;
                return IndexClassLookupUtils.getClassByName(beanDeployment.getIndex(), returnType.name());
            }
        }
        return null;
    }

    static class Builder {
        private ClassInfo implClazz;
        private Type providerType;
        private AnnotationTarget target;
        private BeanDeployment beanDeployment;
        private ScopeInfo scope;
        private Set<Type> types;
        private Set<AnnotationInstance> qualifiers;
        private List<Injection> injections = Collections.emptyList();
        private BeanInfo declaringBean;
        private DisposerInfo disposer;
        private Integer alternativePriority;
        private List<StereotypeInfo> stereotypes = Collections.emptyList();
        private String name;
        private boolean isDefaultBean;
        private Consumer<MethodCreator> creatorConsumer;
        private Consumer<MethodCreator> destroyerConsumer;
        private Map<String, Object> params;

        Builder() {
        }

        Builder implClazz(ClassInfo implClazz) {
            this.implClazz = implClazz;
            return this;
        }

        Builder providerType(Type providerType) {
            this.providerType = providerType;
            return this;
        }

        Builder beanDeployment(BeanDeployment beanDeployment) {
            this.beanDeployment = beanDeployment;
            return this;
        }

        Builder target(AnnotationTarget target) {
            this.target = target;
            return this;
        }

        Builder scope(ScopeInfo scope) {
            this.scope = scope;
            return this;
        }

        Builder types(Set<Type> types) {
            this.types = types;
            return this;
        }

        Builder qualifiers(Set<AnnotationInstance> qualifiers) {
            this.qualifiers = qualifiers;
            return this;
        }

        Builder injections(List<Injection> injections) {
            this.injections = injections;
            return this;
        }

        Builder declaringBean(BeanInfo declaringBean) {
            this.declaringBean = declaringBean;
            return this;
        }

        Builder disposer(DisposerInfo disposer) {
            this.disposer = disposer;
            return this;
        }

        Builder alternativePriority(Integer alternativePriority) {
            this.alternativePriority = alternativePriority;
            return this;
        }

        Builder stereotypes(List<StereotypeInfo> stereotypes) {
            this.stereotypes = stereotypes;
            return this;
        }

        Builder name(String name) {
            this.name = name;
            return this;
        }

        Builder defaultBean(boolean isDefaultBean) {
            this.isDefaultBean = isDefaultBean;
            return this;
        }

        Builder creator(Consumer<MethodCreator> creatorConsumer) {
            this.creatorConsumer = creatorConsumer;
            return this;
        }

        Builder destroyer(Consumer<MethodCreator> destroyerConsumer) {
            this.destroyerConsumer = destroyerConsumer;
            return this;
        }

        Builder params(Map<String, Object> params) {
            this.params = params;
            return this;
        }

        BeanInfo build() {
            return new BeanInfo(this.implClazz, this.providerType, this.target, this.beanDeployment, this.scope, this.types, this.qualifiers, this.injections, this.declaringBean, this.disposer, this.alternativePriority, this.stereotypes, this.name, this.isDefaultBean, this.creatorConsumer, this.destroyerConsumer, this.params);
        }
    }

    static class InterceptionInfo {
        static final InterceptionInfo EMPTY = new InterceptionInfo(Collections.emptyList(), Collections.emptySet());
        final List<InterceptorInfo> interceptors;
        final Set<AnnotationInstance> bindings;

        InterceptionInfo(List<InterceptorInfo> interceptors, Set<AnnotationInstance> bindings) {
            this.interceptors = interceptors;
            this.bindings = bindings;
        }

        boolean isEmpty() {
            return this.interceptors.isEmpty();
        }
    }
}

