/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.InjectionPointsTransformer;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.Type;

public class InjectionPointModifier {
    private List<InjectionPointsTransformer> transformers;
    private BuildExtension.BuildContext buildContext;
    private AnnotationStore annotationStore;

    InjectionPointModifier(List<InjectionPointsTransformer> transformers, BuildExtension.BuildContext buildContext) {
        this.buildContext = buildContext;
        this.transformers = transformers;
        this.annotationStore = buildContext != null ? buildContext.get(BuildExtension.Key.ANNOTATION_STORE) : null;
    }

    public Set<AnnotationInstance> applyTransformers(Type type, AnnotationTarget target, Set<AnnotationInstance> qualifiers) {
        if (this.transformers.isEmpty()) {
            return qualifiers;
        }
        TransformationContextImpl transformationContext = new TransformationContextImpl(target, qualifiers, this.annotationStore);
        for (InjectionPointsTransformer transformer : this.transformers) {
            if (!transformer.appliesTo(type)) continue;
            transformer.transform(transformationContext);
        }
        return transformationContext.getQualifiers();
    }

    class TransformationContextImpl
    implements InjectionPointsTransformer.TransformationContext {
        private AnnotationTarget target;
        private Set<AnnotationInstance> qualifiers;
        private AnnotationStore annotationStore;

        TransformationContextImpl(AnnotationTarget target, Set<AnnotationInstance> qualifiers, AnnotationStore annotationStore) {
            this.target = target;
            this.qualifiers = qualifiers;
            this.annotationStore = annotationStore;
        }

        @Override
        public AnnotationTarget getTarget() {
            return this.target;
        }

        public Set<AnnotationInstance> getQualifiers() {
            return this.qualifiers;
        }

        @Override
        public Collection<AnnotationInstance> getAllAnnotations() {
            if (this.annotationStore == null) {
                throw new IllegalStateException("Attempted to use TransformationContext#getAllAnnotations but AnnotationStore wasn't initialized.");
            }
            return this.annotationStore.getAnnotations(this.getTarget());
        }

        @Override
        public InjectionPointsTransformer.Transformation transform() {
            return new InjectionPointsTransformer.Transformation(this);
        }

        @Override
        public <V> V get(BuildExtension.Key<V> key) {
            return InjectionPointModifier.this.buildContext.get(key);
        }

        @Override
        public <V> V put(BuildExtension.Key<V> key, V value) {
            return InjectionPointModifier.this.buildContext.put(key, value);
        }

        public void setQualifiers(Set<AnnotationInstance> qualifiers) {
            this.qualifiers = qualifiers;
        }
    }
}

