/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.impl.GenericArrayTypeImpl;
import io.quarkus.arc.impl.ParameterizedTypeImpl;
import io.quarkus.arc.impl.TypeVariableImpl;
import io.quarkus.arc.impl.WildcardTypeImpl;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.logging.Logger;

final class Types {
    static final Logger LOGGER = Logger.getLogger(Types.class);
    private static final org.jboss.jandex.Type OBJECT_TYPE = org.jboss.jandex.Type.create((DotName)DotNames.OBJECT, (Type.Kind)Type.Kind.CLASS);

    private Types() {
    }

    static ResultHandle getTypeHandle(BytecodeCreator creator, org.jboss.jandex.Type type) {
        if (Type.Kind.CLASS.equals((Object)type.kind())) {
            String className = type.asClassType().name().toString();
            return Types.doLoadClass(creator, className);
        }
        if (Type.Kind.TYPE_VARIABLE.equals((Object)type.kind())) {
            ResultHandle boundsHandle;
            TypeVariable typeVariable = type.asTypeVariable();
            List bounds = typeVariable.bounds();
            if (bounds.isEmpty()) {
                boundsHandle = creator.newArray(Type.class, creator.load(0));
            } else {
                boundsHandle = creator.newArray(Type.class, creator.load(bounds.size()));
                for (int i = 0; i < bounds.size(); ++i) {
                    creator.writeArrayValue(boundsHandle, i, Types.getTypeHandle(creator, (org.jboss.jandex.Type)bounds.get(i)));
                }
            }
            return creator.newInstance(MethodDescriptor.ofConstructor(TypeVariableImpl.class, (Class[])new Class[]{String.class, Type[].class}), new ResultHandle[]{creator.load(typeVariable.identifier()), boundsHandle});
        }
        if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)type.kind())) {
            ParameterizedType parameterizedType = type.asParameterizedType();
            List arguments = parameterizedType.arguments();
            ResultHandle typeArgsHandle = creator.newArray(Type.class, creator.load(arguments.size()));
            for (int i = 0; i < arguments.size(); ++i) {
                creator.writeArrayValue(typeArgsHandle, i, Types.getTypeHandle(creator, (org.jboss.jandex.Type)arguments.get(i)));
            }
            return creator.newInstance(MethodDescriptor.ofConstructor(ParameterizedTypeImpl.class, (Class[])new Class[]{Type.class, Type[].class}), new ResultHandle[]{Types.doLoadClass(creator, parameterizedType.name().toString()), typeArgsHandle});
        }
        if (Type.Kind.ARRAY.equals((Object)type.kind())) {
            org.jboss.jandex.Type componentType = type.asArrayType().component();
            return creator.newInstance(MethodDescriptor.ofConstructor(GenericArrayTypeImpl.class, (Class[])new Class[]{Type.class}), new ResultHandle[]{Types.getTypeHandle(creator, componentType)});
        }
        if (Type.Kind.WILDCARD_TYPE.equals((Object)type.kind())) {
            org.jboss.jandex.WildcardType wildcardType = type.asWildcardType();
            if (wildcardType.superBound() == null) {
                return creator.invokeStaticMethod(MethodDescriptor.ofMethod(WildcardTypeImpl.class, (String)"withUpperBound", WildcardType.class, (Class[])new Class[]{Type.class}), new ResultHandle[]{Types.getTypeHandle(creator, wildcardType.extendsBound())});
            }
            return creator.invokeStaticMethod(MethodDescriptor.ofMethod(WildcardTypeImpl.class, (String)"withLowerBound", WildcardType.class, (Class[])new Class[]{Type.class}), new ResultHandle[]{Types.getTypeHandle(creator, wildcardType.superBound())});
        }
        if (Type.Kind.PRIMITIVE.equals((Object)type.kind())) {
            switch (type.asPrimitiveType().primitive()) {
                case INT: {
                    return creator.loadClass(Integer.TYPE);
                }
                case LONG: {
                    return creator.loadClass(Long.TYPE);
                }
                case BOOLEAN: {
                    return creator.loadClass(Boolean.TYPE);
                }
                case BYTE: {
                    return creator.loadClass(Byte.TYPE);
                }
                case CHAR: {
                    return creator.loadClass(Character.TYPE);
                }
                case DOUBLE: {
                    return creator.loadClass(Double.TYPE);
                }
                case FLOAT: {
                    return creator.loadClass(Float.TYPE);
                }
                case SHORT: {
                    return creator.loadClass(Short.TYPE);
                }
            }
            throw new IllegalArgumentException("Unsupported primitive type: " + type);
        }
        throw new IllegalArgumentException("Unsupported bean type: " + type.kind() + ", " + type);
    }

    private static ResultHandle doLoadClass(BytecodeCreator creator, String className) {
        ResultHandle currentThread = creator.invokeStaticMethod(MethodDescriptor.ofMethod(Thread.class, (String)"currentThread", Thread.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle tccl = creator.invokeVirtualMethod(MethodDescriptor.ofMethod(Thread.class, (String)"getContextClassLoader", ClassLoader.class, (Class[])new Class[0]), currentThread, new ResultHandle[0]);
        return creator.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{creator.load(className), creator.load(true), tccl});
    }

    static org.jboss.jandex.Type getProviderType(ClassInfo classInfo) {
        List typeParameters = classInfo.typeParameters();
        if (!typeParameters.isEmpty()) {
            return ParameterizedType.create((DotName)classInfo.name(), (org.jboss.jandex.Type[])typeParameters.toArray(new org.jboss.jandex.Type[0]), null);
        }
        return org.jboss.jandex.Type.create((DotName)classInfo.name(), (Type.Kind)Type.Kind.CLASS);
    }

    static Set<org.jboss.jandex.Type> getProducerMethodTypeClosure(MethodInfo producerMethod, BeanDeployment beanDeployment) {
        Set<org.jboss.jandex.Type> types;
        org.jboss.jandex.Type returnType = producerMethod.returnType();
        if (returnType.kind() == Type.Kind.PRIMITIVE || returnType.kind() == Type.Kind.ARRAY) {
            HashSet<org.jboss.jandex.Type> types2 = new HashSet<org.jboss.jandex.Type>();
            types2.add(returnType);
            types2.add(OBJECT_TYPE);
            return types2;
        }
        ClassInfo returnTypeClassInfo = IndexClassLookupUtils.getClassByName(beanDeployment.getIndex(), returnType.name());
        if (returnTypeClassInfo == null) {
            throw new IllegalArgumentException("Producer method return type not found in index: " + producerMethod.returnType().name());
        }
        if (Type.Kind.CLASS.equals((Object)returnType.kind())) {
            types = Types.getTypeClosure(returnTypeClassInfo, (AnnotationTarget)producerMethod, Collections.emptyMap(), beanDeployment, null);
        } else if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)returnType.kind())) {
            types = Types.getTypeClosure(returnTypeClassInfo, (AnnotationTarget)producerMethod, Types.buildResolvedMap(returnType.asParameterizedType().arguments(), returnTypeClassInfo.typeParameters(), Collections.emptyMap(), beanDeployment.getIndex()), beanDeployment, null);
        } else {
            throw new IllegalArgumentException("Unsupported return type");
        }
        return Types.restrictBeanTypes(types, beanDeployment.getAnnotations((AnnotationTarget)producerMethod));
    }

    static Set<org.jboss.jandex.Type> getProducerFieldTypeClosure(FieldInfo producerField, BeanDeployment beanDeployment) {
        Set<org.jboss.jandex.Type> types;
        org.jboss.jandex.Type fieldType = producerField.type();
        if (fieldType.kind() == Type.Kind.PRIMITIVE || fieldType.kind() == Type.Kind.ARRAY) {
            types = new HashSet<org.jboss.jandex.Type>();
            types.add(fieldType);
            types.add(OBJECT_TYPE);
        } else {
            ClassInfo fieldClassInfo = IndexClassLookupUtils.getClassByName(beanDeployment.getIndex(), producerField.type().name());
            if (fieldClassInfo == null) {
                throw new IllegalArgumentException("Producer field type not found in index: " + producerField.type().name());
            }
            if (Type.Kind.CLASS.equals((Object)fieldType.kind())) {
                types = Types.getTypeClosure(fieldClassInfo, (AnnotationTarget)producerField, Collections.emptyMap(), beanDeployment, null);
            } else if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)fieldType.kind())) {
                types = Types.getTypeClosure(fieldClassInfo, (AnnotationTarget)producerField, Types.buildResolvedMap(fieldType.asParameterizedType().arguments(), fieldClassInfo.typeParameters(), Collections.emptyMap(), beanDeployment.getIndex()), beanDeployment, null);
            } else {
                throw new IllegalArgumentException("Unsupported return type");
            }
        }
        return Types.restrictBeanTypes(types, beanDeployment.getAnnotations((AnnotationTarget)producerField));
    }

    static Set<org.jboss.jandex.Type> getClassBeanTypeClosure(ClassInfo classInfo, BeanDeployment beanDeployment) {
        List typeParameters = classInfo.typeParameters();
        Set<org.jboss.jandex.Type> types = typeParameters.isEmpty() ? Types.getTypeClosure(classInfo, null, Collections.emptyMap(), beanDeployment, null) : Types.getTypeClosure(classInfo, null, Types.buildResolvedMap(typeParameters, typeParameters, Collections.emptyMap(), beanDeployment.getIndex()), beanDeployment, null);
        return Types.restrictBeanTypes(types, beanDeployment.getAnnotations((AnnotationTarget)classInfo));
    }

    /*
     * Unable to fully structure code
     */
    static Set<org.jboss.jandex.Type> getTypeClosure(ClassInfo classInfo, AnnotationTarget producerFieldOrMethod, Map<TypeVariable, org.jboss.jandex.Type> resolvedTypeParameters, BeanDeployment beanDeployment, BiConsumer<ClassInfo, Map<TypeVariable, org.jboss.jandex.Type>> resolvedTypeVariablesConsumer) {
        types = new HashSet<org.jboss.jandex.Type>();
        typeParameters = classInfo.typeParameters();
        if (typeParameters.isEmpty()) ** GOTO lbl-1000
        if (!typeParameters.stream().allMatch((Predicate<TypeVariable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, containsKey(java.lang.Object ), (Lorg/jboss/jandex/TypeVariable;)Z)(resolvedTypeParameters))) lbl-1000:
        // 2 sources

        {
            types.add(org.jboss.jandex.Type.create((DotName)classInfo.name(), (Type.Kind)Type.Kind.CLASS));
        } else {
            typeParams = new org.jboss.jandex.Type[typeParameters.size()];
            skipThisType = false;
            for (i = 0; i < typeParameters.size(); ++i) {
                typeParams[i] = resolvedTypeParameters.get(typeParameters.get(i));
                if (!typeParams[i].kind().equals((Object)Type.Kind.WILDCARD_TYPE) || producerFieldOrMethod == null) continue;
                Types.LOGGER.info((Object)("Producer " + (producerFieldOrMethod.kind().equals((Object)AnnotationTarget.Kind.FIELD) != false ? "field " : "method ") + producerFieldOrMethod + " contains a parameterized typed with a wildcard. This type is not a legal bean type according to CDI specification and will be ignored during bean resolution."));
                skipThisType = true;
            }
            if (resolvedTypeVariablesConsumer != null) {
                resolved = new HashMap<E, org.jboss.jandex.Type>();
                for (i = 0; i < typeParameters.size(); ++i) {
                    resolved.put(typeParameters.get(i), typeParams[i]);
                }
                resolvedTypeVariablesConsumer.accept(classInfo, resolved);
            }
            if (!skipThisType) {
                types.add((org.jboss.jandex.Type)ParameterizedType.create((DotName)classInfo.name(), (org.jboss.jandex.Type[])typeParams, null));
            }
        }
        for (org.jboss.jandex.Type interfaceType : classInfo.interfaceTypes()) {
            interfaceClassInfo = IndexClassLookupUtils.getClassByName(beanDeployment.getIndex(), interfaceType.name());
            if (interfaceClassInfo == null) continue;
            resolved = Collections.emptyMap();
            if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)interfaceType.kind())) {
                resolved = Types.buildResolvedMap(interfaceType.asParameterizedType().arguments(), interfaceClassInfo.typeParameters(), resolvedTypeParameters, beanDeployment.getIndex());
            }
            types.addAll(Types.getTypeClosure(interfaceClassInfo, producerFieldOrMethod, resolved, beanDeployment, resolvedTypeVariablesConsumer));
        }
        if (classInfo.superClassType() != null && (superClassInfo = IndexClassLookupUtils.getClassByName(beanDeployment.getIndex(), classInfo.superName())) != null) {
            resolved = Collections.emptyMap();
            if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)classInfo.superClassType().kind())) {
                resolved = Types.buildResolvedMap(classInfo.superClassType().asParameterizedType().arguments(), superClassInfo.typeParameters(), resolvedTypeParameters, beanDeployment.getIndex());
            }
            types.addAll(Types.getTypeClosure(superClassInfo, producerFieldOrMethod, resolved, beanDeployment, resolvedTypeVariablesConsumer));
        }
        return types;
    }

    static Map<ClassInfo, Map<TypeVariable, org.jboss.jandex.Type>> resolvedTypeVariables(ClassInfo classInfo, BeanDeployment beanDeployment) {
        HashMap<ClassInfo, Map<TypeVariable, org.jboss.jandex.Type>> resolvedTypeVariables = new HashMap<ClassInfo, Map<TypeVariable, org.jboss.jandex.Type>>();
        Types.getTypeClosure(classInfo, null, Collections.emptyMap(), beanDeployment, resolvedTypeVariables::put);
        return resolvedTypeVariables;
    }

    static Set<org.jboss.jandex.Type> restrictBeanTypes(Set<org.jboss.jandex.Type> types, Collection<AnnotationInstance> annotations) {
        AnnotationInstance typed = annotations.stream().filter(a -> a.name().equals((Object)DotNames.TYPED)).findFirst().orElse(null);
        if (typed != null) {
            AnnotationValue typedValue = typed.value();
            if (typedValue == null) {
                types.clear();
                types.add(OBJECT_TYPE);
            } else {
                HashSet<DotName> typedClasses = new HashSet<DotName>();
                for (org.jboss.jandex.Type type : typedValue.asClassArray()) {
                    typedClasses.add(type.name());
                }
                Iterator<org.jboss.jandex.Type> iterator = types.iterator();
                while (iterator.hasNext()) {
                    if (typedClasses.contains(iterator.next().name())) continue;
                    iterator.remove();
                }
            }
        }
        return types;
    }

    static <T extends org.jboss.jandex.Type> Map<TypeVariable, org.jboss.jandex.Type> buildResolvedMap(List<T> resolvedArguments, List<TypeVariable> typeVariables, Map<TypeVariable, org.jboss.jandex.Type> resolvedTypeParameters, IndexView index) {
        HashMap<TypeVariable, org.jboss.jandex.Type> resolvedMap = new HashMap<TypeVariable, org.jboss.jandex.Type>();
        for (int i = 0; i < resolvedArguments.size(); ++i) {
            resolvedMap.put(typeVariables.get(i), Types.resolveTypeParam((org.jboss.jandex.Type)resolvedArguments.get(i), resolvedTypeParameters, index));
        }
        return resolvedMap;
    }

    static org.jboss.jandex.Type resolveTypeParam(org.jboss.jandex.Type typeParam, Map<TypeVariable, org.jboss.jandex.Type> resolvedTypeParameters, IndexView index) {
        ParameterizedType parameterizedType;
        ClassInfo classInfo;
        if (typeParam.kind() == Type.Kind.TYPE_VARIABLE) {
            return resolvedTypeParameters.getOrDefault(typeParam, typeParam);
        }
        if (typeParam.kind() == Type.Kind.PARAMETERIZED_TYPE && (classInfo = IndexClassLookupUtils.getClassByName(index, (parameterizedType = typeParam.asParameterizedType()).name())) != null) {
            List typeParameters = classInfo.typeParameters();
            List arguments = parameterizedType.arguments();
            Map<TypeVariable, org.jboss.jandex.Type> resolvedMap = Types.buildResolvedMap(arguments, typeParameters, resolvedTypeParameters, index);
            org.jboss.jandex.Type[] typeParams = new org.jboss.jandex.Type[typeParameters.size()];
            for (int i = 0; i < typeParameters.size(); ++i) {
                typeParams[i] = Types.resolveTypeParam((org.jboss.jandex.Type)arguments.get(i), resolvedMap, index);
            }
            return ParameterizedType.create((DotName)parameterizedType.name(), (org.jboss.jandex.Type[])typeParams, null);
        }
        return typeParam;
    }

    static String getPackageName(String className) {
        return (className = className.replace('/', '.')).contains(".") ? className.substring(0, className.lastIndexOf(".")) : "";
    }

    static String getSimpleName(String className) {
        return className.contains(".") ? className.substring(className.lastIndexOf(".") + 1, className.length()) : className;
    }

    static org.jboss.jandex.Type box(org.jboss.jandex.Type type) {
        if (type.kind() == Type.Kind.PRIMITIVE) {
            return Types.box(type.asPrimitiveType().primitive());
        }
        return type;
    }

    static org.jboss.jandex.Type box(PrimitiveType.Primitive primitive) {
        switch (primitive) {
            case BOOLEAN: {
                return org.jboss.jandex.Type.create((DotName)DotNames.BOOLEAN, (Type.Kind)Type.Kind.CLASS);
            }
            case DOUBLE: {
                return org.jboss.jandex.Type.create((DotName)DotNames.DOUBLE, (Type.Kind)Type.Kind.CLASS);
            }
            case FLOAT: {
                return org.jboss.jandex.Type.create((DotName)DotNames.FLOAT, (Type.Kind)Type.Kind.CLASS);
            }
            case LONG: {
                return org.jboss.jandex.Type.create((DotName)DotNames.LONG, (Type.Kind)Type.Kind.CLASS);
            }
            case INT: {
                return org.jboss.jandex.Type.create((DotName)DotNames.INTEGER, (Type.Kind)Type.Kind.CLASS);
            }
            case BYTE: {
                return org.jboss.jandex.Type.create((DotName)DotNames.BYTE, (Type.Kind)Type.Kind.CLASS);
            }
            case CHAR: {
                return org.jboss.jandex.Type.create((DotName)DotNames.CHARACTER, (Type.Kind)Type.Kind.CLASS);
            }
            case SHORT: {
                return org.jboss.jandex.Type.create((DotName)DotNames.SHORT, (Type.Kind)Type.Kind.CLASS);
            }
        }
        throw new IllegalArgumentException("Unsupported primitive: " + primitive);
    }
}

