/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.Arc;
import io.quarkus.arc.Components;
import io.quarkus.arc.ComponentsProvider;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.ObserverInfo;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceImpl;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.objectweb.asm.Type;

public class ComponentsProviderGenerator
extends AbstractGenerator {
    static final String COMPONENTS_PROVIDER_SUFFIX = "_ComponentsProvider";
    static final String SETUP_PACKAGE = Arc.class.getPackage().getName() + ".setup";
    static final String ADD_OBSERVERS = "addObservers";
    static final String ADD_BEANS = "addBeans";
    protected final AnnotationLiteralProcessor annotationLiterals;

    public ComponentsProviderGenerator(AnnotationLiteralProcessor annotationLiterals) {
        this.annotationLiterals = annotationLiterals;
    }

    Collection<ResourceOutput.Resource> generate(String name, BeanDeployment beanDeployment, Map<BeanInfo, String> beanToGeneratedName, Map<ObserverInfo, String> observerToGeneratedName) {
        ResourceClassOutput classOutput = new ResourceClassOutput(true);
        String generatedName = SETUP_PACKAGE + "." + name + COMPONENTS_PROVIDER_SUFFIX;
        ClassCreator componentsProvider = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).interfaces(new Class[]{ComponentsProvider.class}).build();
        MethodCreator getComponents = (MethodCreator)componentsProvider.getMethodCreator("getComponents", Components.class, new Class[0]).setModifiers(1);
        Map<BeanInfo, List<BeanInfo>> beanToInjections = this.initBeanToInjections(beanDeployment);
        ResultHandle beanIdToBeanHandle = getComponents.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
        this.processBeans(componentsProvider, getComponents, beanIdToBeanHandle, beanToInjections, beanToGeneratedName, beanDeployment);
        ResultHandle observersHandle = getComponents.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
        this.processObservers(componentsProvider, getComponents, beanDeployment, beanIdToBeanHandle, observersHandle, observerToGeneratedName);
        ResultHandle contextsHandle = getComponents.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (Map.Entry<ScopeInfo, Function<MethodCreator, ResultHandle>> entry : beanDeployment.getCustomContexts().entrySet()) {
            ResultHandle resultHandle = entry.getValue().apply(getComponents);
            getComponents.invokeInterfaceMethod(MethodDescriptors.LIST_ADD, contextsHandle, new ResultHandle[]{resultHandle});
        }
        ResultHandle transitiveBindingsHandle = getComponents.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (Map.Entry<DotName, Set<AnnotationInstance>> entry : beanDeployment.getTransitiveInterceptorBindings().entrySet()) {
            ResultHandle bindingsHandle = getComponents.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (AnnotationInstance binding : entry.getValue()) {
                ClassInfo bindingClass = beanDeployment.getInterceptorBinding(binding.name());
                getComponents.invokeInterfaceMethod(MethodDescriptors.SET_ADD, bindingsHandle, new ResultHandle[]{this.annotationLiterals.process((BytecodeCreator)getComponents, classOutput, bindingClass, binding, SETUP_PACKAGE)});
            }
            getComponents.invokeInterfaceMethod(MethodDescriptors.MAP_PUT, transitiveBindingsHandle, new ResultHandle[]{getComponents.loadClass(entry.getKey().toString()), bindingsHandle});
        }
        ResultHandle resultHandle = getComponents.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.class, (String)"values", Collection.class, (Class[])new Class[0]), beanIdToBeanHandle, new ResultHandle[0]);
        ResultHandle resultHandle2 = getComponents.newInstance(MethodDescriptor.ofConstructor(Components.class, (Class[])new Class[]{Collection.class, Collection.class, Collection.class, Map.class}), new ResultHandle[]{resultHandle, observersHandle, contextsHandle, transitiveBindingsHandle});
        getComponents.returnValue(resultHandle2);
        componentsProvider.close();
        ArrayList<ResourceOutput.Resource> resources = new ArrayList<ResourceOutput.Resource>();
        for (ResourceOutput.Resource resource : classOutput.getResources()) {
            resources.add(resource);
            resources.add(ResourceImpl.serviceProvider(ComponentsProvider.class.getName(), resource.getName().replace('/', '.').getBytes(Charset.forName("UTF-8"))));
        }
        return resources;
    }

    private void processBeans(ClassCreator componentsProvider, MethodCreator getComponents, ResultHandle beanIdToBeanHandle, Map<BeanInfo, List<BeanInfo>> beanToInjections, Map<BeanInfo, String> beanToGeneratedName, BeanDeployment beanDeployment) {
        HashSet<BeanInfo> processed = new HashSet<BeanInfo>();
        BeanAdder beanAdder = new BeanAdder(componentsProvider, getComponents, processed);
        boolean stuck = false;
        while (!beanToInjections.isEmpty()) {
            if (stuck) {
                throw new IllegalStateException("Circular dependencies not supported: \n" + beanToInjections.entrySet().stream().map(e -> "\t " + e.getKey() + " injected into: " + ((List)e.getValue()).stream().map(b -> b.getBeanClass().toString()).collect(Collectors.joining(", "))).collect(Collectors.joining("\n")));
            }
            stuck = true;
            stuck = this.addBeans(beanAdder, beanToInjections, processed, beanIdToBeanHandle, beanToGeneratedName, b -> !this.isDependency((BeanInfo)b, beanToInjections));
            if (!stuck || !(stuck = this.addBeans(beanAdder, beanToInjections, processed, beanIdToBeanHandle, beanToGeneratedName, b -> {
                if (b.isProducerField() || b.isProducerMethod()) {
                    return false;
                }
                return b.getScope().isNormal() || !this.isDependency((BeanInfo)b, beanToInjections);
            }))) continue;
            stuck = this.addBeans(beanAdder, beanToInjections, processed, beanIdToBeanHandle, beanToGeneratedName, b -> !this.isDependency((BeanInfo)b, beanToInjections) || b.getScope().isNormal());
        }
        for (BeanInfo beanInfo : beanDeployment.getBeans()) {
            if (processed.contains(beanInfo)) continue;
            beanAdder.addBean(beanInfo, beanIdToBeanHandle, beanToGeneratedName);
        }
        for (BeanInfo beanInfo : beanDeployment.getInterceptors()) {
            if (processed.contains(beanInfo)) continue;
            beanAdder.addBean(beanInfo, beanIdToBeanHandle, beanToGeneratedName);
        }
        beanAdder.close();
    }

    private void processObservers(ClassCreator componentsProvider, MethodCreator getComponents, BeanDeployment beanDeployment, ResultHandle beanIdToBeanHandle, ResultHandle observersHandle, Map<ObserverInfo, String> observerToGeneratedName) {
        try (ObserverAdder observerAdder = new ObserverAdder(componentsProvider, getComponents);){
            for (ObserverInfo observer : beanDeployment.getObservers()) {
                observerAdder.addObserver(observer, beanIdToBeanHandle, observersHandle, observerToGeneratedName);
            }
        }
    }

    private Map<BeanInfo, List<BeanInfo>> initBeanToInjections(BeanDeployment beanDeployment) {
        HashMap<BeanInfo, List<BeanInfo>> beanToInjections = new HashMap<BeanInfo, List<BeanInfo>>();
        for (BeanInfo bean : beanDeployment.getBeans()) {
            if (bean.isProducerMethod() || bean.isProducerField()) {
                beanToInjections.computeIfAbsent(bean.getDeclaringBean(), d -> new ArrayList()).add(bean);
            }
            for (Injection injection : bean.getInjections()) {
                for (InjectionPointInfo injectionPoint : injection.injectionPoints) {
                    if (BuiltinBean.resolvesTo(injectionPoint)) continue;
                    beanToInjections.computeIfAbsent(injectionPoint.getResolvedBean(), d -> new ArrayList()).add(bean);
                }
            }
            if (bean.getDisposer() != null) {
                for (InjectionPointInfo injectionPoint : bean.getDisposer().getInjection().injectionPoints) {
                    if (BuiltinBean.resolvesTo(injectionPoint)) continue;
                    beanToInjections.computeIfAbsent(injectionPoint.getResolvedBean(), d -> new ArrayList()).add(bean);
                }
            }
            for (InterceptorInfo interceptor : bean.getBoundInterceptors()) {
                beanToInjections.computeIfAbsent(interceptor, d -> new ArrayList()).add(bean);
            }
        }
        for (InterceptorInfo interceptor : beanDeployment.getInterceptors()) {
            for (Injection injection : interceptor.getInjections()) {
                for (InjectionPointInfo injectionPoint : injection.injectionPoints) {
                    if (BuiltinBean.resolvesTo(injectionPoint)) continue;
                    beanToInjections.computeIfAbsent(injectionPoint.getResolvedBean(), d -> new ArrayList()).add(interceptor);
                }
            }
        }
        return beanToInjections;
    }

    private boolean addBeans(BeanAdder beanAdder, Map<BeanInfo, List<BeanInfo>> beanToInjections, Set<BeanInfo> processed, ResultHandle beanIdToBeanHandle, Map<BeanInfo, String> beanToGeneratedName, Predicate<BeanInfo> filter) {
        boolean stuck = true;
        Iterator<Map.Entry<BeanInfo, List<BeanInfo>>> iterator = beanToInjections.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BeanInfo, List<BeanInfo>> entry = iterator.next();
            BeanInfo bean = entry.getKey();
            if (!filter.test(bean)) continue;
            iterator.remove();
            beanAdder.addBean(bean, beanIdToBeanHandle, beanToGeneratedName);
            processed.add(bean);
            stuck = false;
        }
        return stuck;
    }

    private boolean isDependency(BeanInfo bean, Map<BeanInfo, List<BeanInfo>> beanToInjections) {
        for (Map.Entry<BeanInfo, List<BeanInfo>> entry : beanToInjections.entrySet()) {
            if (!entry.getValue().contains(bean)) continue;
            return true;
        }
        return false;
    }

    static class BeanAdder
    implements AutoCloseable {
        private static final int GROUP_LIMIT = 30;
        private int group = 1;
        private int beansWritten;
        private MethodCreator addBeansMethod;
        private final MethodCreator getComponentsMethod;
        private final ClassCreator componentsProvider;
        private final Set<BeanInfo> processedBeans;

        public BeanAdder(ClassCreator componentsProvider, MethodCreator getComponentsMethod, Set<BeanInfo> processed) {
            this.getComponentsMethod = getComponentsMethod;
            this.componentsProvider = componentsProvider;
            this.processedBeans = processed;
        }

        @Override
        public void close() {
            if (this.addBeansMethod != null) {
                this.addBeansMethod.returnValue(null);
            }
        }

        void addBean(BeanInfo bean, ResultHandle beanIdToBeanHandle, Map<BeanInfo, String> beanToGeneratedName) {
            if (this.addBeansMethod == null || this.beansWritten >= 30) {
                if (this.addBeansMethod != null) {
                    this.addBeansMethod.returnValue(null);
                }
                this.beansWritten = 0;
                this.addBeansMethod = (MethodCreator)this.componentsProvider.getMethodCreator(ComponentsProviderGenerator.ADD_BEANS + this.group++, Void.TYPE, new Class[]{Map.class}).setModifiers(2);
                this.getComponentsMethod.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)this.componentsProvider.getClassName(), (String)this.addBeansMethod.getMethodDescriptor().getName(), Void.TYPE, (Object[])new Object[]{Map.class}), this.getComponentsMethod.getThis(), new ResultHandle[]{beanIdToBeanHandle});
            }
            ++this.beansWritten;
            beanIdToBeanHandle = this.addBeansMethod.getMethodParam(0);
            String beanType = beanToGeneratedName.get(bean);
            if (beanType == null) {
                throw new IllegalStateException("No bean type found for: " + bean);
            }
            List injectionPoints = bean.getInjections().stream().flatMap(i -> i.injectionPoints.stream()).filter(ip -> !BuiltinBean.resolvesTo(ip)).collect(Collectors.toList());
            ArrayList<ResultHandle> params = new ArrayList<ResultHandle>();
            ArrayList<String> paramTypes = new ArrayList<String>();
            if (bean.isProducerMethod() || bean.isProducerField()) {
                if (!this.processedBeans.contains(bean.getDeclaringBean())) {
                    throw new IllegalStateException("Declaring bean of a producer bean is not available - most probaly an unsupported circular dependency use case \n - declaring bean: " + bean.getDeclaringBean() + "\n - producer bean: " + bean);
                }
                params.add(this.addBeansMethod.invokeInterfaceMethod(MethodDescriptors.MAP_GET, beanIdToBeanHandle, new ResultHandle[]{this.addBeansMethod.load(bean.getDeclaringBean().getIdentifier())}));
                paramTypes.add(Type.getDescriptor(Supplier.class));
            }
            for (InjectionPointInfo injectionPoint : injectionPoints) {
                if (this.processedBeans.contains(injectionPoint.getResolvedBean())) {
                    params.add(this.addBeansMethod.invokeInterfaceMethod(MethodDescriptors.MAP_GET, beanIdToBeanHandle, new ResultHandle[]{this.addBeansMethod.load(injectionPoint.getResolvedBean().getIdentifier())}));
                } else {
                    params.add(this.addBeansMethod.newInstance(MethodDescriptors.MAP_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{beanIdToBeanHandle, this.addBeansMethod.load(injectionPoint.getResolvedBean().getIdentifier())}));
                }
                paramTypes.add(Type.getDescriptor(Supplier.class));
            }
            if (bean.getDisposer() != null) {
                for (InjectionPointInfo injectionPoint : bean.getDisposer().getInjection().injectionPoints) {
                    params.add(this.addBeansMethod.newInstance(MethodDescriptors.MAP_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{beanIdToBeanHandle, this.addBeansMethod.load(injectionPoint.getResolvedBean().getIdentifier())}));
                    paramTypes.add(Type.getDescriptor(Supplier.class));
                }
            }
            for (InterceptorInfo interceptor : bean.getBoundInterceptors()) {
                if (this.processedBeans.contains(interceptor)) {
                    params.add(this.addBeansMethod.invokeInterfaceMethod(MethodDescriptors.MAP_GET, beanIdToBeanHandle, new ResultHandle[]{this.addBeansMethod.load(interceptor.getIdentifier())}));
                } else {
                    params.add(this.addBeansMethod.newInstance(MethodDescriptors.MAP_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{beanIdToBeanHandle, this.addBeansMethod.load(interceptor.getIdentifier())}));
                }
                paramTypes.add(Type.getDescriptor(Supplier.class));
            }
            ResultHandle beanInstance = this.addBeansMethod.newInstance(MethodDescriptor.ofConstructor((String)beanType, (String[])paramTypes.toArray(new String[0])), params.toArray(new ResultHandle[0]));
            ResultHandle beanIdHandle = this.addBeansMethod.load(bean.getIdentifier());
            this.addBeansMethod.invokeInterfaceMethod(MethodDescriptors.MAP_PUT, beanIdToBeanHandle, new ResultHandle[]{beanIdHandle, beanInstance});
        }
    }

    static class ObserverAdder
    implements AutoCloseable {
        private static final int GROUP_LIMIT = 30;
        private int group = 1;
        private int observersAdded;
        private MethodCreator addObserversMethod;
        private final MethodCreator getComponentsMethod;
        private final ClassCreator componentsProvider;

        public ObserverAdder(ClassCreator componentsProvider, MethodCreator getComponentsMethod) {
            this.getComponentsMethod = getComponentsMethod;
            this.componentsProvider = componentsProvider;
        }

        @Override
        public void close() {
            if (this.addObserversMethod != null) {
                this.addObserversMethod.returnValue(null);
            }
        }

        void addObserver(ObserverInfo observer, ResultHandle beanIdToBeanHandle, ResultHandle observersHandle, Map<ObserverInfo, String> observerToGeneratedName) {
            if (this.addObserversMethod == null || this.observersAdded >= 30) {
                if (this.addObserversMethod != null) {
                    this.addObserversMethod.returnValue(null);
                }
                this.observersAdded = 0;
                this.addObserversMethod = (MethodCreator)this.componentsProvider.getMethodCreator(ComponentsProviderGenerator.ADD_OBSERVERS + this.group++, Void.TYPE, new Class[]{Map.class, List.class}).setModifiers(2);
                this.getComponentsMethod.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)this.componentsProvider.getClassName(), (String)this.addObserversMethod.getMethodDescriptor().getName(), Void.TYPE, (Object[])new Object[]{Map.class, List.class}), this.getComponentsMethod.getThis(), new ResultHandle[]{beanIdToBeanHandle, observersHandle});
            }
            ++this.observersAdded;
            beanIdToBeanHandle = this.addObserversMethod.getMethodParam(0);
            observersHandle = this.addObserversMethod.getMethodParam(1);
            String observerType = observerToGeneratedName.get(observer);
            List injectionPoints = observer.getInjection().injectionPoints.stream().filter(ip -> !BuiltinBean.resolvesTo(ip)).collect(Collectors.toList());
            ArrayList<ResultHandle> params = new ArrayList<ResultHandle>();
            ArrayList<String> paramTypes = new ArrayList<String>();
            params.add(this.addObserversMethod.invokeInterfaceMethod(MethodDescriptors.MAP_GET, beanIdToBeanHandle, new ResultHandle[]{this.addObserversMethod.load(observer.getDeclaringBean().getIdentifier())}));
            paramTypes.add(Type.getDescriptor(Supplier.class));
            for (InjectionPointInfo injectionPoint : injectionPoints) {
                params.add(this.addObserversMethod.invokeInterfaceMethod(MethodDescriptors.MAP_GET, beanIdToBeanHandle, new ResultHandle[]{this.addObserversMethod.load(injectionPoint.getResolvedBean().getIdentifier())}));
                paramTypes.add(Type.getDescriptor(Supplier.class));
            }
            ResultHandle observerInstance = this.addObserversMethod.newInstance(MethodDescriptor.ofConstructor((String)observerType, (String[])paramTypes.toArray(new String[0])), params.toArray(new ResultHandle[0]));
            this.addObserversMethod.invokeInterfaceMethod(MethodDescriptors.LIST_ADD, observersHandle, new ResultHandle[]{observerInstance});
        }
    }
}

