/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.AnnotationsTransformationContext;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.Transformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;

public class AnnotationStore {
    private final ConcurrentMap<AnnotationTarget, Collection<AnnotationInstance>> transformed;
    private final EnumMap<AnnotationTarget.Kind, List<AnnotationsTransformer>> transformersMap;
    private final BuildExtension.BuildContext buildContext;

    AnnotationStore(Collection<AnnotationsTransformer> transformers, BuildExtension.BuildContext buildContext) {
        if (transformers == null || transformers.isEmpty()) {
            this.transformed = null;
            this.transformersMap = null;
        } else {
            this.transformed = new ConcurrentHashMap<AnnotationTarget, Collection<AnnotationInstance>>();
            this.transformersMap = new EnumMap(AnnotationTarget.Kind.class);
            this.transformersMap.put(AnnotationTarget.Kind.CLASS, this.initTransformers(AnnotationTarget.Kind.CLASS, transformers));
            this.transformersMap.put(AnnotationTarget.Kind.METHOD, this.initTransformers(AnnotationTarget.Kind.METHOD, transformers));
            this.transformersMap.put(AnnotationTarget.Kind.FIELD, this.initTransformers(AnnotationTarget.Kind.FIELD, transformers));
        }
        this.buildContext = buildContext;
    }

    public Collection<AnnotationInstance> getAnnotations(AnnotationTarget target) {
        if (this.transformed != null) {
            return this.transformed.computeIfAbsent(target, this::transform);
        }
        return this.getOriginalAnnotations(target);
    }

    public AnnotationInstance getAnnotation(AnnotationTarget target, DotName name) {
        return Annotations.find(this.getAnnotations(target), name);
    }

    public boolean hasAnnotation(AnnotationTarget target, DotName name) {
        return Annotations.contains(this.getAnnotations(target), name);
    }

    public boolean hasAnyAnnotation(AnnotationTarget target, Iterable<DotName> names) {
        return Annotations.containsAny(this.getAnnotations(target), names);
    }

    private Collection<AnnotationInstance> transform(AnnotationTarget target) {
        Collection<AnnotationInstance> annotations = this.getOriginalAnnotations(target);
        List<AnnotationsTransformer> transformers = this.transformersMap.get(target.kind());
        if (transformers.isEmpty()) {
            return annotations;
        }
        TransformationContextImpl transformationContext = new TransformationContextImpl(this.buildContext, target, annotations);
        for (AnnotationsTransformer transformer : transformers) {
            transformer.transform(transformationContext);
        }
        return transformationContext.getAnnotations();
    }

    private Collection<AnnotationInstance> getOriginalAnnotations(AnnotationTarget target) {
        switch (target.kind()) {
            case CLASS: {
                return target.asClass().classAnnotations();
            }
            case METHOD: {
                return target.asMethod().annotations();
            }
            case FIELD: {
                return target.asField().annotations();
            }
        }
        throw new IllegalArgumentException("Unsupported annotation target");
    }

    private List<AnnotationsTransformer> initTransformers(AnnotationTarget.Kind kind, Collection<AnnotationsTransformer> transformers) {
        ArrayList<AnnotationsTransformer> found = new ArrayList<AnnotationsTransformer>();
        for (AnnotationsTransformer transformer : transformers) {
            if (!transformer.appliesTo(kind)) continue;
            found.add(transformer);
        }
        if (found.isEmpty()) {
            return Collections.emptyList();
        }
        found.sort(BuildExtension::compare);
        return found;
    }

    class TransformationContextImpl
    extends AnnotationsTransformationContext<Collection<AnnotationInstance>>
    implements AnnotationsTransformer.TransformationContext {
        public TransformationContextImpl(BuildExtension.BuildContext buildContext, AnnotationTarget target, Collection<AnnotationInstance> annotations) {
            super(buildContext, target, annotations);
        }

        @Override
        public Transformation transform() {
            return new Transformation((Collection<AnnotationInstance>)new ArrayList<AnnotationInstance>((Collection<AnnotationInstance>)this.getAnnotations()), this.getTarget(), this::setAnnotations);
        }
    }
}

