/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.impl.BeanManagerProvider;
import io.quarkus.arc.impl.BeanMetadataProvider;
import io.quarkus.arc.impl.EventProvider;
import io.quarkus.arc.impl.InjectionPointProvider;
import io.quarkus.arc.impl.InstanceProvider;
import io.quarkus.arc.impl.InterceptedBeanMetadataProvider;
import io.quarkus.arc.impl.ResourceProvider;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanGenerator;
import io.quarkus.arc.processor.BuiltinQualifier;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InjectionTargetInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.Types;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

enum BuiltinBean {
    INSTANCE(ctx -> {
        ResultHandle qualifiers = BeanGenerator.collectQualifiers(ctx.classOutput, ctx.clazzCreator, ctx.beanDeployment, ctx.constructor, ctx.injectionPoint, ctx.annotationLiterals);
        ResultHandle parameterizedType = Types.getTypeHandle((BytecodeCreator)ctx.constructor, ctx.injectionPoint.getRequiredType());
        ResultHandle annotationsHandle = BeanGenerator.collectAnnotations(ctx.classOutput, ctx.clazzCreator, ctx.beanDeployment, ctx.constructor, ctx.injectionPoint, ctx.annotationLiterals);
        ResultHandle javaMemberHandle = BeanGenerator.getJavaMemberHandle(ctx.constructor, ctx.injectionPoint);
        ResultHandle instanceProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(InstanceProvider.class, (Class[])new Class[]{Type.class, Set.class, InjectableBean.class, Set.class, Member.class, Integer.TYPE}), new ResultHandle[]{parameterizedType, qualifiers, ctx.constructor.getThis(), annotationsHandle, javaMemberHandle, ctx.constructor.load(ctx.injectionPoint.getPosition())});
        ResultHandle instanceProviderSupplier = ctx.constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{instanceProvider});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)Supplier.class.getName()), ctx.constructor.getThis(), instanceProviderSupplier);
    }, DotNames.INSTANCE, DotNames.PROVIDER, DotNames.INJECTABLE_INSTANCE),
    INJECTION_POINT(ctx -> {
        ResultHandle injectionPointProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(InjectionPointProvider.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle injectionPointProviderSupplier = ctx.constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{injectionPointProvider});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)Supplier.class.getName()), ctx.constructor.getThis(), injectionPointProviderSupplier);
    }, DotNames.INJECTION_POINT),
    BEAN(ctx -> {
        if (ctx.targetInfo.kind() != InjectionTargetInfo.TargetKind.BEAN) {
            throw new IllegalStateException("Invalid injection target info: " + ctx.targetInfo);
        }
        ResultHandle beanProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(BeanMetadataProvider.class, (Class[])new Class[]{String.class}), new ResultHandle[]{ctx.constructor.load(ctx.targetInfo.asBean().getIdentifier())});
        ResultHandle beanProviderSupplier = ctx.constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{beanProvider});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)Supplier.class.getName()), ctx.constructor.getThis(), beanProviderSupplier);
    }, ip -> BuiltinBean.isCdiAndRawTypeMatches(ip, DotNames.BEAN) && ip.hasDefaultedQualifier(), DotNames.BEAN),
    INTERCEPTED_BEAN(ctx -> {
        if (!(ctx.targetInfo instanceof InterceptorInfo)) {
            throw new IllegalStateException("Invalid injection target info: " + ctx.targetInfo);
        }
        ResultHandle interceptedBeanMetadataProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(InterceptedBeanMetadataProvider.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle interceptedBeanMetadataProviderSupplier = ctx.constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{interceptedBeanMetadataProvider});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)Supplier.class.getName()), ctx.constructor.getThis(), interceptedBeanMetadataProviderSupplier);
    }, ip -> BuiltinBean.isCdiAndRawTypeMatches(ip, DotNames.BEAN) && !ip.hasDefaultedQualifier() && ip.getRequiredQualifiers().size() == 1 && ip.getRequiredQualifiers().iterator().next().name().equals((Object)DotNames.INTERCEPTED), DotNames.BEAN),
    BEAN_MANAGER(ctx -> {
        ResultHandle beanManagerProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(BeanManagerProvider.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle injectionPointProviderSupplier = ctx.constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{beanManagerProvider});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)Supplier.class.getName()), ctx.constructor.getThis(), injectionPointProviderSupplier);
    }, DotNames.BEAN_MANAGER),
    EVENT(ctx -> {
        ResultHandle qualifiers = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
        if (!ctx.injectionPoint.getRequiredQualifiers().isEmpty()) {
            for (AnnotationInstance qualifierAnnotation : ctx.injectionPoint.getRequiredQualifiers()) {
                BuiltinQualifier qualifier = BuiltinQualifier.of(qualifierAnnotation);
                if (qualifier != null) {
                    ctx.constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, qualifiers, new ResultHandle[]{qualifier.getLiteralInstance((BytecodeCreator)ctx.constructor)});
                    continue;
                }
                ClassInfo qualifierClass = ctx.beanDeployment.getQualifier(qualifierAnnotation.name());
                ctx.constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, qualifiers, new ResultHandle[]{ctx.annotationLiterals.process((BytecodeCreator)ctx.constructor, ctx.classOutput, qualifierClass, qualifierAnnotation, Types.getPackageName(ctx.clazzCreator.getClassName()))});
            }
        }
        ResultHandle parameterizedType = Types.getTypeHandle((BytecodeCreator)ctx.constructor, ctx.injectionPoint.getRequiredType());
        ResultHandle eventProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(EventProvider.class, (Class[])new Class[]{Type.class, Set.class}), new ResultHandle[]{parameterizedType, qualifiers});
        ResultHandle eventProviderSupplier = ctx.constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{eventProvider});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)Supplier.class.getName()), ctx.constructor.getThis(), eventProviderSupplier);
    }, DotNames.EVENT),
    RESOURCE(ctx -> {
        ResultHandle annotations = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
        if (!ctx.injectionPoint.getRequiredQualifiers().isEmpty()) {
            for (AnnotationInstance annotation : ctx.injectionPoint.getRequiredQualifiers()) {
                ClassInfo annotationClass = IndexClassLookupUtils.getClassByName(ctx.beanDeployment.getIndex(), annotation.name());
                ctx.constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, annotations, new ResultHandle[]{ctx.annotationLiterals.process((BytecodeCreator)ctx.constructor, ctx.classOutput, annotationClass, annotation, Types.getPackageName(ctx.clazzCreator.getClassName()))});
            }
        }
        ResultHandle parameterizedType = Types.getTypeHandle((BytecodeCreator)ctx.constructor, ctx.injectionPoint.getRequiredType());
        ResultHandle resourceProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(ResourceProvider.class, (Class[])new Class[]{Type.class, Set.class}), new ResultHandle[]{parameterizedType, annotations});
        ResultHandle resourceProviderSupplier = ctx.constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{resourceProvider});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)Supplier.class.getName()), ctx.constructor.getThis(), resourceProviderSupplier);
    }, ip -> ip.getKind() == InjectionPointInfo.InjectionPointKind.RESOURCE, DotNames.OBJECT),
    EVENT_METADATA(ctx -> {}, DotNames.EVENT_METADATA);

    private final DotName[] rawTypeDotNames;
    private final Generator generator;
    private final Predicate<InjectionPointInfo> matcher;

    private BuiltinBean(Generator generator, DotName ... rawTypeDotNames) {
        this(generator, (InjectionPointInfo ip) -> BuiltinBean.isCdiAndRawTypeMatches(ip, rawTypeDotNames), rawTypeDotNames);
    }

    private BuiltinBean(Generator generator, Predicate<InjectionPointInfo> matcher, DotName ... rawTypeDotNames) {
        this.rawTypeDotNames = rawTypeDotNames;
        this.generator = generator;
        this.matcher = matcher;
    }

    boolean matches(InjectionPointInfo injectionPoint) {
        return this.matcher.test(injectionPoint);
    }

    DotName[] getRawTypeDotNames() {
        return this.rawTypeDotNames;
    }

    boolean hasRawTypeDotName(DotName name) {
        for (DotName rawTypeDotName : this.rawTypeDotNames) {
            if (!rawTypeDotName.equals((Object)name)) continue;
            return true;
        }
        return false;
    }

    Generator getGenerator() {
        return this.generator;
    }

    static boolean resolvesTo(InjectionPointInfo injectionPoint) {
        return BuiltinBean.resolve(injectionPoint) != null;
    }

    static BuiltinBean resolve(InjectionPointInfo injectionPoint) {
        for (BuiltinBean bean : BuiltinBean.values()) {
            if (!bean.matches(injectionPoint)) continue;
            return bean;
        }
        return null;
    }

    private static boolean isCdiAndRawTypeMatches(InjectionPointInfo injectionPoint, DotName ... rawTypeDotNames) {
        if (injectionPoint.getKind() != InjectionPointInfo.InjectionPointKind.CDI) {
            return false;
        }
        for (DotName rawTypeDotName : rawTypeDotNames) {
            if (!rawTypeDotName.equals((Object)injectionPoint.getRequiredType().name())) continue;
            return true;
        }
        return false;
    }

    @FunctionalInterface
    static interface Generator {
        public void generate(GeneratorContext var1);
    }

    public static class GeneratorContext {
        final ClassOutput classOutput;
        final BeanDeployment beanDeployment;
        final InjectionPointInfo injectionPoint;
        final ClassCreator clazzCreator;
        final MethodCreator constructor;
        final String providerName;
        final AnnotationLiteralProcessor annotationLiterals;
        final InjectionTargetInfo targetInfo;

        public GeneratorContext(ClassOutput classOutput, BeanDeployment beanDeployment, InjectionPointInfo injectionPoint, ClassCreator clazzCreator, MethodCreator constructor, String providerName, AnnotationLiteralProcessor annotationLiterals, InjectionTargetInfo targetInfo) {
            this.classOutput = classOutput;
            this.beanDeployment = beanDeployment;
            this.injectionPoint = injectionPoint;
            this.clazzCreator = clazzCreator;
            this.constructor = constructor;
            this.providerName = providerName;
            this.annotationLiterals = annotationLiterals;
            this.targetInfo = targetInfo;
        }
    }
}

