/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.impl.ComputingCache;
import io.quarkus.arc.processor.AnnotationLiteralGenerator;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Hashes;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

class AnnotationLiteralProcessor {
    private final ComputingCache<Key, Literal> cache;

    AnnotationLiteralProcessor(boolean shared, Predicate<DotName> applicationClassPredicate) {
        this.cache = shared ? new ComputingCache(key -> new Literal(AnnotationLiteralGenerator.generatedSharedName(key.annotationName), applicationClassPredicate.test(key.annotationName), key.annotationClass.methods().stream().filter(m -> !m.name().equals("<clinit>") && !m.name().equals("<init>")).collect(Collectors.toList()))) : null;
    }

    boolean hasLiteralsToGenerate() {
        return this.cache != null && !this.cache.isEmpty();
    }

    ComputingCache<Key, Literal> getCache() {
        return this.cache;
    }

    ResultHandle process(BytecodeCreator bytecode, ClassOutput classOutput, ClassInfo annotationClass, AnnotationInstance annotationInstance, String targetPackage) {
        Objects.requireNonNull(annotationClass, "Annotation class not available: " + annotationInstance);
        if (this.cache != null) {
            Literal literal = (Literal)this.cache.getValue((Object)new Key(annotationInstance.name(), annotationClass));
            Map annotationValues = annotationInstance.values().stream().collect(Collectors.toMap(AnnotationValue::name, Function.identity()));
            ResultHandle[] constructorParams = new ResultHandle[literal.constructorParams.size()];
            ListIterator<MethodInfo> iterator = literal.constructorParams.listIterator();
            while (iterator.hasNext()) {
                ResultHandle retValue;
                MethodInfo method = iterator.next();
                AnnotationValue value = (AnnotationValue)annotationValues.get(method.name());
                if (value == null) {
                    value = method.defaultValue();
                }
                if (value == null) {
                    throw new IllegalStateException(String.format("Value is not set for %s.%s(). Most probably an older version of Jandex was used to index an application dependency. Make sure that Jandex 2.1+ is used.", method.declaringClass().name(), method.name()));
                }
                constructorParams[iterator.previousIndex()] = retValue = AnnotationLiteralGenerator.loadValue(bytecode, value, annotationClass, method);
            }
            return bytecode.newInstance(MethodDescriptor.ofConstructor((Object)literal.className, (Object[])literal.constructorParams.stream().map(m -> m.returnType().name().toString()).toArray()), constructorParams);
        }
        String literalClassName = AnnotationLiteralGenerator.generatedLocalName(targetPackage, DotNames.simpleName(annotationClass), Hashes.sha1(annotationInstance.toString()));
        AnnotationLiteralGenerator.createAnnotationLiteral(classOutput, annotationClass, annotationInstance, literalClassName);
        return bytecode.newInstance(MethodDescriptor.ofConstructor((String)literalClassName, (String[])new String[0]), new ResultHandle[0]);
    }

    static class Key {
        final DotName annotationName;
        final ClassInfo annotationClass;

        public Key(DotName name, ClassInfo annotationClass) {
            this.annotationName = name;
            this.annotationClass = annotationClass;
        }

        public int hashCode() {
            return Objects.hash(this.annotationName);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return Objects.equals(this.annotationName, other.annotationName);
        }
    }

    static class Literal {
        final String className;
        final boolean isApplicationClass;
        final List<MethodInfo> constructorParams;

        public Literal(String className, boolean isApplicationClass, List<MethodInfo> constructorParams) {
            this.className = className;
            this.isApplicationClass = isApplicationClass;
            this.constructorParams = constructorParams;
        }
    }
}

