/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.AlternativePriorities;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanConfigurator;
import io.quarkus.arc.processor.BeanDefiningAnnotation;
import io.quarkus.arc.processor.BeanDeploymentValidator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.BeanRegistrar;
import io.quarkus.arc.processor.BeanResolver;
import io.quarkus.arc.processor.BeanStream;
import io.quarkus.arc.processor.Beans;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.BytecodeTransformer;
import io.quarkus.arc.processor.ContextConfigurator;
import io.quarkus.arc.processor.ContextRegistrar;
import io.quarkus.arc.processor.DisposerInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InjectionPointModifier;
import io.quarkus.arc.processor.InjectionPointsTransformer;
import io.quarkus.arc.processor.InterceptorBindingRegistrar;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.InterceptorResolver;
import io.quarkus.arc.processor.Interceptors;
import io.quarkus.arc.processor.Methods;
import io.quarkus.arc.processor.ObserverConfigurator;
import io.quarkus.arc.processor.ObserverInfo;
import io.quarkus.arc.processor.ObserverRegistrar;
import io.quarkus.arc.processor.ObserverTransformer;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.arc.processor.StereotypeInfo;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.ResultHandle;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.event.Reception;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.DeploymentException;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class BeanDeployment {
    private static final Logger LOGGER = Logger.getLogger(BeanDeployment.class);
    static final EnumSet<Type.Kind> CLASS_TYPES = EnumSet.of(Type.Kind.CLASS, Type.Kind.PARAMETERIZED_TYPE);
    private final BeanProcessor.BuildContextImpl buildContext;
    private final IndexView index;
    private final Map<DotName, ClassInfo> qualifiers;
    private final Map<DotName, ClassInfo> repeatingQualifierAnnotations;
    private final Map<DotName, ClassInfo> interceptorBindings;
    private final Map<DotName, Set<String>> nonBindingFields;
    private final Map<DotName, Set<AnnotationInstance>> transitiveInterceptorBindings;
    private final Map<DotName, StereotypeInfo> stereotypes;
    private final List<BeanInfo> beans;
    private final List<InterceptorInfo> interceptors;
    private final List<ObserverInfo> observers;
    private final BeanResolver beanResolver;
    private final InterceptorResolver interceptorResolver;
    private final AnnotationStore annotationStore;
    private final InjectionPointModifier injectionPointTransformer;
    private final List<ObserverTransformer> observerTransformers;
    private final Set<DotName> resourceAnnotations;
    private final List<InjectionPointInfo> injectionPoints;
    private final boolean removeUnusedBeans;
    private final List<Predicate<BeanInfo>> unusedExclusions;
    private final Set<BeanInfo> removedBeans;
    private final Map<ScopeInfo, Function<MethodCreator, ResultHandle>> customContexts;
    private final Collection<BeanDefiningAnnotation> beanDefiningAnnotations;
    final boolean transformUnproxyableClasses;
    private final boolean jtaCapabilities;
    private final AlternativePriorities alternativePriorities;

    BeanDeployment(IndexView index, Collection<BeanDefiningAnnotation> additionalBeanDefiningAnnotations, List<AnnotationsTransformer> annotationTransformers) {
        this(index, additionalBeanDefiningAnnotations, annotationTransformers, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, false, null, Collections.emptyMap(), Collections.emptyList(), false, false, null);
    }

    BeanDeployment(IndexView index, Collection<BeanDefiningAnnotation> additionalBeanDefiningAnnotations, List<AnnotationsTransformer> annotationTransformers, List<InjectionPointsTransformer> injectionPointsTransformers, List<ObserverTransformer> observerTransformers, Collection<DotName> resourceAnnotations, BeanProcessor.BuildContextImpl buildContext, boolean removeUnusedBeans, List<Predicate<BeanInfo>> unusedExclusions, Map<DotName, Collection<AnnotationInstance>> additionalStereotypes, List<InterceptorBindingRegistrar> bindingRegistrars, boolean transformUnproxyableClasses, boolean jtaCapabilities, AlternativePriorities alternativePriorities) {
        this.buildContext = buildContext;
        HashSet<BeanDefiningAnnotation> beanDefiningAnnotations = new HashSet<BeanDefiningAnnotation>();
        if (additionalBeanDefiningAnnotations != null) {
            beanDefiningAnnotations.addAll(additionalBeanDefiningAnnotations);
        }
        this.beanDefiningAnnotations = beanDefiningAnnotations;
        this.resourceAnnotations = new HashSet<DotName>(resourceAnnotations);
        this.index = index;
        this.annotationStore = new AnnotationStore(annotationTransformers, buildContext);
        if (buildContext != null) {
            buildContext.putInternal(BuildExtension.Key.ANNOTATION_STORE.asString(), this.annotationStore);
        }
        this.injectionPointTransformer = new InjectionPointModifier(injectionPointsTransformers, buildContext);
        this.observerTransformers = observerTransformers;
        this.removeUnusedBeans = removeUnusedBeans;
        this.unusedExclusions = removeUnusedBeans ? unusedExclusions : null;
        this.removedBeans = new CopyOnWriteArraySet<BeanInfo>();
        this.customContexts = new ConcurrentHashMap<ScopeInfo, Function<MethodCreator, ResultHandle>>();
        this.qualifiers = BeanDeployment.findQualifiers(index);
        this.repeatingQualifierAnnotations = BeanDeployment.findContainerAnnotations(this.qualifiers, index);
        this.buildContextPut(BuildExtension.Key.QUALIFIERS.asString(), Collections.unmodifiableMap(this.qualifiers));
        this.interceptorBindings = BeanDeployment.findInterceptorBindings(index);
        this.nonBindingFields = new HashMap<DotName, Set<String>>();
        for (InterceptorBindingRegistrar registrar : bindingRegistrars) {
            for (Map.Entry<DotName, Set<String>> bindingEntry : registrar.registerAdditionalBindings().entrySet()) {
                DotName dotName = bindingEntry.getKey();
                ClassInfo classInfo = IndexClassLookupUtils.getClassByName(index, dotName);
                if (classInfo == null) continue;
                if (bindingEntry.getValue() != null) {
                    this.nonBindingFields.put(dotName, bindingEntry.getValue());
                }
                this.interceptorBindings.put(dotName, classInfo);
            }
        }
        this.buildContextPut(BuildExtension.Key.INTERCEPTOR_BINDINGS.asString(), Collections.unmodifiableMap(this.interceptorBindings));
        this.stereotypes = BeanDeployment.findStereotypes(index, this.interceptorBindings, beanDefiningAnnotations, this.customContexts, additionalStereotypes, this.annotationStore);
        this.buildContextPut(BuildExtension.Key.STEREOTYPES.asString(), Collections.unmodifiableMap(this.stereotypes));
        this.transitiveInterceptorBindings = BeanDeployment.findTransitiveInterceptorBindigs(this.interceptorBindings.keySet(), index, new HashMap<DotName, Set<AnnotationInstance>>(), this.interceptorBindings, this.annotationStore);
        this.injectionPoints = new CopyOnWriteArrayList<InjectionPointInfo>();
        this.interceptors = new CopyOnWriteArrayList<InterceptorInfo>();
        this.beans = new CopyOnWriteArrayList<BeanInfo>();
        this.observers = new CopyOnWriteArrayList<ObserverInfo>();
        this.beanResolver = new BeanResolver(this);
        this.interceptorResolver = new InterceptorResolver(this);
        this.transformUnproxyableClasses = transformUnproxyableClasses;
        this.jtaCapabilities = jtaCapabilities;
        this.alternativePriorities = alternativePriorities;
    }

    ContextRegistrar.RegistrationContext registerCustomContexts(List<ContextRegistrar> contextRegistrars) {
        ContextRegistrar.RegistrationContext registrationContext = new ContextRegistrar.RegistrationContext(){

            @Override
            public <V> V put(BuildExtension.Key<V> key, V value) {
                return BeanDeployment.this.buildContext.put(key, value);
            }

            @Override
            public <V> V get(BuildExtension.Key<V> key) {
                return BeanDeployment.this.buildContext.get(key);
            }

            @Override
            public ContextConfigurator configure(Class<? extends Annotation> scopeAnnotation) {
                return new ContextConfigurator(scopeAnnotation, c -> {
                    ScopeInfo scope = new ScopeInfo(c.scopeAnnotation, c.isNormal);
                    BeanDeployment.this.beanDefiningAnnotations.add(new BeanDefiningAnnotation(scope.getDotName(), null));
                    BeanDeployment.this.customContexts.put(scope, c.creator);
                });
            }
        };
        for (ContextRegistrar contextRegistrar : contextRegistrars) {
            contextRegistrar.register(registrationContext);
        }
        if (this.buildContext != null) {
            List allScopes = Arrays.stream(BuiltinScope.values()).map(i -> i.getInfo()).collect(Collectors.toList());
            allScopes.addAll(this.customContexts.keySet());
            this.buildContext.putInternal(BuildExtension.Key.SCOPES.asString(), Collections.unmodifiableList(allScopes));
        }
        return registrationContext;
    }

    BeanRegistrar.RegistrationContext registerBeans(List<BeanRegistrar> beanRegistrars) {
        ArrayList<InjectionPointInfo> injectionPoints = new ArrayList<InjectionPointInfo>();
        this.beans.addAll(this.findBeans(BeanDeployment.initBeanDefiningAnnotations(this.beanDefiningAnnotations, this.stereotypes.keySet()), this.observers, injectionPoints, this.jtaCapabilities));
        this.buildContextPut(BuildExtension.Key.BEANS.asString(), Collections.unmodifiableList(this.beans));
        this.buildContextPut(BuildExtension.Key.OBSERVERS.asString(), Collections.unmodifiableList(this.observers));
        this.interceptors.addAll(this.findInterceptors(injectionPoints));
        this.injectionPoints.addAll(injectionPoints);
        this.buildContextPut(BuildExtension.Key.INJECTION_POINTS.asString(), Collections.unmodifiableList(this.injectionPoints));
        return this.registerSyntheticBeans(beanRegistrars, this.buildContext);
    }

    void init(Consumer<BytecodeTransformer> bytecodeTransformerConsumer) {
        long start = System.currentTimeMillis();
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        for (BeanInfo bean : this.beans) {
            bean.init(errors, bytecodeTransformerConsumer, this.transformUnproxyableClasses);
        }
        for (ObserverInfo observer : this.observers) {
            observer.init(errors);
        }
        for (InterceptorInfo interceptor : this.interceptors) {
            interceptor.init(errors, bytecodeTransformerConsumer, this.transformUnproxyableClasses);
        }
        BeanDeployment.processErrors(errors);
        if (this.removeUnusedBeans) {
            long removalStart = System.currentTimeMillis();
            HashSet<BeanInfo> removable = new HashSet<BeanInfo>();
            HashSet<BeanInfo> unusedProducers = new HashSet<BeanInfo>();
            HashSet<BeanInfo> unusedButDeclaresProducer = new HashSet<BeanInfo>();
            List producers = this.beans.stream().filter(b -> b.isProducerMethod() || b.isProducerField()).collect(Collectors.toList());
            List instanceInjectionPoints = this.injectionPoints.stream().filter(BuiltinBean.INSTANCE::matches).collect(Collectors.toList());
            Set injected = this.injectionPoints.stream().map(InjectionPointInfo::getResolvedBean).collect(Collectors.toSet());
            Set declaresProducer = producers.stream().map(BeanInfo::getDeclaringBean).collect(Collectors.toSet());
            Set declaresObserver = this.observers.stream().map(ObserverInfo::getDeclaringBean).collect(Collectors.toSet());
            block3: for (BeanInfo bean : this.beans) {
                if (bean.getName() != null || !bean.isRemovable()) continue;
                for (Predicate<BeanInfo> exclusion : this.unusedExclusions) {
                    if (!exclusion.test(bean)) continue;
                    continue block3;
                }
                if (injected.contains(bean) || declaresObserver.contains(bean)) continue;
                for (InjectionPointInfo injectionPoint : instanceInjectionPoints) {
                    if (!Beans.hasQualifiers(bean, injectionPoint.getRequiredQualifiers()) || !Beans.matchesType(bean, (Type)injectionPoint.getRequiredType().asParameterizedType().arguments().get(0))) continue;
                    continue block3;
                }
                if (declaresProducer.contains(bean)) {
                    unusedButDeclaresProducer.add(bean);
                    continue;
                }
                if (bean.isProducerField() || bean.isProducerMethod()) {
                    unusedProducers.add(bean);
                }
                removable.add(bean);
            }
            if (!unusedProducers.isEmpty()) {
                Map<BeanInfo, List<BeanInfo>> declaringMap = producers.stream().collect(Collectors.groupingBy(BeanInfo::getDeclaringBean));
                for (Map.Entry<BeanInfo, List<BeanInfo>> entry : declaringMap.entrySet()) {
                    BeanInfo declaringBean = entry.getKey();
                    if (!unusedButDeclaresProducer.contains(declaringBean) || !unusedProducers.containsAll((Collection)entry.getValue())) continue;
                    removable.add(declaringBean);
                }
            }
            if (!removable.isEmpty()) {
                this.beans.removeAll(removable);
                this.removedBeans.addAll(removable);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debugf(this.removedBeans.stream().map(b -> "Removed unused " + b).collect(Collectors.joining("\n")), new Object[0]);
                }
            }
            LOGGER.debugf("Removed %s unused beans in %s ms", (long)removable.size(), System.currentTimeMillis() - removalStart);
        }
        this.buildContext.putInternal(BuildExtension.Key.REMOVED_BEANS.asString(), Collections.unmodifiableSet(this.removedBeans));
        LOGGER.debugf("Bean deployment initialized in %s ms", System.currentTimeMillis() - start);
    }

    BeanDeploymentValidator.ValidationContext validate(List<BeanDeploymentValidator> validators, Consumer<BytecodeTransformer> bytecodeTransformerConsumer) {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        this.validateBeans(errors, validators, bytecodeTransformerConsumer);
        ValidationContextImpl validationContext = new ValidationContextImpl(this.buildContext);
        for (Throwable error : errors) {
            validationContext.addDeploymentProblem(error);
        }
        for (BeanDeploymentValidator validator : validators) {
            validator.validate(validationContext);
        }
        return validationContext;
    }

    public Collection<BeanInfo> getBeans() {
        return Collections.unmodifiableList(this.beans);
    }

    public Collection<BeanInfo> getRemovedBeans() {
        return Collections.unmodifiableSet(this.removedBeans);
    }

    public Collection<ClassInfo> getQualifiers() {
        return Collections.unmodifiableCollection(this.qualifiers.values());
    }

    public Collection<ObserverInfo> getObservers() {
        return this.observers;
    }

    public Collection<InterceptorInfo> getInterceptors() {
        return this.interceptors;
    }

    public IndexView getIndex() {
        return this.index;
    }

    BeanResolver getBeanResolver() {
        return this.beanResolver;
    }

    InterceptorResolver getInterceptorResolver() {
        return this.interceptorResolver;
    }

    ClassInfo getQualifier(DotName name) {
        return this.qualifiers.get(name);
    }

    Collection<AnnotationInstance> extractQualifiers(AnnotationInstance annotation) {
        DotName annotationName = annotation.name();
        if (this.qualifiers.get(annotationName) != null) {
            return Collections.singleton(annotation);
        }
        if (this.repeatingQualifierAnnotations.get(annotationName) != null) {
            return new ArrayList<AnnotationInstance>(Arrays.asList(annotation.value().asNestedArray()));
        }
        return Collections.emptyList();
    }

    ClassInfo getInterceptorBinding(DotName name) {
        return this.interceptorBindings.get(name);
    }

    Set<AnnotationInstance> getTransitiveInterceptorBindings(DotName name) {
        return this.transitiveInterceptorBindings.get(name);
    }

    Map<DotName, Set<AnnotationInstance>> getTransitiveInterceptorBindings() {
        return this.transitiveInterceptorBindings;
    }

    StereotypeInfo getStereotype(DotName name) {
        return this.stereotypes.get(name);
    }

    Set<DotName> getResourceAnnotations() {
        return this.resourceAnnotations;
    }

    AnnotationStore getAnnotationStore() {
        return this.annotationStore;
    }

    Collection<AnnotationInstance> getAnnotations(AnnotationTarget target) {
        return this.annotationStore.getAnnotations(target);
    }

    AnnotationInstance getAnnotation(AnnotationTarget target, DotName name) {
        return this.annotationStore.getAnnotation(target, name);
    }

    Map<ScopeInfo, Function<MethodCreator, ResultHandle>> getCustomContexts() {
        return this.customContexts;
    }

    ScopeInfo getScope(DotName scopeAnnotationName) {
        return BeanDeployment.getScope(scopeAnnotationName, this.customContexts);
    }

    Integer computeAlternativePriority(AnnotationTarget target, List<StereotypeInfo> stereotypes) {
        return this.alternativePriorities != null ? this.alternativePriorities.compute(target, stereotypes) : null;
    }

    private void buildContextPut(String key, Object value) {
        if (this.buildContext != null) {
            this.buildContext.putInternal(key, value);
        }
    }

    private static Map<DotName, ClassInfo> findQualifiers(IndexView index) {
        HashMap<DotName, ClassInfo> qualifiers = new HashMap<DotName, ClassInfo>();
        for (AnnotationInstance qualifier : index.getAnnotations(DotNames.QUALIFIER)) {
            qualifiers.put(qualifier.target().asClass().name(), qualifier.target().asClass());
        }
        return qualifiers;
    }

    private static Map<DotName, ClassInfo> findContainerAnnotations(Map<DotName, ClassInfo> qualifiers, IndexView index) {
        HashMap<DotName, ClassInfo> containerAnnotations = new HashMap<DotName, ClassInfo>();
        for (ClassInfo qualifier : qualifiers.values()) {
            AnnotationInstance instance = qualifier.classAnnotation(DotNames.REPEATABLE);
            if (instance == null) continue;
            DotName annotationName = instance.value().asClass().name();
            containerAnnotations.put(annotationName, IndexClassLookupUtils.getClassByName(index, annotationName));
        }
        return containerAnnotations;
    }

    private static Map<DotName, ClassInfo> findInterceptorBindings(IndexView index) {
        HashMap<DotName, ClassInfo> bindings = new HashMap<DotName, ClassInfo>();
        for (AnnotationInstance binding : index.getAnnotations(DotNames.INTERCEPTOR_BINDING)) {
            bindings.put(binding.target().asClass().name(), binding.target().asClass());
        }
        return bindings;
    }

    private static Map<DotName, Set<AnnotationInstance>> findTransitiveInterceptorBindigs(Collection<DotName> initialBindings, IndexView index, Map<DotName, Set<AnnotationInstance>> result, Map<DotName, ClassInfo> interceptorBindings, AnnotationStore annotationStore) {
        for (DotName annotationName : initialBindings) {
            HashSet<AnnotationInstance> transitiveBindings = new HashSet<AnnotationInstance>();
            for (AnnotationInstance bindingCandidate : annotationStore.getAnnotations((AnnotationTarget)interceptorBindings.get(annotationName))) {
                if (interceptorBindings.get(bindingCandidate.name()) == null) continue;
                transitiveBindings.add(bindingCandidate);
            }
            if (transitiveBindings.isEmpty()) continue;
            result.computeIfAbsent(annotationName, k -> new HashSet()).addAll(transitiveBindings);
        }
        for (DotName name : result.keySet()) {
            result.put(name, BeanDeployment.recursiveBuild(name, result));
        }
        return result;
    }

    private static Set<AnnotationInstance> recursiveBuild(DotName name, Map<DotName, Set<AnnotationInstance>> transitiveBindingsMap) {
        Set<AnnotationInstance> result = transitiveBindingsMap.get(name);
        for (AnnotationInstance instance : transitiveBindingsMap.get(name)) {
            if (!transitiveBindingsMap.containsKey(instance.name())) continue;
            result.addAll(BeanDeployment.recursiveBuild(instance.name(), transitiveBindingsMap));
        }
        return result;
    }

    private static Map<DotName, StereotypeInfo> findStereotypes(IndexView index, Map<DotName, ClassInfo> interceptorBindings, Collection<BeanDefiningAnnotation> additionalBeanDefiningAnnotations, Map<ScopeInfo, Function<MethodCreator, ResultHandle>> customContexts, Map<DotName, Collection<AnnotationInstance>> additionalStereotypes, AnnotationStore annotationStore) {
        HashMap<DotName, StereotypeInfo> stereotypes = new HashMap<DotName, StereotypeInfo>();
        ArrayList<AnnotationInstance> stereotypeAnnotations = new ArrayList<AnnotationInstance>(index.getAnnotations(DotNames.STEREOTYPE));
        for (Collection<AnnotationInstance> annotations : additionalStereotypes.values()) {
            stereotypeAnnotations.addAll(annotations);
        }
        for (AnnotationInstance stereotype : stereotypeAnnotations) {
            DotName stereotypeName = stereotype.target().asClass().name();
            ClassInfo stereotypeClass = IndexClassLookupUtils.getClassByName(index, stereotypeName);
            if (stereotypeClass == null) continue;
            boolean isAlternative = false;
            Integer alternativePriority = null;
            ArrayList<ScopeInfo> scopes = new ArrayList<ScopeInfo>();
            ArrayList<AnnotationInstance> bindings = new ArrayList<AnnotationInstance>();
            boolean isNamed = false;
            for (AnnotationInstance annotation : annotationStore.getAnnotations((AnnotationTarget)stereotypeClass)) {
                if (DotNames.ALTERNATIVE.equals((Object)annotation.name())) {
                    isAlternative = true;
                    continue;
                }
                if (interceptorBindings.containsKey(annotation.name())) {
                    bindings.add(annotation);
                    continue;
                }
                if (DotNames.NAMED.equals((Object)annotation.name())) {
                    if (annotation.value() != null && !annotation.value().asString().isEmpty()) {
                        throw new DefinitionException("Stereotype must not declare @Named with a non-empty value: " + stereotypeClass);
                    }
                    isNamed = true;
                    continue;
                }
                if (DotNames.PRIORITY.equals((Object)annotation.name())) {
                    alternativePriority = annotation.value().asInt();
                    continue;
                }
                ScopeInfo scope = BeanDeployment.getScope(annotation.name(), customContexts);
                if (scope == null) continue;
                scopes.add(scope);
            }
            boolean isAdditionalStereotypeBuildItem = additionalStereotypes.containsKey(stereotypeName);
            ScopeInfo scope = BeanDeployment.getValidScope(scopes, (AnnotationTarget)stereotypeClass);
            stereotypes.put(stereotypeName, new StereotypeInfo(scope, bindings, isAlternative, alternativePriority, isNamed, false, isAdditionalStereotypeBuildItem, stereotypeClass));
        }
        if (additionalBeanDefiningAnnotations != null) {
            for (BeanDefiningAnnotation i : additionalBeanDefiningAnnotations) {
                if (i.getDefaultScope() == null) continue;
                ScopeInfo scope = BeanDeployment.getScope(i.getDefaultScope(), customContexts);
                ClassInfo stereotypeClassInfo = IndexClassLookupUtils.getClassByName(index, i.getAnnotation());
                if (stereotypeClassInfo == null) continue;
                stereotypes.put(i.getAnnotation(), new StereotypeInfo(scope, Collections.emptyList(), false, null, false, true, false, stereotypeClassInfo));
            }
        }
        return stereotypes;
    }

    private static ScopeInfo getScope(DotName scopeAnnotationName, Map<ScopeInfo, Function<MethodCreator, ResultHandle>> customContexts) {
        BuiltinScope builtin = BuiltinScope.from(scopeAnnotationName);
        if (builtin != null) {
            return builtin.getInfo();
        }
        for (ScopeInfo customScope : customContexts.keySet()) {
            if (!customScope.getDotName().equals((Object)scopeAnnotationName)) continue;
            return customScope;
        }
        return null;
    }

    static ScopeInfo getValidScope(Collection<ScopeInfo> stereotypeScopes, AnnotationTarget target) {
        switch (stereotypeScopes.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return stereotypeScopes.iterator().next();
            }
        }
        throw new DefinitionException("All stereotypes must specify the same scope or the bean must declare a scope: " + target + " declares scopes " + stereotypeScopes.stream().map(ScopeInfo::getDotName).map(DotName::toString).collect(Collectors.joining(", ")));
    }

    private List<BeanInfo> findBeans(Collection<DotName> beanDefiningAnnotations, List<ObserverInfo> observers, List<InjectionPointInfo> injectionPoints, boolean jtaCapabilities) {
        BeanInfo declaringBean;
        HashSet<ClassInfo> beanClasses = new HashSet<ClassInfo>();
        HashSet<MethodInfo> producerMethods = new HashSet<MethodInfo>();
        HashSet<MethodInfo> disposerMethods = new HashSet<MethodInfo>();
        HashSet<FieldInfo> producerFields = new HashSet<FieldInfo>();
        HashMap<MethodInfo, Set> syncObserverMethods = new HashMap<MethodInfo, Set>();
        HashMap<MethodInfo, Set> asyncObserverMethods = new HashMap<MethodInfo, Set>();
        List realStereotypes = this.stereotypes.entrySet().stream().filter(e -> !((StereotypeInfo)e.getValue()).isAdditionalBeanDefiningAnnotation() && !((StereotypeInfo)e.getValue()).isAdditionalStereotypeBuildItem()).map(Map.Entry::getKey).collect(Collectors.toList());
        for (ClassInfo beanClass : this.index.getKnownClasses()) {
            if (Modifier.isInterface(beanClass.flags()) || DotNames.ENUM.equals((Object)beanClass.superName()) || beanClass.nestingType().equals((Object)ClassInfo.NestingType.ANONYMOUS) || beanClass.nestingType().equals((Object)ClassInfo.NestingType.LOCAL) || beanClass.nestingType().equals((Object)ClassInfo.NestingType.INNER) && !Modifier.isStatic(beanClass.flags())) continue;
            if (!beanClass.hasNoArgsConstructor()) {
                int numberOfConstructorsWithoutInject = 0;
                int numberOfConstructorsWithInject = 0;
                for (MethodInfo m : beanClass.methods()) {
                    if (!m.name().equals("<init>")) continue;
                    if (m.hasAnnotation(DotNames.INJECT)) {
                        ++numberOfConstructorsWithInject;
                        continue;
                    }
                    ++numberOfConstructorsWithoutInject;
                }
                if (numberOfConstructorsWithInject == 0 && numberOfConstructorsWithoutInject != 1) continue;
            }
            if (this.annotationStore.hasAnnotation((AnnotationTarget)beanClass, DotNames.VETOED) || this.annotationStore.hasAnnotation((AnnotationTarget)beanClass, DotNames.INTERCEPTOR) || beanClass.interfaceNames().contains(DotNames.EXTENSION)) continue;
            boolean hasBeanDefiningAnnotation = false;
            if (this.annotationStore.hasAnyAnnotation((AnnotationTarget)beanClass, beanDefiningAnnotations)) {
                hasBeanDefiningAnnotation = true;
                beanClasses.add(beanClass);
            }
            for (MethodInfo methodInfo : beanClass.methods()) {
                if (Methods.isSynthetic(methodInfo) || this.annotationStore.getAnnotations((AnnotationTarget)methodInfo).isEmpty()) continue;
                if (this.annotationStore.hasAnnotation((AnnotationTarget)methodInfo, DotNames.PRODUCES)) {
                    producerMethods.add(methodInfo);
                    if (hasBeanDefiningAnnotation) continue;
                    LOGGER.debugf("Producer method found but %s has no bean defining annotation - using @Dependent", (Object)beanClass);
                    beanClasses.add(beanClass);
                    continue;
                }
                if (!this.annotationStore.hasAnnotation((AnnotationTarget)methodInfo, DotNames.DISPOSES)) continue;
                disposerMethods.add(methodInfo);
            }
            ClassInfo aClass = beanClass;
            HashSet<ClassInfo> hashSet = new HashSet<ClassInfo>();
            HashSet<MethodInfo> methods = new HashSet<MethodInfo>();
            while (aClass != null) {
                if (!hashSet.add(aClass)) continue;
                for (MethodInfo method : aClass.methods()) {
                    if (Methods.isSynthetic(method) || Methods.isOverriden(method, methods)) continue;
                    methods.add(method);
                    if (this.annotationStore.getAnnotations((AnnotationTarget)method).isEmpty()) continue;
                    if (!this.annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.PRODUCES)) {
                        for (AnnotationInstance i : this.annotationStore.getAnnotations((AnnotationTarget)method)) {
                            if (!realStereotypes.contains(i.name())) continue;
                            throw new DefinitionException("Method " + method + " of class " + beanClass + " is not a producer method, but is annotated with a stereotype: " + i.name().toString());
                        }
                    }
                    if (this.annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.OBSERVES)) {
                        syncObserverMethods.computeIfAbsent(method, ignored -> new HashSet()).add(beanClass);
                        if (Modifier.isAbstract(beanClass.flags())) continue;
                        beanClasses.add(beanClass);
                        if (hasBeanDefiningAnnotation) continue;
                        LOGGER.debugf("Observer method found but %s has no bean defining annotation - using @Dependent", (Object)beanClass);
                        continue;
                    }
                    if (!this.annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.OBSERVES_ASYNC)) continue;
                    asyncObserverMethods.computeIfAbsent(method, ignored -> new HashSet()).add(beanClass);
                    if (Modifier.isAbstract(beanClass.flags())) continue;
                    beanClasses.add(beanClass);
                    if (hasBeanDefiningAnnotation) continue;
                    LOGGER.debugf("Observer method found but %s has no bean defining annotation - using @Dependent", (Object)beanClass);
                }
                Type superType = aClass.superClassType();
                aClass = superType != null && !superType.name().equals((Object)DotNames.OBJECT) && CLASS_TYPES.contains(superType.kind()) ? IndexClassLookupUtils.getClassByName(this.index, superType.name()) : null;
            }
            for (FieldInfo field : beanClass.fields()) {
                if (this.annotationStore.hasAnnotation((AnnotationTarget)field, DotNames.PRODUCES)) {
                    if (this.annotationStore.hasAnnotation((AnnotationTarget)field, DotNames.INJECT)) {
                        throw new DefinitionException("Injected field cannot be annotated with @Produces: " + field);
                    }
                    producerFields.add(field);
                    if (hasBeanDefiningAnnotation) continue;
                    LOGGER.debugf("Producer field found but %s has no bean defining annotation - using @Dependent", (Object)beanClass);
                    beanClasses.add(beanClass);
                    continue;
                }
                for (AnnotationInstance i : this.annotationStore.getAnnotations((AnnotationTarget)field)) {
                    if (!realStereotypes.contains(i.name())) continue;
                    throw new DefinitionException("Field " + field + " of class " + beanClass + " is not a producer field, but is annotated with a stereotype: " + i.name().toString());
                }
            }
        }
        ArrayList<BeanInfo> beans = new ArrayList<BeanInfo>();
        HashMap<ClassInfo, BeanInfo> beanClassToBean = new HashMap<ClassInfo, BeanInfo>();
        for (ClassInfo beanClass : beanClasses) {
            BeanInfo beanInfo = Beans.createClassBean(beanClass, this, this.injectionPointTransformer);
            if (beanInfo == null) continue;
            beans.add(beanInfo);
            beanClassToBean.put(beanClass, beanInfo);
            injectionPoints.addAll(beanInfo.getAllInjectionPoints());
        }
        ArrayList<DisposerInfo> disposers = new ArrayList<DisposerInfo>();
        for (MethodInfo methodInfo : disposerMethods) {
            declaringBean = (BeanInfo)beanClassToBean.get(methodInfo.declaringClass());
            if (declaringBean == null) continue;
            Injection injection = Injection.forDisposer(methodInfo, declaringBean.getImplClazz(), this, this.injectionPointTransformer);
            disposers.add(new DisposerInfo(declaringBean, methodInfo, injection));
            injectionPoints.addAll(injection.injectionPoints);
        }
        for (MethodInfo methodInfo : producerMethods) {
            BeanInfo producerMethodBean;
            declaringBean = (BeanInfo)beanClassToBean.get(methodInfo.declaringClass());
            if (declaringBean == null || (producerMethodBean = Beans.createProducerMethod(methodInfo, declaringBean, this, this.findDisposer(declaringBean, (AnnotationTarget)methodInfo, disposers), this.injectionPointTransformer)) == null) continue;
            beans.add(producerMethodBean);
            injectionPoints.addAll(producerMethodBean.getAllInjectionPoints());
        }
        for (FieldInfo fieldInfo : producerFields) {
            BeanInfo producerFieldBean;
            declaringBean = (BeanInfo)beanClassToBean.get(fieldInfo.declaringClass());
            if (declaringBean == null || (producerFieldBean = Beans.createProducerField(fieldInfo, declaringBean, this, this.findDisposer(declaringBean, (AnnotationTarget)fieldInfo, disposers))) == null) continue;
            beans.add(producerFieldBean);
        }
        for (Map.Entry entry : syncObserverMethods.entrySet()) {
            this.registerObserverMethods((Collection)entry.getValue(), observers, injectionPoints, beanClassToBean, (MethodInfo)entry.getKey(), false, this.observerTransformers, jtaCapabilities);
        }
        for (Map.Entry entry : asyncObserverMethods.entrySet()) {
            this.registerObserverMethods((Collection)entry.getValue(), observers, injectionPoints, beanClassToBean, (MethodInfo)entry.getKey(), true, this.observerTransformers, jtaCapabilities);
        }
        if (LOGGER.isTraceEnabled()) {
            for (BeanInfo beanInfo : beans) {
                LOGGER.logf(Logger.Level.TRACE, "Created %s", (Object)beanInfo);
            }
        }
        return beans;
    }

    private void registerObserverMethods(Collection<ClassInfo> beanClasses, List<ObserverInfo> observers, List<InjectionPointInfo> injectionPoints, Map<ClassInfo, BeanInfo> beanClassToBean, MethodInfo observerMethod, boolean async, List<ObserverTransformer> observerTransformers, boolean jtaCapabilities) {
        for (ClassInfo beanClass : beanClasses) {
            Injection injection;
            ObserverInfo observer;
            BeanInfo declaringBean = beanClassToBean.get(beanClass);
            if (declaringBean == null || (observer = ObserverInfo.create(declaringBean, observerMethod, injection = Injection.forObserver(observerMethod, declaringBean.getImplClazz(), this, this.injectionPointTransformer), async, observerTransformers, this.buildContext, jtaCapabilities)) == null) continue;
            observers.add(observer);
            injectionPoints.addAll(injection.injectionPoints);
        }
    }

    private DisposerInfo findDisposer(BeanInfo declaringBean, AnnotationTarget annotationTarget, List<DisposerInfo> disposers) {
        Type beanType;
        List allAnnotations;
        ArrayList<DisposerInfo> found = new ArrayList<DisposerInfo>();
        HashSet<AnnotationInstance> qualifiers = new HashSet<AnnotationInstance>();
        if (AnnotationTarget.Kind.FIELD.equals((Object)annotationTarget.kind())) {
            allAnnotations = annotationTarget.asField().annotations();
            beanType = annotationTarget.asField().type();
        } else if (AnnotationTarget.Kind.METHOD.equals((Object)annotationTarget.kind())) {
            allAnnotations = annotationTarget.asMethod().annotations();
            beanType = annotationTarget.asMethod().returnType();
        } else {
            throw new RuntimeException("Unsupported annotation target: " + annotationTarget);
        }
        allAnnotations.forEach(a -> this.extractQualifiers((AnnotationInstance)a).forEach(qualifiers::add));
        for (DisposerInfo disposer : disposers) {
            if (!disposer.getDeclaringBean().equals(declaringBean)) continue;
            boolean hasQualifier = true;
            for (AnnotationInstance disposerQualifier : disposer.getDisposedParameterQualifiers()) {
                if (Beans.hasQualifier(this.getQualifier(disposerQualifier.name()), disposerQualifier, qualifiers)) continue;
                hasQualifier = false;
            }
            if (!hasQualifier || !this.beanResolver.matches(beanType, disposer.getDisposedParameterType())) continue;
            found.add(disposer);
        }
        if (found.size() > 1) {
            throw new DefinitionException("Multiple disposer methods found for " + annotationTarget);
        }
        return found.isEmpty() ? null : (DisposerInfo)found.get(0);
    }

    public static Set<DotName> initBeanDefiningAnnotations(Collection<BeanDefiningAnnotation> additionalBeanDefiningAnnotations, Set<DotName> stereotypes) {
        HashSet<DotName> beanDefiningAnnotations = new HashSet<DotName>();
        for (BuiltinScope scope : BuiltinScope.values()) {
            beanDefiningAnnotations.add(scope.getInfo().getDotName());
        }
        if (additionalBeanDefiningAnnotations != null) {
            for (BeanDefiningAnnotation additional : additionalBeanDefiningAnnotations) {
                beanDefiningAnnotations.add(additional.getAnnotation());
            }
        }
        beanDefiningAnnotations.addAll(stereotypes);
        return beanDefiningAnnotations;
    }

    private BeanRegistrar.RegistrationContext registerSyntheticBeans(List<BeanRegistrar> beanRegistrars, BuildExtension.BuildContext buildContext) {
        BeanRegistrationContextImpl context = new BeanRegistrationContextImpl(buildContext, this);
        for (BeanRegistrar registrar : beanRegistrars) {
            registrar.register(context);
        }
        return context;
    }

    ObserverRegistrar.RegistrationContext registerSyntheticObservers(List<ObserverRegistrar> observerRegistrars) {
        ObserverRegistrationContextImpl context = new ObserverRegistrationContextImpl(this.buildContext, this);
        for (ObserverRegistrar registrar : observerRegistrars) {
            context.extension = registrar;
            registrar.register(context);
            context.extension = null;
        }
        return context;
    }

    private void addSyntheticBean(BeanInfo bean) {
        this.beans.add(bean);
    }

    private void addSyntheticObserver(ObserverConfigurator configurator) {
        this.observers.add(ObserverInfo.create(this, configurator.beanClass, null, null, null, null, configurator.observedType, configurator.observedQualifiers, Reception.ALWAYS, configurator.transactionPhase, configurator.isAsync, configurator.priority, this.observerTransformers, this.buildContext, this.jtaCapabilities, configurator.notifyConsumer));
    }

    static void processErrors(List<Throwable> errors) {
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                Throwable error = errors.get(0);
                if (error instanceof DeploymentException) {
                    throw (DeploymentException)error;
                }
                if (error instanceof DefinitionException) {
                    throw (DefinitionException)error;
                }
                throw new DeploymentException(errors.get(0));
            }
            StringBuilder message = new StringBuilder("Found " + errors.size() + " deployment problems: ");
            int idx = 1;
            for (Throwable error : errors) {
                message.append("\n").append("[").append(idx++).append("] ").append(error.getMessage());
            }
            DeploymentException deploymentException = new DeploymentException(message.toString());
            for (Throwable error : errors) {
                deploymentException.addSuppressed(error);
            }
            throw deploymentException;
        }
    }

    private List<InterceptorInfo> findInterceptors(List<InjectionPointInfo> injectionPoints) {
        HashSet<ClassInfo> interceptorClasses = new HashSet<ClassInfo>();
        for (AnnotationInstance annotation : this.index.getAnnotations(DotNames.INTERCEPTOR)) {
            if (!AnnotationTarget.Kind.CLASS.equals((Object)annotation.target().kind())) continue;
            interceptorClasses.add(annotation.target().asClass());
        }
        ArrayList<InterceptorInfo> interceptors = new ArrayList<InterceptorInfo>();
        for (ClassInfo interceptorClass : interceptorClasses) {
            if (this.annotationStore.hasAnnotation((AnnotationTarget)interceptorClass, DotNames.VETOED)) continue;
            interceptors.add(Interceptors.createInterceptor(interceptorClass, this, this.injectionPointTransformer, this.annotationStore));
        }
        if (LOGGER.isTraceEnabled()) {
            for (InterceptorInfo interceptor : interceptors) {
                LOGGER.logf(Logger.Level.TRACE, "Created %s", (Object)interceptor);
            }
        }
        for (InterceptorInfo interceptor : interceptors) {
            injectionPoints.addAll(interceptor.getAllInjectionPoints());
        }
        return interceptors;
    }

    private void validateBeans(List<Throwable> errors, List<BeanDeploymentValidator> validators, Consumer<BytecodeTransformer> bytecodeTransformerConsumer) {
        HashMap<String, ArrayList<BeanInfo>> namedBeans = new HashMap<String, ArrayList<BeanInfo>>();
        for (BeanInfo beanInfo : this.beans) {
            if (beanInfo.getName() != null) {
                ArrayList<BeanInfo> named = (ArrayList<BeanInfo>)namedBeans.get(beanInfo.getName());
                if (named == null) {
                    named = new ArrayList<BeanInfo>();
                    namedBeans.put(beanInfo.getName(), named);
                }
                named.add(beanInfo);
            }
            beanInfo.validate(errors, validators, bytecodeTransformerConsumer);
        }
        if (!namedBeans.isEmpty()) {
            for (Map.Entry entry : namedBeans.entrySet()) {
                if (((List)entry.getValue()).size() <= 1 || Beans.resolveAmbiguity((List)entry.getValue()) != null) continue;
                errors.add((Throwable)new DeploymentException("Unresolvable ambiguous bean name detected: " + (String)entry.getKey() + "\nBeans:\n" + ((List)entry.getValue()).stream().map(Object::toString).collect(Collectors.joining("\n"))));
            }
        }
    }

    public Set<String> getNonBindingFields(DotName name) {
        return this.nonBindingFields.getOrDefault(name, Collections.emptySet());
    }

    static abstract class RegistrationContextImpl
    implements BuildExtension.BuildContext {
        protected final BuildExtension.BuildContext parent;
        protected final BeanDeployment beanDeployment;
        protected BuildExtension extension;

        RegistrationContextImpl(BuildExtension.BuildContext buildContext, BeanDeployment beanDeployment) {
            this.parent = buildContext;
            this.beanDeployment = beanDeployment;
        }

        @Override
        public <V> V get(BuildExtension.Key<V> key) {
            return this.parent.get(key);
        }

        @Override
        public <V> V put(BuildExtension.Key<V> key, V value) {
            return this.parent.put(key, value);
        }

        public BeanStream beans() {
            return new BeanStream(this.get(BuildExtension.Key.BEANS));
        }
    }

    private static class ObserverRegistrationContextImpl
    extends RegistrationContextImpl
    implements ObserverRegistrar.RegistrationContext {
        ObserverRegistrationContextImpl(BuildExtension.BuildContext buildContext, BeanDeployment beanDeployment) {
            super(buildContext, beanDeployment);
        }

        @Override
        public ObserverConfigurator configure() {
            ObserverConfigurator configurator = new ObserverConfigurator(x$0 -> this.beanDeployment.addSyntheticObserver(x$0));
            if (this.extension != null) {
                configurator.beanClass(DotName.createSimple((String)this.extension.getClass().getName()));
            }
            return configurator;
        }

        @Override
        public BeanStream beans() {
            return new BeanStream(this.get(BuildExtension.Key.BEANS));
        }
    }

    private static class BeanRegistrationContextImpl
    extends RegistrationContextImpl
    implements BeanRegistrar.RegistrationContext {
        BeanRegistrationContextImpl(BuildExtension.BuildContext buildContext, BeanDeployment beanDeployment) {
            super(buildContext, beanDeployment);
        }

        @Override
        public <T> BeanConfigurator<T> configure(DotName beanClassName) {
            return new BeanConfigurator(beanClassName, this.beanDeployment, x$0 -> this.beanDeployment.addSyntheticBean(x$0));
        }
    }

    private static class ValidationContextImpl
    implements BeanDeploymentValidator.ValidationContext {
        private final BuildExtension.BuildContext buildContext;
        private final List<Throwable> errors;

        public ValidationContextImpl(BuildExtension.BuildContext buildContext) {
            this.buildContext = buildContext;
            this.errors = new ArrayList<Throwable>();
        }

        @Override
        public <V> V get(BuildExtension.Key<V> key) {
            return this.buildContext.get(key);
        }

        @Override
        public <V> V put(BuildExtension.Key<V> key, V value) {
            return this.buildContext.put(key, value);
        }

        @Override
        public void addDeploymentProblem(Throwable problem) {
            this.errors.add(problem);
        }

        @Override
        public List<Throwable> getDeploymentProblems() {
            return Collections.unmodifiableList(this.errors);
        }

        @Override
        public BeanStream beans() {
            return new BeanStream(this.get(BuildExtension.Key.BEANS));
        }

        @Override
        public BeanStream removedBeans() {
            return new BeanStream(this.get(BuildExtension.Key.REMOVED_BEANS));
        }
    }
}

