/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.DecoratorInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InjectionPointModifier;
import io.quarkus.arc.processor.Types;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.DefinitionException;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

final class Decorators {
    static final Logger LOGGER = Logger.getLogger(Decorators.class);

    private Decorators() {
    }

    static DecoratorInfo createDecorator(ClassInfo decoratorClass, BeanDeployment beanDeployment, InjectionPointModifier transformer, AnnotationStore store) {
        LinkedList<InjectionPointInfo> delegateInjectionPoints = new LinkedList<InjectionPointInfo>();
        List<Injection> injections = Injection.forBean((AnnotationTarget)decoratorClass, null, beanDeployment, transformer);
        for (Injection injection : injections) {
            for (InjectionPointInfo injectionPointInfo : injection.injectionPoints) {
                if (!injectionPointInfo.isDelegate()) continue;
                delegateInjectionPoints.add(injectionPointInfo);
            }
        }
        if (delegateInjectionPoints.isEmpty()) {
            throw new DefinitionException("The decorator " + decoratorClass + " has no @Delegate injection point");
        }
        if (delegateInjectionPoints.size() > 1) {
            throw new DefinitionException("The decorator " + decoratorClass + " has multiple @Delegate injection points: " + delegateInjectionPoints);
        }
        InjectionPointInfo delegateInjectionPoint = (InjectionPointInfo)delegateInjectionPoints.get(0);
        Integer priority = 0;
        boolean priorityDeclared = false;
        for (AnnotationInstance annotation : store.getAnnotations((AnnotationTarget)decoratorClass)) {
            if (!annotation.name().equals((Object)DotNames.PRIORITY)) continue;
            priority = annotation.value().asInt();
            priorityDeclared = true;
        }
        Set<Type> set = Types.getClassBeanTypeClosure(decoratorClass, beanDeployment);
        HashSet<Type> decoratedTypes = new HashSet<Type>();
        for (Type type : set) {
            ClassInfo clazz;
            if (type.name().equals((Object)DotNames.SERIALIZABLE) || !Modifier.isInterface((clazz = beanDeployment.getBeanArchiveIndex().getClassByName(type.name())).flags())) continue;
            decoratedTypes.add(type);
        }
        if (decoratedTypes.isEmpty()) {
            throw new DefinitionException("The decorator " + decoratorClass + " has no decorated type");
        }
        Set<Type> delegateTypes = Types.getDelegateTypeClosure(delegateInjectionPoint, beanDeployment);
        for (Type decoratedType : decoratedTypes) {
            if (delegateTypes.contains(decoratedType)) continue;
            throw new DefinitionException("The delegate type " + delegateInjectionPoint.getRequiredType() + " does not implement the decorated type: " + decoratedType);
        }
        if (!priorityDeclared) {
            LOGGER.info((Object)("The decorator " + decoratorClass + " does not declare any @Priority. It will be assigned a default priority value of 0."));
        }
        if (Modifier.isAbstract(decoratorClass.flags())) {
            ArrayList<MethodInfo> arrayList = new ArrayList<MethodInfo>();
            for (MethodInfo method : decoratorClass.methods()) {
                if (!Modifier.isAbstract(method.flags())) continue;
                arrayList.add(method);
            }
            if (!arrayList.isEmpty()) {
                throw new DefinitionException("An abstract decorator " + decoratorClass + " declares abstract methods: " + arrayList);
            }
        }
        return new DecoratorInfo((AnnotationTarget)decoratorClass, beanDeployment, delegateInjectionPoint, decoratedTypes, injections, priority);
    }
}

